dofile("script/rooms/defaults/room1_defaults.lua")

levelDesc.name = "room1_5"
levelDesc.musicMood = 1
levelDesc.values.maxTraySize = 4
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	--14000
		{ trigger="spawn",	delay=13000,	place="table",		size=2,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=14000,		place="counter",},	
		{ trigger = "startEvent", delay=500},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",		size=3,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	--14000
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=16000,	place="table",		size=2,},
		{ trigger="spawn",	delay=4000,		place="counter",},	--14000
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=16000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",		size=3,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=16000,	place="counter",},	
		{ trigger="spawn",	delay=16000,	place="table",		size=1,},
		{ trigger="spawn",	delay=14000,	place="table",		size=3,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	--14000
		{ trigger="spawn",	delay=14000,	place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

--levelDesc.eventPositiveTextIds = {"R1_D09_DAY_START2", "R1_D09_DAY_START3"}
--levelDesc.eventNegativeTextIds = {"R1_D09_DAY_START5", "R1_D09_DAY_START6"}

levelDesc.eventDesc =
{
	class="ShoutAndMakeEvent",
	bar = "progressbar_big",
	eventBarImage = "CHALLENGE_ICON4",
	productPool = {"#cheesecake", "#tea", "#brushetta#tomato#olive", "#macaroon", "#newspaper", "#brushetta#lettuce#tomato#olive"},

	numProductsPerOrder = 2,
	numOrders = 8,
	scoreOneDone = 12.5,	-- 200
	scoreAllDone = 100,	-- 300 total
	timeUntilFirstOrder = 2000,
	timeUntilNextOrder = 15000,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 2,
	limitToMaxGroupCount = true,
	floatersFromHero = true,
	eventWonDelay = 2000,
	items =
	{
		{ obj="table5", barPos = {x=33, y=-70}, timeUntilEnd=250000, },
	},

	onInitialized = function(event)
		ShoutAndMakeEvent.onInitialized(event)
		levelDesc.eventTable = level:getObject("table5")
		if (levelDesc.eventTable) then
			levelDesc.eventTable.usedInGameplay = false
			levelDesc.eventTable.clickable = false
		end
	end,

	eventEnd = function(self)
		stopEating()
		if (levelDesc.eventTable) then
			levelDesc.eventTable.plateState = "empty"
			--'levelDesc.eventTable.usedInGameplay = true
			--'levelDesc.eventTable.clickable = true
		end
	end,
}

function stopEating()
	if (event.eating) then
		event.eating = false
		level:getCharacter("jimmy"):playAnimation("order")
	end
end

levelDesc.old_onDeliver = levelDesc.onDeliver
function levelDesc:onDeliver(order, matched, owner)
	if (levelDesc.old_onDeliver) then
		levelDesc:old_onDeliver(order, matched, owner)		
	end

	if (owner.obj and owner.obj.name == "table5" and not event.completed and #matched > 0) then
		local consume = levelDesc.productSettings[matched[1]].consumeAnimation
		if (consume) then
			event.eating = true
			if (consume == "eat" or consume == "drink") then
				levelDesc.eventTable.plateState = "full"
			end
			local jimmy = level:getCharacter("jimmy")
			jimmy:playAnimation(consume, -1)
			--' let jimmy say something
			--'local text = self.eventPositiveTextIds[math.Random(#self.eventPositiveTextIds)]
			--'jimmy:addTask({class="MessageTask", textId=text, duration="2000", needsClick=false, })
			--'event.nextOrderTimer = event.timeUntilNextOrder
		end
	end
end

function levelDesc:onNextOrderTimerDone()
	--' let jimmy say something
	--print("eventNegativeTextIds!!!!!!!!")
	--local text = self.eventNegativeTextIds[math.Random(#self.eventNegativeTextIds)]
	--level:getCharacter("jimmy"):addTask({class="MessageTask", textId=text, duration="2000", needsClick=false, })
end

function levelDesc:onProductAdded()
	level:getCharacter("jimmy"):playAnimation("order", -1)
end