dofile("script/rooms/defaults/room1_defaults.lua")

levelDesc.name = "room1_3"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 3
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="table",		size=2,},	--counter, 12000 Tjien
		{ trigger="spawn",	delay=9000,		place="table",			size=1,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger = "startEvent", delay=7000},					--1000 Tjien
		{ trigger="spawn",	delay=5000,		place="counter",},		--15000
		{ trigger="spawn",	delay=1000,		place="counter",},	--16000
		{ trigger="spawn",	delay=14000,	place="table",		size=2,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",		size=3,},
		{ trigger="spawn",	delay=8000,		place="counter",},		--16000
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",		size=1,}, --14000 Tjien
		{ trigger="spawn",	delay=12000,	place="counter",},	--15000
		{ trigger="spawn",	delay=3000,		place="counter",},	--14000
		{ trigger="spawn",	delay=16000,	place="table",		size=2,},
		{ trigger="spawn",	delay=16000,	place="table",		size=2,},
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},
		{ trigger="spawn",	delay=15000,	place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

function levelDesc:onLevelInitialized()
	self.class.onLevelInitialized(self)
	level:getObject("letter"):stopEffect()
end

function levelDesc.fixEventUpdateText(progress)	
	local textPos = math.max(1, levelDesc.fixEventTextLength * math.min(1, (progress*1.45)))
	if (levelDesc.fixEventTextPos ~= textPos) then
		levelDesc.fixEventTextPos = textPos
		local text = string.sub(levelDesc.fixEventText, 1, textPos)
		levelDesc.fixEventDialog:getChild("message").text = text
	end
end

function levelDesc:showLetter(actor)
	actor:addTaskAtFront({class="MessageTask", textId=event.letterTexts[event.curTextIdx], duration=2000, needsClick=false,})
	--[[return actor:showMessageDialog({dialogId="fixEventMessage", text=levelDesc.fixEventText,
		tipType="bubble", tipSide="right", anchor="topLeft",
		maxLineCount=50, labelWidth=200, labelX=-97, --' TODO: Check how this can be done better.
		doPopIn=false, doPopOut=false, })]]
end

function levelDesc.fixEventOnWorkStart(self, task)
	event.curTextIdx = event.curTextIdx + 1

	level:getObject("letter").visible = false

	levelDesc.fixEventText = ghf.getText(event.letterTexts[event.curTextIdx])
	levelDesc.fixEventTextLength = string.len(levelDesc.fixEventText)

	levelDesc.fixEventTextPos = -1
	levelDesc.fixEventDialog = level:showLetter(task.actor)
	levelDesc.fixEventUpdateText(self.item.bar.progress or 0)

	eventBar:hideCallOut()

	return FixEvent.fixEventOnWorkStart(self, task)
end

function levelDesc.fixEventOnWorkUpdate(self, task, time)
	local result = FixEvent.fixEventOnWorkUpdate(self, task, time)
	if (not result) then
		levelDesc.fixEventUpdateText(self.item.bar.progress or 0)
	end
	return level.hasShiftFinished or result
end

function levelDesc.fixEventOnWorkFinish(self, task)
	task.actor:removeMessageDialog("fixEventMessage")
	level:getObject("letter").visible = true
	return FixEvent.fixEventOnWorkFinish(self, task)
end

function levelDesc.fixEventOnWorkCancel(self, task)
	task.actor:removeMessageDialog("fixEventMessage")
	level:getObject("letter").visible = true
	return FixEvent.fixEventOnWorkCancel(self, task)
end

levelDesc.eventDesc =
{
	class="FixEvent",
	bar="progressbar_click_fix",
	--customCursor = {image="CLEANING:icons", x=25, y=25, frameTime=120, mousePointer="none"},	
	hintArrowDesc = {hintId="love_letter", parent="letter", x=0, y=0},
	scoreOneDone = 25,
	scoreAllDone = 400,
	letterTexts = {"R1_D03_EVENT_START2", "R1_D03_EVENT_START3", "R1_D03_EVENT_START3b", "R1_D03_EVENT_START4", "R1_D03_EVENT_START5"},
	curTextIdx = 0,
	fixEventOnWorkStart = levelDesc.fixEventOnWorkStart,
	fixEventOnWorkUpdate = levelDesc.fixEventOnWorkUpdate,
	fixEventOnWorkFinish = levelDesc.fixEventOnWorkFinish,
	allowCancel = false,
	callOutIcon = "call_out_500:icons",

	onStart = function(self)
		FixEvent.onStart(self)
		level:getObject("letter").effectEnabled = true
		level:getObject("letter"):startEffect()
	end,
	
	eventEnd = function(self)
		FixEvent.eventEnd(self)
		level:getObject("letter"):stopEffect()	
	end
--[[
	eventWon = function(self)
		FixEvent.eventWon(self)
		local letter = self.items[1].obj
		letter.clickable = true
		letter.onWorkStart = function(self, task)
			task.duration = -1
			levelDesc.fixEventDialog = level:showLetter(task.actor)
			task.actor.old_playIdleAnimations = task.actor.playIdleAnimations
			task.actor.playIdleAnimations = false

			--' TODO: Play 'read' animation?
			levelDesc.fixEventUpdateText(100)
			return true
		end
		letter.onWorkUpdate = function(self, task)
			return taskSystem:hasTaskFor(task.actor) or level.hasShiftFinished
		end
		letter.onWorkFinish = function(self, task)
			task.actor:removeMessageDialog("fixEventMessage")
			task.actor.playIdleAnimations = task.actor.old_playIdleAnimations
		end
	end,
]]
}
