dofile("script/rooms/defaults/room1_defaults.lua")
dofile("script/animations/room1_2_animations.lua")

levelDesc.name = "room1_2"
levelDesc.musicMood = "-"
levelDesc.autoStartShift = false
levelDesc.values.maxTraySize = 3

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger="spawn",	delay=1000,		place="counter", 		    }, 
		{ trigger="spawn",	delay=14000,	place="counter", 			}, 
		{ trigger="spawn",	delay=15000,	place="table", 	 size=1,	customers={{base="gladys", gender=""}}, order={class="Order", steps={{"#tea", "#macaroon"}, } }	}, 
		{ trigger="spawn",	delay=6000, 	place="counter", 		    },  --16000 Tjien
		{ trigger="spawn",	delay=5000, 	place="counter", 			}, 	--15000
		{ trigger="spawn",	delay=14000,	place="counter", 			}, 
		{ trigger="spawn",	delay=15000,	place="table",	 size=2,	},
		{ trigger="spawn",	delay=8000,	place="counter", 			}, 		--16000
		{ trigger="spawn",	delay=15000,	place="table", 	 size=1,	}, 
		{ trigger="spawn",	delay=15000,	place="counter", 			}, 
		{ trigger="spawn",	delay=16000,	place="table",	 size=2,	},
		{ trigger="spawn",	delay=14000,	place="counter", 			}, 
		{ trigger="spawn",	delay=5000,	place="counter", 			}, 		--15000
		{ trigger="spawn",	delay=14000,	place="counter", 			}, 
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", },
	p2 = { weight=50, base="child", },
	p3 = { weight=50, base="elderly", },
	p4 = { weight=50, base="normal", },
	p5 = { weight=50, base="locals", },
	p6 = { weight=50, base="yup", },
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)

	local table4_4 = level:getObject("table4-4")
	if (table4_4) then
		table4_4.usedInGameplay = false
		table4_4.clickable = false
	end

	local kitchen_plate4 = level:getObject("kitchen_plate4")
	--assert(kitchen_plate4, "\nCould not find object 'kitchen_plate4' in the level!")
	if (kitchen_plate4) then
		kitchen_plate4.visible = true
	end

	local kitchen_plate5 = level:getObject("kitchen_plate5")
	--assert(kitchen_plate5, "\nCould not find object 'kitchen_plate5' in the level!")
	if (kitchen_plate5) then
		kitchen_plate5.visible = true
	end
end

levelDesc.eventDesc =
{
	class="FixEvent",
	bar="progressbar_click_fix",
	hideItemOnDone = true,
	customCursor = {image="CLEANING:icons", x=25, y=25, frameTime=120, mousePointer="none"},
	scoreAllDone = 100,
	scoreOneDone = 25,
	addExclamationMarks = true,
}

function levelDesc:onEventStepDone(event, item)
	if (item and item.obj and item.obj.name == "fixmix1") then
		local table4_4 = level:getObject("table4-4")
		table4_4.usedInGameplay = true
		table4_4.clickable = true
	end		
end
