dofile("script/rooms/defaults/room1_defaults.lua")
dofile("script/animations/room1_1_pre_animations.lua")

levelDesc.name = "room1_1_pre"
levelDesc.musicMood = "-"
levelDesc.isGamePlayLevel = false


--' ************************************ GameHouse Object Dialog ************************************ '--
dialogs.show_tutorial = {
	class = "DialogYesNo",
	autoCenter = true,
	doDarkenBackground = true,
	text="SHOW_TUTORIAL_TEXT",
	header="SHOW_TUTORIAL_HEADER",
	minWidth = 500, minHeight = 300,
	painter = blueprints.default_painter,
	components = {
		{ class="Label", name="HEADER", x=246, y=100, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Label", name="MESSAGE", x=250, y=143, maxWidth=340, anchor="top", align="center", wrapStyle="word", font="FONT_TEXT:default"},
		{ class="Button", name="BUTTON_YES", x=240, y=170, image="BUTTON_YES:default", anchor="topRight", setup=setups.btn},
		{ class="Button", name="BUTTON_NO", x=260, y=170, image="BUTTON_NO:default", anchor="topLeft", setup=setups.btn},
	},
}

-- sets the appearance back to the default (no-morning, which removes the added appearance)
-- trigger: triggertask -> no_morning / morning / whatever trigger needed
levelDesc.old_handleTrigger = levelDesc.handleTrigger
function levelDesc:handleTrigger(trigger, data)
	if (trigger == "show_tutorial") then
		self:fireTrigger("nextLevel")
		
	elseif (trigger == "no_morning") then
		self:removeApprearanceObjectCopies()		

	elseif (trigger == "do_tutorial") then
		local dlg = scene:createDialog("show_tutorial")
		scene:openDialog(dlg)

		local items = {
			dlg:getChild("BUTTON_YES"),
			dlg:getChild("BUTTON_NO"),
		}
		items[1].onClick = function()
			self:fireTrigger("nextLevel")
			dlg:close()
			return true
		end
		items[2].onClick = function()
			player:incLevel()
			self:fireTrigger("nextLevel")
			dlg:close()
			return true
		end
	end
	
	if (levelDesc.old_handleTrigger) then
		return levelDesc.old_handleTrigger(self, trigger, data)
	else
		return self.class.handleTrigger(self, trigger, data)
	end
end

function levelDesc:removeApprearanceObjectCopies()
	self.gameLayer:traverse(
		function(_, node)
			if (node.isAppearanceObjectCopy) then
				node:animate({alpha=0, duration=6000}, {obsolete=true})
			end
		end
	)
end

function levelDesc:onMessageClick(command, id, obj)
	if (id == "DO_TUTORIAL") then
		if (command == "yes") then
			self:fireTrigger("nextLevel")
		elseif (command == "no") then
			--' first increase the level so it can increase it again (skips 2 levels)
			player:incLevel()
			self:fireTrigger("nextLevel")
		end
		if (level.BM_onTutorial) then level:BM_onTutorial(command) end
	end
end