dofile("script/rooms/defaults/appartment_defaults.lua")
dofile("script/animations/appartment_57_animations.lua")

levelDesc.name = "appartment_57.lua" 
levelDesc.musicMood = "-"
levelDesc.isGamePlayLevel = true
levelDesc.maximumScore = 300
levelDesc.overheadFloor = 300
levelDesc.showTray = false
levelDesc.values.maxTraySize = 5
levelDesc.storyTargetScores =
{
	{}, --' Room 1
	{}, --' Room 2
	{}, --' Room 3
	{}, --' Room 4
	{ --' Room 5
		{}, {}, {},	{},	{}, {}, --' Shift 6
		{target=0, expert=0}, --' Shift 7
		{}, {}, {},
	},
}

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="dummy", delay=45000, },
	}
}

levelDesc.customerList =
{
}

function levelDesc:onLevelInitialized()
	self.class.onLevelInitialized(self)
	self:setDaytimeAppearance("morning")
end

levelDesc.eventDesc =
{
	class="Event",
	--hintArrowDesc = {hintId="vacuum_cleanup_item4", parent="vacuum_cleanup_item4", x=0, y=0},
	--hideItemOnDone = true,
	scoreAllDone = 100,
	scoreOneDone = 25,
	floaterPos = {x=512, y=300},
	
	getNumItemsTodo = function()
		return #event.cleanObjects
	end,

	cleanObjects =
	{
		{"bed_back", "mess_floor"},
		{"bed_desk", {"tv_table", "shadowResource", "tv_table_clean_shadow"}},
		{"fridge", "kitchen_railing"},
		{"kitchen_bottom"},
		{"kitchen_cupboard"},
		{"kitchen_table", "stairs_front"},
		{"stove"},
		{"salon_table", "couch"},
	},

	onStart = function(self)
		HiddenObjectEvent.onStart(self)

		for _,objGroup in ipairs(event.cleanObjects) do
			local mainItem = objGroup[1]
			local curObj = level:getObject(mainItem)
			assert(curObj, "Could not find '"..ts(mainItem).."'")
			curObj:createOverhead("ICON_EXCLAMATION")
			if (curObj) then
				curObj.clickable = true
				curObj.onClick = function()
					curObj:removeOverhead()
					curObj.clickable = false
					return Object.onClick(curObj)
				end
				curObj.onWorkStart = function(self, task)
					task.duration = curObj.workDuration
					task.actor.direction = curObj.workDirection or "up"
					task.actor:playAnimation(curObj.workAnimation or "work", -1, curObj.workFrameTime or 100)
					task.currentItem = 1
					task.timePerSeg = task.duration / #objGroup
					self:playSample("sound_cleaning_event:sound")
					return true
				end
				curObj.onWorkUpdate = function(self, task)
					if (task.timer.time >= (task.timePerSeg*task.currentItem)-task.timePerSeg*0.2) then
						--'Set items visible/img based on time passed
						local itemName = objGroup[task.currentItem]
						local t = nil
						if (isTable(itemName)) then
							t = itemName
							itemName = t[1]

						end
						local obj = level:getSpriteExt(itemName)
						assert(obj, "could not find '"..ts(objGroup[task.currentItem] or task.currentItem).."'")
						if (obj) then
							if (t) then
								obj[ t[2] ] = t[3]
							else
								local cleanImg = obj.name.."_clean"
								if (level:hasResource(cleanImg)) then
									obj.image = cleanImg
								else
									obj.visible = false
								end
							end
						end
						task.currentItem = task.currentItem + 1
					end
					return false
				end
				curObj.onWorkFinish = function(self, task)
					--'Make sure everything was processed
					curObj:onWorkUpdate(task)
					event:incItemDone()
					event:scoreItemDone()
					event:onProgress()
					task.actor.direction = "down"
					task.actor:playDefaultAnimation()
					if (event.itemsDone >= event.getNumItemsTodo()) then
						level:saveEndLevelInfo(false)
						event:eventWon()
					end
					return false
				end
			end
		end
	end,
}

function levelDesc:onLevelInitialized()
	self.class.onLevelInitialized(self)
	self:setDaytimeAppearance("morning")
--[[
	self.maxTimeForCleaning = 30000

	local cleanObjects =
	{
		{"bed_back", "mess_floor"},
		{"bed_desk", {"tv_table", "shadowResource", "tv_table_clean_shadow"}},
		{"fridge", "kitchen_railing"},
		{"kitchen_bottom"},
		{"kitchen_cupboard"},
		{"kitchen_table", "stairs_front"},
		{"stove"},
		{"salon_table", "couch"},
	}

	local nrCleaned = 0

	for _,objGroup in ipairs(cleanObjects) do
		local mainItem = objGroup[1]
		local curObj = level:getObject(mainItem)
		assert(curObj, "Could not find '"..ts(mainItem).."'")
		if (curObj) then
			curObj.clickable = true
			curObj.onClick = function()
				curObj.clickable = false
				return Object.onClick(curObj)
			end
			curObj.onWorkStart = function(self, task)
				task.duration = curObj.workDuration
				task.actor.direction = curObj.workDirection or "up"
				task.actor:playAnimation(curObj.workAnimation or "work", -1, curObj.workFrameTime or 100)
				task.currentItem = 1
				task.timePerSeg = task.duration / #objGroup
				return true
			end
			curObj.onWorkUpdate = function(self, task)
				if (task.timer.time >= (task.timePerSeg*task.currentItem)-task.timePerSeg*0.2) then
					--'Set items visible/img based on time passed
					local itemName = objGroup[task.currentItem]
					local t = nil
					if (isTable(itemName)) then
						t = itemName
						itemName = t[1]
						
					end
					local obj = level:getSpriteExt(itemName)
					assert(obj, "could not find '"..ts(objGroup[task.currentItem] or task.currentItem).."'")
					if (obj) then
						if (t) then
							obj[t[2] ] = t[3]
						else
							local cleanImg = obj.name.."_clean"
							if (level:hasResource(cleanImg)) then
								obj.image = cleanImg
							else
								obj.visible = false
							end
						end
					end
					task.currentItem = task.currentItem + 1
				end
				return false
			end
			curObj.onWorkFinish = function(self, task)
				--'Make sure everything was processed
				curObj:onWorkUpdate(task)
				nrCleaned = nrCleaned + 1
				task.actor.direction = "down"
				task.actor:playDefaultAnimation()
				if (nrCleaned >= #cleanObjects) then
					taskSystem:createAnimation("eventWon")
				end
				return false
			end
		end
	end
]]--
end
--[[
function levelDesc:handleTrigger(trigger, data)
	if (trigger == "startEvent") then
		self.eventInProgress = true
	else
		self.class.handleTrigger(self, trigger, data)
	end
end
]]
function levelDesc:onTick(time)
	self:tick(time)

--[[
	if (self.eventInProgress) then
		if (not self.levelTime) then self.levelTime = 0 end
		self.levelTime = self.levelTime + time
		if (self.levelTime >= self.maxTimeForCleaning) then
			self.eventInProgress = false
			taskSystem:createAnimation("eventLost")
		end
	end
]]--
end
