dofile("script/rooms/defaults/appartment_defaults.lua")
dofile("script/animations/appartment_3_animations.lua")

levelDesc.name = "appartment_3.lua" 
levelDesc.musicMood = "-"
levelDesc.playEndLevelSound = false
levelDesc.values.maxTraySize = 3

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		
	}
}

levelDesc.customerList =
{
	--p1 = { weight=50, base="big" },
	--p2 = { weight=50, base="child" },
	--p3 = { weight=50, base="designer" },
	--p4 = { weight=50, base="elderly" },
	--p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	--p7 = { weight=50, base="yup" },
}

function levelDesc:onLevelInitialized()
	self.class.onLevelInitialized(self)
	self:setDaytimeAppearance("night")

	local tv_glow = level:getObject("tv_glow")
	tv_glow:doEvery(0, function()
		tv_glow.alpha = math.Random(0.1, 1.0)
		return math.Random(10, 300)
	end)
end

-- sets the appearance back to the default (no-morning, which removes the added appearance)
-- trigger: triggertask -> no_night / night / morning / whatever trigger needed
function levelDesc:handleTrigger(trigger, data)

	if (trigger == "no_night") then
		self:setDaytimeAppearance()
	end
	
	return self.class.handleTrigger(self, trigger, data)
end
