dofile("script/rooms/defaults/appartment_defaults.lua")
dofile("script/animations/appartment_14_animations.lua")

levelDesc.name = "appartment_14.lua" 
levelDesc.musicMood = "-"

function levelDesc:onLevelInitialized()
	self.class.onLevelInitialized(self)
	self.blackSprite = self:addChild({class="Sprite", name="blackSprite", x=0, y=0, width=1024, height=768, color=0x000000, alpha=1, draw="color"})
	self:setDaytimeAppearance("morning")
end

-- sets the appearance back to the default (no-morning, which removes the added appearance)
-- trigger: triggertask -> no_morning / morning / whatever trigger needed
function levelDesc:handleTrigger(trigger, data)

	if (trigger == "fadeBlackIn") then
		self.blackSprite.alpha=0
		self.blackSprite:animate({duration=500, alpha=1})
	elseif (trigger == "fadeBlackOut") then
		self.blackSprite.alpha=1
		self.blackSprite:animate({duration=500, alpha=0})
	elseif (trigger == "setPosition") then
		assert(isString(data.params), "set the (left, center, right parameter)")
		if (data.params == "left") then
			self.x = 0
		elseif (data.params == "center") then
			self.x = -1024 / 4
		elseif (data.params == "right") then
			self.x = -1024 / 2	
		end
	end

	return self.class.handleTrigger(self, trigger, data)
end
