dofile("script/rooms/defaults/appartment_defaults.lua")
dofile("script/animations/appartment_13_animations.lua")

levelDesc.name = "appartment_13.lua" 
levelDesc.musicMood = "-"

function levelDesc:onLevelInitialized()
	self.class.onLevelInitialized(self)
	self:setDaytimeAppearance("night")

	local tv_glow = level:getObject("tv_glow")
	tv_glow:doEvery(0, function()
		local duration = math.Random(10, 100)
		tv_glow:animate({alpha=math.Random(0.1, 1.0), duration=duration})
		return math.Random(duration, 400)
	end)
end


-- sets the appearance back to the default (no-morning, which removes the added appearance)
-- trigger: triggertask -> no_morning / morning / whatever trigger needed
function levelDesc:handleTrigger(trigger, data)

	if (trigger == "no_night") then
		self:setDaytimeAppearance()
	end
	
	return self.class.handleTrigger(self, trigger, data)
end
