--' ************************************ Fix Event ************************************ '--
SpecialTreatEvent = deriveLuaClass("SpecialTreatEvent", "Event")

--' Sample usage '--
--[[
levelDesc.eventDesc =
{
	class="SpecialTreatEvent",
	specialProduct="#applepie",
	scoreOneDone=25,
	scoreAllDone=100,
	randomValue = 2, -- one in 2 times
}
--]]

function SpecialTreatEvent:init(desc)
	SpecialTreatEvent.superInit(self, desc)

	self.specialProduct = self.specialProduct or assert(self.specialProduct, "need specialProduct")
	self.randomValue = self.randomValue or 2
	
	self.numProductsToDeliver = 2
	self.name = "SpecialTreatEvent"
	
	local button = level:getIngredientButton(self.specialProduct)
	if (button) then
		self.numProductsToDeliver = button.stock
	end
	print("self.numProductsToDeliver: "..self.numProductsToDeliver)
end

function SpecialTreatEvent:onInitialized()
	SpecialTreatEvent.super.onInitialized(self)
end

function SpecialTreatEvent:getNumItemsTodo()
	return self.numProductsToDeliver
end

function SpecialTreatEvent:onStart()
	SpecialTreatEvent.super.onStart(self)
	
end

function SpecialTreatEvent:onRemoveProductFromTray(product)
	if (self.specialProduct == product.name) then
		print("SpecialTreatEvent:onRemoveProductFromTray(product)")
		local toRemove = {product}
		tray:removeProductsToTarget(toRemove, product.source)
		product.source:incStock(product.source.worth, true)
		return true
	end
	return false
end

function SpecialTreatEvent:handleTrigger(trigger, data)
	SpecialTreatEvent.super.handleTrigger(self, trigger, data)

	if (not event.started or event.completed) then
		return
	end
	
	if (trigger == "tableOrderCreated" and math.Random(self.randomValue)==1) then
		local numTimesProductOrdered = level:getNumTimedProductOrdered(self.specialProduct)
		if (numTimesProductOrdered+1 <= (eventBar.targetValue - eventBar.value)) then
			data.steps = {{self.specialProduct}, data.steps[1]}
		end
	elseif (trigger == "orderDelivered" and data == self.specialProduct) then
		eventBar:incValue(1)
		
		if (event.scoreOneDone and event.scoreOneDone > 0) then
			local pos = hero.floaterPosition
			local text = string.format(ghf.getText("EVENT_SCORE_ONE_DONE"), event.scoreOneDone)
			level:handleScore(event.scoreOneDone, pos.x, pos.y, false, 0);
			effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreOneDone, 0)
			if (level.BM_eventScore) then level:BM_eventScore(event.scoreOneDone) end
		end
		
		if (eventBar.value >= eventBar.targetValue) then
			if (event.scoreAllDone and event.scoreAllDone > 0) then
				local pos = hero.floaterPosition
				local text = string.format(ghf.getText("EVENT_SCORE_ALL_DONE"), event.scoreAllDone)
				level:handleScore(event.scoreAllDone, pos.x, pos.y, false, 0);
				effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreAllDone, 0)
				if (level.BM_eventScore) then level:BM_eventScore(event.scoreAllDone) end
				event.scoreAllDone = nil
				event:eventWon()
			end
		end		
	end
	
end

