--' ************************************ Hidden Object Event ************************************ '--
HiddenObjectEvent = deriveLuaClass("HiddenObjectEvent", "Event")
HiddenObject = deriveLuaClass("HiddenObject", "Object")

function HiddenObjectEvent:init(desc)
	HiddenObjectEvent.superInit(self, desc)

	--' Configuration variables

	--' Status variables

	--' Override
	self.matchingItemType = "HiddenObject"
end

function HiddenObjectEvent:onInitialized()
	HiddenObjectEvent.super.onInitialized(self)

	for _,item in ipairs(self.items) do
		item.drawOutline = false
		item.obj.onClick = hiddenObjectOnClick
		item.obj.highlightSound = "" --' Mute the highlight
		item.obj.drawOutline = false
	end
end

function HiddenObjectEvent:onItemDone(item)
	return HiddenObjectEvent.super.onItemDone(self, item)
end

function hiddenObjectOnClick(self)
	if (self.visible) then
		event:itemDone(self.item)
		return true
	end
end
