--' ************************************ Fix Event ************************************ '--
FollowAnnoyEvent = deriveLuaClass("FollowAnnoyEvent", "Event")

--' Sample usage '--
--[[
levelDesc.eventDesc =
{
	class="FollowAnnoyEvent",
	scoreAllDone = 100,
	scoreOneDone = 25,
	numAnnoysNeeded = 4,
	annoyCharacterName = "dog",
	talkDuration = 2000,
	talkDirection = "down",
	talkAnimation = "talk",
	moodMultiplier = 0.5,
	annoyAnimation = "annoy"
	annoySound = "annoy_sound:sound"
}
]]

function FollowAnnoyEvent:init(desc)
	FollowAnnoyEvent.superInit(self, desc)

	--' Configuration variables
	self.scoreOneDone = self.scoreOneDone or 100
	self.scoreAllDone = self.scoreAllDone or 300
	--self.numAnnoys = self.numAnnoys or 6
	self.numAnnoysNeeded = self.numAnnoysNeeded or 4
	self.moodMultiplier = self.moodMultiplier or 0.5
	self.annoyAnimation = self.annoyAnimation or ""
	self.annoySound = self.annoySound
	
	self.talkDuration = self.talkDuration or 500
	self.talkDirection = self.talkDirection or "down"
	self.talkAnimation = self.talkAnimation or ""	
	self.annoyCharacterName = self.annoyCharacterName or assert(self.annoyCharacterName, "need annoyCharacterName")
	
	--' Status variables
	self.numAnnoysDone = 0
	self.AnnoyActive = false

	--' Override
end

function FollowAnnoyEvent:getNumItemsTodo()
	return self.numAnnoysNeeded
end

function FollowAnnoyEvent:onInitialized()
	FollowAnnoyEvent.super.onInitialized(self)

	if (self.trackProgress) then
		eventBar.soundOnProgress = false
	end
end

function FollowAnnoyEvent:onStart()
	FollowAnnoyEvent.super.onStart(self)

	self.annoyCharacter = level:getCharacter(self.annoyCharacterName)
	self.annoyCharacter.stationaryActive = true
end

function FollowAnnoyEvent:onTick(time)
	if (not self.started or self.completed) then
		return
	end
end

function FollowAnnoyEvent:checkEventStatus()
	self.numAnnoysDone = self.numAnnoysDone + 1
	if (eventBar.value >= eventBar.targetValue) then		
		event:eventWon()
--'	elseif (self.numAnnoysDone >= self.numAnnoys) then
--'		event:eventLost()	
	end
end

--' ************************************ PushAwayCharacter ************************************ '--
AnnoyCharacter = deriveLuaClass("AnnoyCharacter", "FollowCharacter")

function AnnoyCharacter:init(desc)
	AnnoyCharacter.superInit(self, desc)
	
	self.clickable = false
	self.stationaryActive = false
	self.closestTable = nil
	self.tablePositions = desc.tablePositions or {}
	for _,v in ipairs(self.tablePositions) do
		table.push_back(self.waitPositions, v)
	end
end

function AnnoyCharacter:onClick()
	--AnnoyCharacter.super.onClick(self)
	
	--' self could be a table or a AnnoyCharacter
	self = self.annoyCharacter or self
	
	local group = self.closestTable.group
	if (group) then
		local main = group.main
		assert(main)
		--main.valueMultipliers.moodDropTime = main.old_moodDropTime
		group.mood =  main.old_mood
		group:resetMoodDropTimer()
	end
	
	--' add score
	eventBar:incValue(1)
	if (event.scoreOneDone and event.scoreOneDone > 0) then
		local pos = event.annoyCharacter.floaterPosition
		local text = string.format(ghf.getText("EVENT_SCORE_ONE_DONE"), event.scoreOneDone)
		level:handleScore(event.scoreOneDone, pos.x, pos.y, false, 0);
		effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreOneDone, 0)
		if (level.BM_eventScore) then level:BM_eventScore(event.scoreOneDone) end
	end
	
	if (eventBar.value >= eventBar.targetValue) then
		if (event.scoreAllDone and event.scoreAllDone > 0) then
			local pos = event.annoyCharacter.floaterPosition
			local text = string.format(ghf.getText("EVENT_SCORE_ALL_DONE"), event.scoreAllDone)
			level:handleScore(event.scoreAllDone, pos.x, pos.y, false, 0);
			effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreAllDone, 0)
			if (level.BM_eventScore) then level:BM_eventScore(event.scoreAllDone) end
			event.scoreAllDone = nil
		end
	end

	self:endAnnoy()
	event:checkEventStatus()
	return true
end

function AnnoyCharacter:endAnnoy()
	self:playAnimation("")
	self.clickable = false
	self.closestTable.onClick = self.closestTable.old_onClick
	self.closestTable = nil
	self.stationaryActive = true
	self.dropMoodDuration = 0
	if (event.endCharacterAnnoy) then
		event.endCharacterAnnoy(event, self)
	end
end

function AnnoyCharacter:onTick(time)
	self:tick(time)
	if (not event.started or event.completed or not self.closestTable) then
		return
	end
	
	if (self.dropMoodDuration > 0) then
		self.dropMoodDuration = self.dropMoodDuration - time
		if (self.dropMoodDuration <= 0) then
			self.closestTable.group.mood = 0
			self.closestTable.group:resetMoodDropTimer()		
		end
	end

	if (not self.closestTable.group or self.closestTable.group.state == "Leaving") then
		print("reset the annoy character")
		self:endAnnoy()
		event:checkEventStatus()
	end
end

--[[
function AnnoyCharacter:onWorkStart(task)
	print("AnnoyCharacter:onWorkStart(task)")
	AnnoyCharacter.super.onWorkStart(self, task)
	
	task.duration = event.talkDuration
	task.actor.direction = event.talkDirection
	task.actor:playAnimation(event.talkAnimation, -1)
	return true
end

function AnnoyCharacter:onWorkFinish(task)
	AnnoyCharacter.super.onWorkFinish(self, task)
	print("AnnoyCharacter:onWorkFinish(task)")

	--' add score
	eventBar:incValue(1)
	if (event.scoreOneDone and event.scoreOneDone > 0) then
		local pos = event.annoyCharacter.floaterPosition
		local text = string.format(ghf.getText("EVENT_SCORE_ONE_DONE"), event.scoreOneDone)
		level:handleScore(event.scoreOneDone, pos.x, pos.y, false, 0);
		effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreOneDone, 0)
		if (level.BM_eventScore) then level:BM_eventScore(event.scoreOneDone) end
	end
	
	if (eventBar.value >= eventBar.targetValue) then
		if (event.scoreAllDone and event.scoreAllDone > 0) then
			local pos = event.annoyCharacter.floaterPosition
			local text = string.format(ghf.getText("EVENT_SCORE_ALL_DONE"), event.scoreAllDone)
			level:handleScore(event.scoreAllDone, pos.x, pos.y, false, 0);
			effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreAllDone, 0)
			if (level.BM_eventScore) then level:BM_eventScore(event.scoreAllDone) end
			event.scoreAllDone = nil
		end
	end
end
]]

function AnnoyCharacter:isTablePos(pos)
	for _,v in ipairs(self.tablePositions) do
		if (v.x == pos.x and v.y == pos.y) then
			return true
		end 
	end 
	return false
end

function AnnoyCharacter:getClosestTable(pos)
	local tables = level:getSpritesByExactType("Table")
	local dist = 999999999
	local closestTable = nil
	for _,v in ipairs(tables) do
		local tDist = math.powDistance(pos, v.center)
		if (tDist < dist) then
			dist = tDist
			closestTable = v
		end
	end
	return closestTable
end

function AnnoyCharacter:arriveAtWaitPos(pos)
	--print("AnnoyCharacter:arriveAtWaitPos(): x="..pos.x.." y="..pos.y)
	
	if (not event.started or event.completed or self.closestTable) then
		return
	end
	
	if (self:isTablePos(pos)) then
		--' randomly start barking
		local t = self:getClosestTable(pos)
		if (t and t.group) then
			--' multiply the moodDropTime of the customers at this table and start barking
			if (event.beginCharacterAnnoy) then
				event.beginCharacterAnnoy(event, self)
			end
			self.clickable = true				
			self.stationaryActive = false
			
			if (event.annoySound) then
				self:playSample(event.annoySound)
			end
			
			t.old_onClick = t.onClick
			t.onClick = self.onClick
			t.annoyCharacter = self
			
			self.workPos = t.workPos
			
			local main = t.group.main
			assert(main)
			
			--main.old_moodDropTime = main.valueMultipliers.moodDropTime
			--main.valueMultipliers.moodDropTime = main.valueMultipliers.moodDropTime or 1
			--main.valueMultipliers.moodDropTime = main.valueMultipliers.moodDropTime * event.moodMultiplier
			main.old_mood = t.group.mood
			self.dropMoodDuration = 2000
			
			self.closestTable = t		
			self:playAnimation(event.annoyAnimation, -1)
		end
	end
end