--' ************************************ Dance Event ************************************ '--
DanceEvent = deriveLuaClass("DanceEvent", "Event")

function DanceEvent:init(desc)
	DanceEvent.superInit(self, desc)
	--' Configuration variables
	self.numDancesTodo = desc.numDancesTodo or 3
	self.scores = desc.scores or {0, 0, 0}						--' A score for each dance move
	self.danceMoves = desc.danceMoves or { {1}, {2}, {3}, {4} }
	self.dancerLostPositions = desc.dancerLostPositions or
	{
		{x=180, y=150},
		{x=150, y=150},
		{x=120, y=150},
	}
	self.mainCharacter = desc.mainCharacter or ""
	self.playCharacter = desc.playCharacter or ""

	self.dancingBystanders = desc.dancingBystanders or {}
	assert(isTable(self.dancingBystanders))

	self.nrDanceSteps = desc.nrDanceSteps or 4
	self.startMoves = desc.startMoves or 3

	--' Status variables
	self.timer = 0
	self.indexDance = 0
	self.indexMove = 0
	self.clicked = {}
	self.right = 0
	self.buttons = {}

	self.buttonPos = desc.buttonPos or
	{
		{x=-111, y=-203},
		{x=-47, y=-256},
		{x=12, y=-201},
	}
	self.choices = desc.moves or {}
	self.danceSounds = desc.danceSounds or {}
--'	self.choicesButtonSound =
--'	{
--'		["STEP"] = "SOUND_DANCE_BUTTON_1",
--'		["TWIRL"] = "SOUND_DANCE_BUTTON_2",
--'		["DIP"] = "SOUND_DANCE_BUTTON_3",
--'	}
--'	self.choicesDanceSound =
--'	{
--'		["STEP"] = "SOUND_DANCE_STEP_1",
--'		["TWIRL"] = "SOUND_DANCE_STEP_2",
--'		["DIP"] = "SOUND_DANCE_STEP_3",
--'	}
	local maxMoves = self.nrDanceSteps + self.startMoves - 1
	local picked = {}
--[[
	local choicesCount = {0, 0, 0}
	for i = 1, maxMoves do
		local random
		repeat
			random = math.Random(#choicesCount)
		until (choicesCount[random] < 3) --' Max times a move occurs

		table.insert(picked, self.choices[random])
		choicesCount[random] = choicesCount[random] + 1
	end
]]--
	local modulo = #(self.choices)
	for i = 1, maxMoves do
		table.insert(picked, self.choices[(i%modulo)+1])
	end

	self.danceSteps = {}
	for i = 1, self.nrDanceSteps do--'4
		local tmp = {}
		local nrMoves = i-1 + self.startMoves--'3-6
		local picks = {}
		for j = 1, (maxMoves) do table.insert(picks, i) end--'6

		for j = 1, nrMoves do--'3-6
			local pick = math.Random(#picks)
			table.insert(tmp, picked[pick])
			table.remove(picks, pick) --' Exclude already picked items
		end
		table.insert(self.danceSteps, tmp)
	end
--'print("Dance moves: "..table.tostring(self.danceSteps))
end

function DanceEvent:onInitialized()
	DanceEvent.super.onInitialized(self)

	eventBar.targetValue = self:getNumItemsTodo()
	eventBar.showValue = true
	eventBar.showTarget = true
end

function DanceEvent:getNumItemsTodo()
	return self.numDancesTodo
end

function DanceEvent:onStart(anim)
	self.danceAnimationRoot = anim
	self.danceAnimationRoot:add({class="StartStoryTask", showBars=false})
	self.keepAnimationAlive = true
	self.danceAnimationRoot:add({
		class="LuaTask",
		update=function()
			return not self.keepAnimationAlive
		end,
		skippable=false,
	})
	self.prevDanceAnimation = self.danceAnimationRoot:addGroup("Dancing, Yeah!")

	self.indexDance = self.indexDance + 1
	self.indexMove = 0

	self.mainCharacter = _G[self.mainCharacter] or level:getChild(self.mainCharacter)
	assert(isTable(self.mainCharacter))
	self.mainCharacter.playIdleAnimations = false

	self.playCharacter = _G[self.playCharacter] or level:getChild(self.playCharacter)
	assert(isTable(self.playCharacter))
	self.playCharacter.playIdleAnimations = false

	local bystanders = {}
	for _,name in ipairs(self.dancingBystanders) do
		local dancer = _G[name] or level:getChild(name)
		assert(isTable(dancer))
		local invalidDancer = (name == self.mainCharacter.name) or (name == self.playCharacter.name)
		assert(name ~= self.mainCharacter.name, "Main character in dance event cannot also be a bystander!")
		assert(name ~= self.playCharacter.name, "Play character in dance event cannot also be a bystander!")
		if (not invalidDancer and isTable(dancer)) then
			dancer.playIdleAnimations = false
			table.insert(bystanders, dancer)
		end
	end
	self.dancingBystanders = table.copy(bystanders)

	DanceEvent.super.onStart(self)

	for i=1,#self.choices do
		local btnName = self.choices[i]
		local button = self.mainCharacter:newChild({
			class="Button",
			name=btnName,
			targetX = self.buttonPos[i].x,
			targetY = self.buttonPos[i].y,
			alpha = 0,
			x = -22,
			y = -160,
			image = "buttons#"..btnName,
		})
		button.onClick = function()
			self:onClickButton(button)
		end
		button:animate({alpha=1, x = button.targetX, y = button.targetY, duration = 200})
		table.push_back(self.buttons, button)
	end
	self:enableButtons(false)

	self:createDanceSetAnimation(1)
end

function DanceEvent:addNewGroup(name, prevGroup, animRoot)
	prevGroup = prevGroup or self.prevDanceAnimation
	animRoot = animRoot or self.danceAnimationRoot
	if (prevGroup and prevGroup.add) then
		return prevGroup:atEndGroup(name)
	end
	return animRoot:addGroup(name)
end

function DanceEvent:doneLastDance()
	self:enableButtons(false)
	for i= 1, #self.buttons do
		self.buttons[i].obsolete = true
		self.buttons[i] = nil
	end

	local numMovesWon = 0
	for _,v in ipairs(self.danceMoves) do
		if (not v.missed) then
			numMovesWon = numMovesWon + 1
		end
	end

	local animGroup = self:addNewGroup("doneLastDance")
	local mod = animGroup:add({class="Task", duration=1000})

	mod
		:add({class="EmotionTask", actor = self.mainCharacter, emotion="",})
		:add({class="EmotionTask", actor = self.playCharacter, emotion="",})

	for _,dancer in ipairs(self.dancingBystanders) do
		mod
			:add({class="PlayDefaultAnimationTask", actor = dancer})
			:add({class="EmotionTask", actor = dancer})
	end

	mod = mod:add({class="CallTask",
		func = function()
			if (numMovesWon >= self:getNumItemsTodo()) then
				DanceEvent.super.eventWon(self)
			else
				DanceEvent.super.eventLost(self)
			end
		end})

	mod:add({class="EndStoryTask"})

	self.prevDanceAnimation = animGroup
	self.keepAnimationAlive = false
end

function DanceEvent:gotoNextDance()
	if (self.indexDance == table.getn(self.danceMoves) or
	 self.itemsDone >= self:getNumItemsTodo()) then
		self:doneLastDance()
		return
	end

	self.indexDance = self.indexDance + 1
	self.indexMove = 0
	self:createDanceSetAnimation(self.indexMove + 1)
end

function DanceEvent:createDanceSetAnimation(moveIndex)
	local animGroup = self:addNewGroup("createDanceSetAnimation")
	animGroup = animGroup:add({class="CallTask", func=function() self:enableButtons(false) end})

	self.indexMove = moveIndex
	self.clicked = {}

	assert(self.danceMoves[self.indexDance][self.indexMove])

	local mod = animGroup:add({class="Task", duration=1000, skippable=false})
	for index, value in ipairs(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]) do
		local button = self.mainCharacter:getChild(value)
		mod = mod
			:add({class="EmotionTask", actor = self.mainCharacter, emotion="",})
			:add({class="Task", duration=800, skippable=false})
			:add({class="CallTask", func=function() button.frame = 1 end, skippable=false})
			:add({class="CallTask", func=function() self.mainCharacter:playSample(event.danceSounds[button.name]) end, skippable=false})	
			:add({class="Task", duration=1000, skippable=false})
			:also({class="PlayAnimationTask", actor=self.mainCharacter, animation=button.name, cycles=1, wait=true, skippable=false})
			:add({class="CallTask", func=function() button.frame = 0 end, skippable=false})
	end

	mod = mod
		:add({class="Task", duration=300, skippable=false})
		:add({class="PlayDefaultAnimationTask", actor=self.mainCharacter, skippable=false})
		:add({class="CallTask", func=function() self:enableButtons(true) end, skippable=false})
	self.prevDanceAnimation = animGroup
end

function DanceEvent:onClickButton(button)
	local buttonName = button.name
	table.insert(self.clicked, buttonName)

	local timeBetweenMoves = 160
	local curDanceTable = self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]
	local timeAfterMove = 200
	local animGroup = self:addNewGroup("onClickButton")
	animGroup
		:add({class="CallTask", func=function() self.mainCharacter:playSample(event.danceSounds[button.name]) end, skippable=false})	
		:add({class="PlayAnimationTask", actor = self.playCharacter, animation=buttonName, cycles=1, wait=true})
		:add({class="Task", duration=timeAfterMove})
		:add({class="PlayDefaultAnimationTask", actor = self.playCharacter})

	for _,dancer in ipairs(self.dancingBystanders) do
		animGroup
			:add({class="Task", duration=math.Random(self.maxMoveDelay)})
			:add({class="PlayAnimationTask", actor = dancer, animation=buttonName, cycles=1, wait=true})
			:add({class="Task", duration=timeAfterMove})
			:add({class="PlayDefaultAnimationTask", actor = dancer})
	end

	--'assert(self.choicesDanceSound)
	--'assert(self.choicesDanceSound[button])
	--'self.playCharacter:playSample(event.danceSounds[buttonName])

	local index = #self.clicked
	local missed = false
	if (self.clicked[index] ~= curDanceTable[index]) then--' Clicked wrong
		missed = true
		self.danceMoves[self.indexDance].missed = true
		--'self.playCharacter:qPlaySound("SOUND_EVENT_BAD")
		--'self.playCharacter:qPlaySound(self.choicesDanceSound[buttonName])
		--'self.playCharacter:playSample("SND_MINIGAME_UNSUCCESSFUL:sound")

		animGroup = animGroup:atEndGroup("onClickButton - Wrong move")
		animGroup
			:add({class="PlayAnimationTask", actor = self.mainCharacter, animation="shakeno", cycles=1, wait=true, whenFinished="default"})
			:add({class="PlayDefaultAnimationTask", actor = self.mainCharacter})
			:add({class="EmotionTask", actor = self.mainCharacter, emotion="sad",})

		for _,dancer in ipairs(self.dancingBystanders) do
			animGroup
				:add({class="PlayDefaultAnimationTask", actor = dancer})
				:add({class="EmotionTask", actor = dancer, emotion="sad",})
		end
	end

	animGroup = animGroup:atEndGroup("onClickButton - end of dance")
	local mod = animGroup
		:add({class="Task", duration = timeBetweenMoves})
		:add({class="EmotionTask", actor = self.playCharacter})

	if (table.getn(self.clicked) == table.getn(curDanceTable) or missed) then--' All moves done, go to next dance set
		self:enableButtons(false)
		local timeBetweenDances = 350

		if (not missed and not self.danceMoves[self.indexDance].missed) then
			mod = mod
				:add({class="CallTask", func=function()
					self:itemDone({})
					eventBar:incValue(1)
					print("eventBar:incValue(1)")
				end})
				:add({class="PlayAnimationTask", actor = self.mainCharacter, animation="shakeyes", cycles=1, wait=true})
			
			for _,dancer in ipairs(self.dancingBystanders) do
				mod:add({class="EmotionTask", actor = dancer, emotion="happy"})
			end
		end
		mod = mod
			:add({class="Task", duration=timeBetweenDances})
			:add({class="CallTask", func=function()
				if(level.eventThanks) then
					level:eventThanks()
				end
				self:gotoNextDance()
			end})
	end
	self.prevDanceAnimation = animGroup
end

function DanceEvent:onItemDone(item)
	--' Explicit override so it does nothing!
end

function DanceEvent:onProgress()
	--' Explicit override so it does nothing!
end

function DanceEvent:enableButtons(enable)
	for _,button in ipairs(self.buttons) do
		button.enabled = enable
	end
end

function DanceEvent:showButtons(visible)
	for _,button in ipairs(self.buttons) do
		button.visible = visible
	end
end