--' ************************************ Click Fix Event ************************************ '--
ClickFixEvent = deriveLuaClass("ClickFixEvent", "Event")

--' Sample usage '--
--[[
levelDesc.eventDesc =
{
	class="ClickFixEvent",
	items = {
		{ obj="my_object", fixAmount=24 },
	},
}
--]]

function ClickFixEvent:init(desc)
	ClickFixEvent.superInit(self, desc)

	--' Configuration variables
	self.fixAmount = self.fixAmount or 20
	self.trackProgressPerItem = self.trackProgressPerItem ~= false --' Default true

	--' Status variables
	self.clicksDone = 0

	--' Override
	self.matchingItemType = "FixableObject"
end

function ClickFixEvent:onInitialized()
	ClickFixEvent.super.onInitialized(self)

	self.clicksTodo = 0
	for _,item in ipairs(self.items) do
		item.clicksDone = 0
		item.fixAmount = item.fixAmount or item.obj.fixAmount or self.fixAmount
		self.clicksTodo = self.clicksTodo + item.fixAmount
		self:createProgressBar(item)
	end

	if (self.trackProgress) then
		eventBar.targetValue = self.clicksTodo
	end
	eventBar.showValue = true
	eventBar.showTarget = true

	if (isString(self.tagetObject)) then
		self.tagetObject = level:getSpriteExt(self.tagetObject)
	end
end

function ClickFixEvent:showItem(item)
	ClickFixEvent.super.showItem(self, item)

	item.obj.onClick = clickFixOnClick
end

function ClickFixEvent:onProgress()
	ClickFixEvent.super.onProgress(self)

	if (not self.trackProgressPerItem and isTable(self.tagetObject)) then
		local fc = self.tagetObject.frameCount
		self.tagetObject.frame = math.min(fc-1, fc * self.clicksDone / self.clicksTodo)
	end
end

function ClickFixEvent:onItemDone(item)
	ClickFixEvent.super.onItemDone(self, item)

	if (self.trackProgressPerItem and isTable(self.tagetObject)) then
		local fc = self.tagetObject.frameCount
		self.tagetObject.frame = math.min(fc-1, fc * self.itemsDone / self:getNumItemsTodo())
	end
end

function ClickFixEvent:getProgress()
	if (self.trackProgress) then
		return self.clicksDone / self.clicksTodo
	end
	return ClickFixEvent.super.getProgress(self)
end

function ClickFixEvent:onMouseUp(x, y)
	if (level.inStoryMode or not self.started or self.completed) then
		return
	end
	
--'print("ClickFixEvent:onMouseUp")
	if (event.mouseDownObject) then
		event.mouseDownObject = nil
	end
end

function ClickFixEvent:onTick(time)
	if (self.mouseDownObject) then
		local p = ghf.getMouseCursorPos()
		local ox = self.mouseX - p.x
		local oy = self.mouseY - p.y
		
		local dist = (ox^2) + (oy^2)
		if (self.mouseDownObject:isInside(p.x, p.y)) then

			local increase = (time / 1000 * dist)
			increase = math.min(self.mouseDownObject.item.fixAmount/80, increase)
			self.clicksDone = self.clicksDone + increase
			self.mouseDownObject.item.clicksDone = self.mouseDownObject.item.clicksDone + increase

			local frac = 1
			if (self.mouseDownObject.item.clicksDone < self.mouseDownObject.item.fixAmount) then
				frac = self.mouseDownObject.item.clicksDone / self.mouseDownObject.item.fixAmount
				self.mouseDownObject.frame = frac * (self.mouseDownObject.frameCount-1)
				self:onProgress()
			else
				self.mouseDownObject:showLastFrame()
				self:itemDone(self.mouseDownObject.item)
			end

			if (self.mouseDownObject.item.bar) then
				self.mouseDownObject.item.bar:setProgress(frac)
			end		
			
		end
		
		self.mouseX = p.x
		self.mouseY = p.y
	end
end

--' ************************************ Click Fix Object ************************************ '--
FixableObject = deriveLuaClass("FixableObject", "EventObject")

function FixableObject:onMouseDown(mX, mY)
	if (self.item.done or level.inStoryMode or not event.started or event.completed) then
		return
	end

--'print("FixableObject:onMouseDown")
	event.mouseDownObject = self
	local p = ghf.getMouseCursorPos()
	event.mouseX = p.x
	event.mouseY = p.y

	event:hideHintArrow()
	event:showProgressBar(self.item)

	if (event.clickSoundId) then
		self:playSample(event.clickSoundId)
	end

	self:newChild({class="ParticleEffect", library="CLICKFIX:particles", x=p.x-self.x, y=p.y-self.y, start=true})
end


function clickFixOnClick(self)
	return false
end
