levelDesc = levelDesc or {}

--' Default values in levelDesc
levelDesc.defaultPoductSettings = {
	orderable = true,
	edible = true,
	lo_cal = 100,
	hi_cal = 100,
	chance = 100,
	veg = true,
	normal = 100,
	locals = 100,
	big = 100,
	elderly = 100,
	kid = 100,
	designer = 100,
	yup = 100,
	easy = false,
	consumeAnimation = "eat",
	tea=false,
}
--' Settings for trophy goals:
--'	dessert=true,
--'	cheeseProduct=true,

levelDesc.counterOrderSize = 2
levelDesc.tableOrderSize  = 4
levelDesc.orderSteps = 1
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

decorationMoneyTarget = 100
decorationMoneyExpert = 100
decorationMoneyChallenge = 25

minChallengeLevelsBetweenEvents = 2
maxChallengeLevelsBetweenEvents = 6

levelDesc.values =
{
	moneyFloaterDelay = 1000,
	moneyFullOrderAtOncePerProduct = 5,
	moneyCustomerChain2 = 11,
	moneyCustomerChain3 = 15,
	moneyCustomerChain4 = 21,
	moneyCustomerChain5 = 25,
	moneySameCustomerType = 11,
	comboCheckout2 = 10,
	comboCheckout3 = 20,
	comboCheckout4 = 0,
	closeDelay = 4000,
	cleanDuration = 4000,
	entertainDuration = 4000,
	moodDropWarning = 5000,
	idleAnimTimeoutMin = 10000,
	idleAnimTimeoutMax = 25000,
	thinkIconFrameTime = 200,
	maxBalloonSize = 6,
	maxTraySize = 3,
	maxTraySizeChallenge1 = 4,
	maxTraySizeChallenge2 = 4,
	maxTraySizeChallenge3 = 4,
	startMood = 3,
	moodDropTime = 10000,
	tableStartMoodDropTimeMultiplier = 2,
	tipNormal = 10,
	tipHappy = 20,
	tipExstatic = 30,
	moneyPerProduct = 10,
	drinkFrameTime = 200,
	eatFrameTime = 200,
	readFrameTime = 200,
	orderFrameTime = 200,
	quickBonusDuration = 5000,
	quickBonus = 100,
	moneyAngryCustomerLeaves = -50,

	--paperReadTime = 7500,
	paperTipNormal = 5,
	paperTipHappy = 10,
	paperTipExstatic = 20,

	danceFrameTime = 110,
	danceTime = 6000,
	danceTipNormal = 10,
	danceTipHappy = 25,
	danceTipExstatic = 50,
}
levelDesc.valueMultipliers =
{
	queueMoodDurationMultiplier = 1.5,
	tableMoodDurationMultiplier = 1,
	counterMoodDurationMultiplier = 1,
	tableTipMultiplier = 1.2,
	entertainDuration = {1.2, 1, 0.8}, --' easy, normal, hard
	moodDropTime = {
		{1.4, 1.1, 1.0}, --' easy
		{1.4, 1.1, 1.0}, --' normal
		{1.4, 1.1, 1.0}, --' hard
	},
	spawnDelay = {
		{ 1.4*1.1, 1.4, 1.4*0.9 }, --' easy
		{ 1.1*1.1, 1.1, 1.0 	}, --' normal
		{ 1.0*1.1, 1.0, 1.0*0.9 }, --' hard
	},
}
levelDesc.valueAdders =
{
	startMood = {
		{1, 1, 1,}, --' easy
		{1, 1, 0,}, --' normal
		{1, 0, 0,}, --' hard
		},
}

levelDesc.gameHouseObjects =
{
	{room=1, shift=4}, --' 1
	{room=1, shift=8}, --' 2
	{room=2, shift=2}, --' 3
	{room=2, shift=8}, --' 4
	{room=3, shift=4}, --' 5
	{room=3, shift=8}, --' 6
	{room=4, shift=2}, --' 7
	{room=4, shift=6}, --' 8
	{room=5, shift=4}, --' 9
	{room=5, shift=8}, --' 10
}
levelDesc.animationDescs =
{
	read = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 1200}, },
	eat = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 1200}, },
	paper = {shouldPlayInStoryMode = false, holdCycleDuration = {3000, 7000}, },
	drink = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 1200}, },
	order = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 1200}, },
	dance = {shouldPlayInStoryMode = false, holdCycleDuration = {0, 0}, },
}

levelDesc.characterTypes =
{
	default = {
		x=-9999, y=-9999,
		class						= "DelCharacter",		--' E.g. "Customer"
		baseAnimation				= "customer-normal",	--' Dummy
		defaultSection				= "characters",			--'
		defaultAnimation			= "idle",				--'
		walkSpeed					= 292,					--' Pixels / sec
		animationWalkSpeed			= 300,					--' Pixels / sec
		verticalWalkMultiplier		= 0.666,				--' Modifies vertical speed
		walkFrameDistanceHor		= 120/(3*2),			--' Pixels to travel for next walk frame (horizontal)
		walkFrameDistanceVer		= 12,					--' Pixels to travel for next walk frame (vertical)
		minAge						= 30,					--'
		maxAge						= 30,					--'
		valueMultipliers			= {},					--'
		valueAdders					= {},					--'
		playIdleAnimations			= true,
		isCustomer					= false,
		allowAutoHorizontalFlip		= true,
		floor						= -10,
		moodPos						= {45, -145},
		moodPosSit					= {-55, -125},
		anchor						= "bottom",
		tableClipHeight				= 54,
		waitAtDirtyTableTime		= 1000,
		shadowResource				= "CHARACTER_SHADOW",
		idleAnimations = {
			{a="idle_www", f=150, c=1},
			{a="idle_xxx", f=150, c=1},
			{a="idle_yyy", f=150, c=1},
			{a="idle_zzz", f=150, c=1},
		},
	},

	--' Main characters
	emily = {
		baseAnimation = "emily",
		walkSpeed = 600,
		sitOffset = {x=3, y=3},
		walkFrameDistanceList = {
		RUN = 230/(3*2),
		},
	},

	francois = {
		baseAnimation = "francois",
		walkSpeed = 600,
	},
	edward = {
		baseAnimation = "edward",
		walkSpeed = 600,
		idleAnimations = {
			{a="idle_xxx", f=150, c=1},
		},	
	},
	evelyn = {
		baseAnimation = "evelyn",
		walkSpeed = 600,
	},
	antonio = {
		baseAnimation = "antonio",
		walkSpeed = 600,
	},
	angela = {
		baseAnimation = "angela",
		walkSpeed = 600,
		tableClipHeight = 52,
	},
	snuggy = {
		baseAnimation = "snuggy",
		animationWalkSpeed = 320,
		walkSpeed = 600,
		idleAnimTimeoutMin = 8000,
		idleAnimTimeoutMax = 15000,
		needsToExitForLevelEnd=false,
		sitOffset = {x=-18, y=-5},
	},
	patrick = {
		baseAnimation = "patrick",
		walkSpeed = 600,
		sitOffset = {x=-3, y=3},
		tableClipHeight = 60,
	},
	carlos = {
		baseAnimation = "carlos",
		walkSpeed = 600,
	},
	carmen = {
		baseAnimation = "carmen",
		walkSpeed = 600,
	},
	isabel = {
		baseAnimation = "isabel",
		walkSpeed = 600,
	},
	fresco = {
		baseAnimation = "fresco",
		walkSpeed = 600,
	},
	philippe = {
		baseAnimation = "philippe",
		walkSpeed = 600,
	},
	nadia = {
		baseAnimation = "nadia",
		walkSpeed = 600,
	},
	amelie = {
		baseAnimation = "amelie",
		walkSpeed = 600,
	},
	jeanpaul = {
		baseAnimation = "jeanpaul",
		walkSpeed = 600,
	},
	jacque = {
		baseAnimation = "jacque",
		walkSpeed = 600,
	},
	monkey = {
		baseAnimation = "monkey",
		walkSpeed = 600,
	},

	--' Customers
	big = {
		baseAnimation = "customer-biggie",
		floor = -10,
		animationWalkSpeed = 280,
		walkFrameDistanceHor = 120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 6000,
		eatTime = 25000, --large
		big = true,
		tableClipHeight = 59,
		sitOffset = {x=-2, y=5},
		valueMultipliers = { moodDropTime = 1.4, }, -- large
	},
	child = {
		baseAnimation = "customer-child",
		floor = -10,
		animationWalkSpeed = 230,
		walkFrameDistanceHor = 120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 6000, --small
		eatTime = 20000,
		tableClipHeight = 45,
		kid = true,
		sitOffset = {x=-2, y=-5},
		valueMultipliers = { moodDropTime = 0.8, }, -- small
		shadowResource = "CHARACTER_SHADOW_SMALL",
	},
	elderly = {
		baseAnimation = "customer-old",
		floor = -10,
		walkSpeed = 230,
		animationWalkSpeed = 230,
		walkFrameDistanceHor = 120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 10000, --large
		eatTime = 25000, --large
		tableClipHeight = 58,
		elderly = true,
		valueMultipliers = { moodDropTime = 1.4, }, -- large
	},
	locals = {
		baseAnimation = "customer-local",
		floor = -10,
		walkFrameDistanceHor = 103/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 20000,
		--regular = true,
		danceFrameTime = 90,
	},
	normal = {
		baseAnimation = "customer-normal",
		floor = -10,
		walkFrameDistanceHor = 103/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 20000,
		--regular = true,
		danceFrameTime = 90,
	},
	yup = {
		baseAnimation = "customer-yup",
		floor = -10,
		walkFrameDistanceHor = 120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 8000,
		eatTime = 15000, -- small
		yup = true,
		valueMultipliers = { moodDropTime = 0.8, }, -- small
	},
	gladys = {
		baseAnimation = "gladys",
		floor = -10,
		walkSpeed = 230,
		animationWalkSpeed = 230,
		walkFrameDistanceHor = 120/(3*2),
		walkFrameDistanceVer = 12,
		thinkTime = 10000, --large
		eatTime = 25000, --large
		tableClipHeight = 54,
		elderly = true,
		valueMultipliers = { moodDropTime = 1.4, }, -- large
	},
	
	--' Special characters
	deliverydriver = {
		baseAnimation = "deliverydriver",
	},
	bigguest = {
		baseAnimation = "bigguest",
	},
	jimmy = {
		baseAnimation = "jimmy",
		thinkTime = 8000,
		eatTime = 20000,
	},
	lady = {
		baseAnimation = "regular_lady",
	},
	guest1 = {
		baseAnimation = "customer-normal_female",
	},
	guest2 = {
		baseAnimation = "customer-local_female",
	},
	guest4 = {
		baseAnimation = "customer-local_male",
	},
	guest3 = {
		baseAnimation = "customer-biggie_female",
	},
	guest5 = {
		baseAnimation = "customer-old_female",
	},

	child2male = {
		baseAnimation = "customer-child2_male",
	},
	yup2male = {
		baseAnimation = "customer-yup2_male",
	},
	yup2female = {
		baseAnimation = "customer-yup2_female",
	},
	biggie2male = {
		baseAnimation = "customer-biggie2_male",
	},
	biggie2female = {
		baseAnimation = "customer-biggie2_female",
	},
	normal2male = {
		baseAnimation = "customer-normal2_male",
	},
	normal2female = {
		baseAnimation = "customer-normal2_female",
	},
	

}

--' So we can access this table more easily from the editor:
_G.chs = levelDesc.characterTypes
