--' Info:
--' Enter your PC's name here to specify where you go when you start the game.
--' If your PC name isn't here, you'll go trough the normal loading/selection/game path.

--' 1) Entering a number will make you go to the level at that index in the 'shifts' table (see above)
--'    Example: PC666 = 2, will make Luc enter "script/shifts/intro2.lua" on startup.

--' 2) Entering a table containing two numbers will make you go to a specific Room & Shift.
--'    Example: PC666 = {2,5}, will make Luc enter Room 2 Shift 5 on startup.

--' 3) Entering a filename will simply load that level.
--'    Example: PC666 = "script/shifts/intro2.lua", will make Luc enter the 2nd intro on startup.
--'    Example: PC666 = "script/shifts/intro2.lua", will make Luc enter the 2nd intro on startup.

--' 4) Entering "load", "selection", "interstitial", "trophy" or "game" will open that specific scene.
--'    Example: PC666 = "trophy", will make Luc enter the Trophy Scene on startup.

---[[
startLevelsForPCs = {
	PC085 = {1,10,2},			--' Luc
	--PC076 = {5,7,2},			--' Roel
	PC087 = {1,1,1},  			--' Ruud
	PC039 = "shop",				--' Dirk
	PC062 = {1,1,1},			--' Andrea
	PC042 = {5,9,1},			--' Django
	--LT042 = {1,1,1},			--' Tj'ien
	PC041 = {1,1,1},			--' Stageplek
	PC091 = {1,1,1}, 			--' Tim
	LT056 = {1,1,1}, 			--' Tjien
	LT044 = {1,1,1}, 			--' Michel
	PC088 = {1,1,1},			--' Jeremy
	ghmac = {1,1,1},			--' Studio MiniMac
	["ipad simulator"] = {1,1,1},
	--["gh ipad"] = {1,1,1},
}

--' List of shifts
local shiftDir = "script/levels/"
shifts = {
	---[[
	{
		{ shiftDir.."appartment_1.lua", shiftDir.."room1_1_pre.lua", shiftDir.."room1_tutorial.lua",  shiftDir.."room1_1.lua", shiftDir.."appartment_2.lua"}, -- appartment ochtend, level, appartment avond
		shiftDir.."room1_2.lua",
		{ shiftDir.."room1_3.lua", shiftDir.."appartment_3.lua"}, 
		shiftDir.."room1_4.lua",
		shiftDir.."room1_5.lua",
		{ shiftDir.."appartment_4.lua", shiftDir.."room1_6.lua"},
		{ shiftDir.."room1_7.lua", shiftDir.."appartment_9.lua"},
		shiftDir.."room1_8.lua",
		{ shiftDir.."appartment_5.lua", shiftDir.."room1_9.lua", shiftDir.."appartment_6.lua"},
		{ shiftDir.."appartment_7.lua", shiftDir.."room1_10.lua", shiftDir.."appartment_8.lua"},
	},
	--]]
	---[[
	{
		shiftDir.."room2_1.lua",
		shiftDir.."room2_2.lua",
		shiftDir.."room2_3.lua",
		shiftDir.."room2_4.lua",
		shiftDir.."room2_5.lua",
		shiftDir.."room2_6.lua",
		shiftDir.."room2_7.lua",
		shiftDir.."room2_8.lua",
		shiftDir.."room2_9.lua",
		shiftDir.."room2_10.lua",
	},
	--]]
	---[[
	{
		{ shiftDir.."room3_1.lua", shiftDir.."sleepingcar_1.lua"}, --' meets philippe
		{ shiftDir.."room3_2.lua", shiftDir.."sleepingcar_2.lua"}, --' philippe wants to eat together, then both go sleep
		shiftDir.."room3_3.lua",
		{ shiftDir.."sleepingcar_3.lua", shiftDir.."room3_4.lua", shiftDir.."sleepingcar_4.lua"}, --' philippe is writing a review, philippe wants to have dinner
		shiftDir.."room3_5.lua",
		{ shiftDir.."room3_6.lua", shiftDir.."sleepingcar_5.lua"}, --' opens pyjamas
		shiftDir.."room3_7.lua",
		shiftDir.."room3_8.lua",
		{ shiftDir.."room3_9.lua", shiftDir.."sleepingcar_6.lua"}, --' philippe leaves after tearing up his review
		shiftDir.."room3_10.lua",
	},
	--]]
	---[[
	{
		{ shiftDir.."room4_1.lua", shiftDir.."eiffeltower_1.lua"}, --' Romantic eiffeltower introduction
		{ shiftDir.."eiffeltower_2.lua", shiftDir.."room4_2.lua"}, --' meet Amelie + flowers
		shiftDir.."room4_3.lua", 
		{ shiftDir.."eiffeltower_3.lua", shiftDir.."room4_4.lua"}, --' after first kiss
		shiftDir.."room4_5.lua",
		{ shiftDir.."eiffeltower_4.lua", shiftDir.."room4_6.lua"}, --'promise to be at my wedding?
		shiftDir.."room4_7.lua",
		{ shiftDir.."room4_8.lua", shiftDir.."eiffeltower_5.lua"}, --'most devastating moment in casual gaming
		shiftDir.."room4_9.lua",
		shiftDir.."room4_10.lua",
	},
	--]]
	---[[
	{
		{shiftDir.."room5_1.lua", shiftDir.."appartment_11.lua"},
		{shiftDir.."room5_11.lua", shiftDir.."appartment_12.lua", shiftDir.."room5_2.lua", },
		shiftDir.."room5_3.lua",
		shiftDir.."room5_4.lua",
		shiftDir.."room5_5.lua",
		shiftDir.."room5_6.lua",
		{shiftDir.."appartment_57.lua", shiftDir.."room5_7.lua"},
		shiftDir.."room5_8.lua",
		shiftDir.."room5_9.lua",
		{shiftDir.."appartment_10.lua", shiftDir.."room5_10.lua"},
	},

	{ --' rest 6
		shiftDir.."room6_1.lua",
		shiftDir.."room6_2.lua",
		{ shiftDir.."room6_3.lua", shiftDir.."appartment_13.lua"},
		shiftDir.."room6_4.lua",
		shiftDir.."room6_5.lua",
		shiftDir.."room6_6.lua",
		shiftDir.."room6_7.lua",
		shiftDir.."room6_8.lua",
		shiftDir.."room6_9.lua",
		{ shiftDir.."room6_10.lua", shiftDir.."room5_12.lua"},
	},

}
bonusStoryShifts = {
	{
		shiftDir.."room6_1.lua",
		shiftDir.."room6_2.lua",
		{ shiftDir.."room6_3.lua", shiftDir.."appartment_13.lua"},
		shiftDir.."room6_4.lua",
		shiftDir.."room6_5.lua",
		shiftDir.."room6_6.lua",
		shiftDir.."room6_7.lua",
		shiftDir.."room6_8.lua",
		shiftDir.."room6_9.lua",
		shiftDir.."room6_10.lua",
	}
	--]]
}
