setups = setups or {}
scenes = scenes or {}
dialogs = dialogs or {}
blueprints = blueprints or {}

setups.silent_btn = { flash=_iOS(true), feedback=_iOS("FEEDBACK:particles"), fireOnDown=_iOS(true), }
setups.btn = { flash=_iOS(true), feedback=_iOS("FEEDBACK:particles"), fireOnDown=_iOS(true), clickSound="SOUND_BUTTON", soundSection="default", }
setups.swtch = { flash=_iOS(true), feedback=_iOS("FEEDBACK:particles"), image="RADIO:default", offSound="SOUND_CHECKBOX_OFF", onSound="SOUND_CHECKBOX_ON", soundSection="default", }

blueprints.default_painter = {
	class = "DelPainter",
	section = "default",
	centerColor = 0xffffff,
	centeralpha = 1.0,
	sides_offset_x = 50,
	sides_offset_y = 50,
	images = {
		"BORDER_TOP_LEFT", "BORDER_TOP_CENTER", "BORDER_TOP_RIGHT",
		"BORDER_CENTER_LEFT", "CENTER_BACKGROUND", "BORDER_CENTER_RIGHT",
		"BORDER_BOTTOM_LEFT", "BORDER_BOTTOM_CENTER", "BORDER_BOTTOM_RIGHT",
	},
}

blueprints.progressbar_big = {
	class = "ProgressBar",
	back = {class="Sprite", image="PROGRESSBAR:gamescene", anchor="center"},
	front = {class="Sprite", image="PROGRESSBAR_FILL:gamescene", anchor="center", x=-1, y=-2},
}

blueprints.progressbar_click_fix = {
	class = "ProgressBar",
	back = {class="Sprite", image="PROGRESSBAR_CLICK_FIX:gamescene", anchor="center"},
	front = {class="Sprite", image="PROGRESSBAR_CLICK_FIX_FILL:gamescene", anchor="center", x=-1, y=-2},
	label = {class="Label", name="EVENT_VALUE", font="FONT_FLOATERS", color0=0xfff88a, color1=0x471e1A, scaleY=0.65, scaleX=0.8, x=0, y=0, anchor="center", pivot="center" }
}

blueprints.label_floater = {
	class="Label",
	font="FONT_FLOATERS:default",
	anchor="center",
	align="center",
	lineHeight=25,
	roundPos=false,
}

blueprints.sprite_label_floater = {
	class="LabelLetters",
	font="FONT_FLOATERS:default",
	anchor="center",
	align="center",
	lineHeight=25,
	maxWidth=300,
	wrapStyle="word",
	roundPos=false,
}

blueprints.label_floater_deco_money = {
	class="Label",
	font="FONT_FLOATERS:default",--'TODO: Specify proper font
	anchor="left",
	align="left",
	lineHeight=25,
	roundPos=false,
}

blueprints.day_end = {
	class = "DayWon", id="DAY_WON", width=1024, height=768, color="black",
	children = {
		{ class="Sprite", name="SPRITE_WON_TEXT", x=500, y=170, image="day_completed:score_dialog", anchor="top"},
		{ class="Sprite", name="INFO_BG", x=243, y=292, image="score_info_space:score_dialog",
			children = {
				{ class="Sprite", name="SPRITE_SCORE_CONTAINER",
					children = {
						{ class="Sprite", name="SPRITE_SCOREBAR_BACK", x=23, y=67, image="score_bar:score_dialog",
							children = {
								{ class="Sprite", name="SPRITE_SCOREBAR", x=4, y=3, image="score_bar_full:score_dialog"},

								{ class="Sprite", name="SPRITE_SCORE_SLIDER", y=19, image="slider:score_dialog", anchor="top"},
								{ class="Label", name="LABEL_SCORE_SLIDER", y=32, font="FONT_DIALOG_SLIDER_SCORE:score_dialog", anchor="top"},

								{ class="Sprite", name="SPRITE_STAR_TARGET", y=7, image="star_target:score_dialog", anchor="center"},
								{ class="Sprite", name="SPRITE_STAR_EXPERT", y=7, image="star_expert:score_dialog", anchor="center"},

								{ class="Label", name="LABEL_SCORE_TODAY", x=2, y=-15, font="font_score_dialog:score_dialog", anchor="left",
									children={
										{ class="Label", name="LABEL_SCORE_TODAY_SCORE", x=150, y=0, font="font_score_dialog:score_dialog", anchor="left"},
									},
								},

								{ class="Label", name="LABEL_SCORE_TARGET_LABEL", y=-35, font="font_score_dialog:score_dialog", anchor="center", align="center"},
								{ class="Label", name="LABEL_SCORE_EXPERT_LABEL", y=-35, font="font_score_dialog:score_dialog", anchor="center", align="center"},

								{ class="Sprite", name="SPRITE_TARGET_REACHED", x=241, y=85, image="score_target:score_dialog", anchor="center"},

								{ class="Sprite", name="SPRITE_TOTAL_SCORE", x=252, y=137, visible=false, image="total_score:score_dialog", anchor="center",
									children={
										{ class="Label", name="LABEL_SCORE_TOTAL_SCORE", x=94, y=3, font="font_score_highscore:score_dialog", anchor="left"},
									},
								},
							},
						},
					},
				},
				{ class="Label", name="LABEL_DAY_FAILED_TIP_LEADER", x=100, y=160, wrapStyle="word", maxWidth=350, font="font_score_dialog:score_dialog", anchor="topRight", textId="DAY_FAIL_TIP"},
				{ class="Label", name="LABEL_DAY_FAILED_TIP", x=110, y=160, wrapStyle="word", maxWidth=350, font="font_score_dialog:score_dialog", anchor="topLeft",},
				{ class="Label", name="LABEL_SHOP_AVAILABLE_TIP", x=241, y=190, wrapStyle="word", maxWidth=350, font="font_score_dialog:score_dialog", anchor="top", textId="SHOP_ITEM_AVAILABLE", visible=false},
			},
		},
		{ class="Sprite", name="fb", x=242, y=445, image="facebook_info_space:score_dialog", alpha=0,
			children = {
				{ class="Button", x=-4, y=9, image="facebook_info_button:score_dialog", name="fb_post", enabled=false},
				{ class="Sprite", x=15, y=35, name="fb_icon"},
				{ class="Sprite", x=274, y=-3, image="facebook_great_job:score_dialog", anchor="top"},
				{ class="Label", x=278, y=100, font="font_score_dialog:score_dialog", anchor="center", name="fb_text", wrapStyle="word", maxWidth=250, lineHeight=24},
			},
		},
		{class="Sprite", name="LIVES", x=409, y=557, anchor="left", },
		{class="Button", name="shop", x=743, y=720, image="button_shop:interstitial", setup=setups.btn},
		{class="Button", name="retry", x=883, y=720, image="button_try_again:score_dialog", setup=setups.btn},
		{class="Button", name="continue", x=883, y=720, image="MENU_RESUME:gamescene", setup=setups.btn},
	},
}

blueprints.checkbook = {
	class = "Checkbook",
	name="Checkbook",
	children = {
		{class="Sprite", name="checkbook", x=0, y=768, image="checkbook:shop_scene", anchor="bottomLeft"},
		{class="Label", name="money", x=226, y=725, font="font_shop_money:default", anchor="topRight", rotation=-4, roundPos=false},
	},
}

scenes.gameTransition = { class = "FadeBlackTransition", time = 1000, } --' Should optionally go through a 'loading' scene
scenes.ingameTransition = { class = "FadeBlackTransition", time = 1000, unload  = false, } --' Should optionally go through a 'loading' scene
scenes.defaultTransition = { class = "FadeBlackTransition", time = 500, }

scenes.endGameTransition = {
	class = "EndGameTransition",
	time = 500,
	showTime = 8000,
	showDelay = 700,
	sceneComponents = {
		{class="Label", name="LABEL_END", x=512, y=400, anchor="center", font="FONT_DIALOG_HEADER:default", textId="END_GAME_THANKS", align="center", wrapStyle="word", maxWidth=900,},
	},
}

scenes.splashTransition = {
	class = "FadeBlackTransition",
	time = 500,
	sceneComponents = {
		{class="Sprite", name="LOADING_TEXT", x=512, y=717, image="LOADING_PLEASE_WAIT:default", anchor="top"},
	},
}

scenes.splash = {
	class = "SceneSplash",
	roundAllPositions = true,
	scaleToFitScreen = true,	
	background = "SPLASH_BACKGROUND:splash",
}

scenes.load = {
	class = "SceneLoad",
	roundAllPositions = true,
	scaleToFitScreen = true,
	sceneComponents = {
		{class="TheoraVideo", name="video", file="movies/intro.ogv", autoSize=false, width=1024, height=768},
		{class="Button", name="LOADING_TEXT", x=512, y=715, image="LOADING_PLEASE_WAIT:default", anchor="top", setup=setups.btn},
	},
	playVideo = function(self)
		self:getChild("video"):sendToBack()
		self:getChild("video").customStream = "MUSIC_INTRO_OGV:music"
		self:getChild("video"):play()
		self:getChild("video").onEndReached = function()
			self.videoEnded = true
		end

		local black = self:newChild({class="Sprite", color="black", draw="color", width=1024, height=768})
		black:sendToBack()
	end
}

scenes.selection = {
	class = "SceneSelection",
	roundAllPositions = true,
	scaleToFitScreen = true,
	background = "BACKGROUND:selection_scene",
	sceneComponents = {
	
		{class="TheoraVideo", name="video", file="movies/selection.ogv", autoSize=false, width=1024, height=768},
		
		{class="Sprite", x=97, y=634, name="FACEBOOK", image="facebook_button_info:sceneselection", anchor="left"},
		{class="Button", x=166, y=627, likedX=71, likedY=672, name="BUTTON_FACEBOOK", image="facebook_button:sceneselection", anchor="right", setup=setups.btn},
		
		{class="Sprite", name="Emily", x=0, y=0, image="selection_emily:selection_scene"},

		{class="Label", name="PLAYER_NAME", x=277, y=429, anchor="center", font="FONT_SELECTION_WELCOME:sceneselection", lineHeight=30, },
		{class="Button", name="BUTTON_CHANGEPLAYER", x=277, y=485, image="BUTTON_CHANGEPLAYER:sceneselection", anchor="center", setup=setups.btn},		
		{class="Button", name="BUTTON_PLAY", x=277, y=539, image="BUTTON_PLAY:sceneselection", anchor="center", setup=setups.btn},

		{class="Sprite", name="GUIBAR", x=0, y=768, image=_iOS("gui_bar:interstitial", "GUI_BAR:sceneselection"), anchor="bottomLeft",
			children={
				{class="Sprite", name="GUIBAR_EXT", x=512, y=0, image=_iOS("gui_bar:interstitial", "GUI_BAR:sceneselection"), anchor="bottomLeft", currentFrame=1},
			},
		},
		{class="Button", x=_iOS(120, 100), y=744, name="BUTTON_TUTORIAL", image="button_tutorial:sceneselection", anchor="center", setup=setups.btn},
		{class="Button", x=_iOS(381, 307), y=744, name="BUTTON_SETTINGS", image="MENU_SETTINGS:gamescene", anchor="center", setup=setups.btn},
		{class="Button", x=_iOS(625, 512), y=744, name="BUTTON_UPSELL", image="button_upsell:sceneselection", anchor="center", setup=setups.btn},
		{class="Button", x=_iOS(904, 717), y=741, name="BUTTON_EXTRA", image=_deluxe("BUTTON_EXTRA:sceneselection", "BUTTON_PREMIUM:sceneselection"), anchor="center", setup=setups.btn},
		{class="Button", x=925, y=744, name="BUTTON_EXIT", image="BUTTON_EXITGAME:sceneselection", anchor="center", setup=setups.btn},

	},	
	playVideo = function(self)
		local video = self:newChild({class="TheoraVideo", name="video", file="movies/outro.ogv", autoSize=false, width=1024, height=768})
		local black = self:newChild({class="Sprite", color="black", draw="color", width=1024, height=768})
		black:moveBehind(video)
		video.customStream = "MUSIC_INTRO_OGV:music"
		video:play()
		video.onEndReached = function()
			self:showUpsell()
			video.obsolete = true
			black.obsolete = true
		end
	end	
}

scenes.shop = {
	class = "ShopScene",
	roundAllPositions = true,
	scaleToFitScreen = true,
	sceneComponents = {
		{class="Sprite", name="background", x=0, y=0,},
		{class="Sprite", name="upgrades", x=0, y=0,},
		{class="Button", name="back", x=882, y=719, image="MENU_RESUME:gamescene", setup=setups.btn},
	},
	buttonPositions = {
--' STD item positions
--'1	{x=82, y=363},
--'2	{x=311, y=363},
--'3	{x=67, y=620},
--'4	{x=790, y=287},
--'5	{x=563, y=622},
--'6	{x=789, y=622},
--' Premium item positions
--'1	{x=82, y=363},
--'2	{x=311, y=363},
--'3	{x=67, y=620},
--'4	{x=563, y=215},
--'5	{x=789, y=215},
--'6	{x=789, y=418},
--'7	{x=563, y=622},
--'8	{x=789, y=622},
		{--' Room 1
			std = {
				{x=82, y=363},
				{x=311, y=363},
				{x=67, y=620},
				{x=790, y=287},
				{x=563, y=621},
				{x=789, y=622},
			},
			premium = {
				{x=82, y=363},
				{x=789, y=622},
				{x=67, y=620},
				{x=789, y=418},
				{x=789, y=215},
				{x=311, y=363},
				{x=563, y=215},
				{x=563, y=621},
			}
		},
		{--' Room 2
			std = {
				{x=82, y=363},
				{x=311, y=363},
				{x=67, y=620},
				{x=790, y=287},
				{x=563, y=621},
				{x=789, y=622},
			},
			premium = {
				{x=82, y=363},
				{x=789, y=215},
				{x=67, y=620},
				{x=789, y=418},
				{x=563, y=215},
				{x=311, y=363},
				{x=563, y=622},
				{x=789, y=622},
			}
		},
		{--' Room 3
			std = {
				{x=67, y=620},
				{x=82, y=363},
				{x=563, y=622},
				{x=311, y=363},
				{x=790, y=287},
				{x=789, y=622},
			},
			premium = {
				{x=67, y=620},
				{x=82, y=363},
				{x=789, y=622},
				{x=311, y=363},
				{x=789, y=418},
				{x=563, y=215},
				{x=563, y=622},
				{x=789, y=215},
			}
		},
		{--' Room 4
			std = {
				{x=67, y=620},
				{x=82, y=363},
				{x=790, y=287},
				{x=563, y=622},
				{x=789, y=622},
				{x=311, y=363},
			},
			premium = {
				{x=67, y=620},
				{x=82, y=363},
				{x=789, y=418},
				{x=563, y=622},
				{x=563, y=215},
				{x=311, y=363},
				{x=789, y=215},
				{x=789, y=622},
			}
		},
		{--' Room 5
			std = {
				{x=67, y=620},
				{x=82, y=363},
				{x=790, y=287},
				{x=311, y=363},
				{x=789, y=622},
				{x=563, y=622},
			},
			premium = {
				{x=67, y=620},
				{x=82, y=363},
				{x=789, y=418},
				{x=311, y=363},
				{x=789, y=215},
				{x=563, y=622},
				{x=789, y=622},
				{x=563, y=215},
			}
		},	
	},
}

blueprints.shop_item = {
	class = "ShopItem",
	image= "pricetag_100:shop_scene",
	children = {
		{class="Button", name="buy_button", x=143, y=40, image="buy_button:shop_scene", anchor="center"},
		{class="Sprite", name="bought_button", x=143, y=34, image="bought_button:shop_scene", anchor="center"},
		{class="Sprite", name="desc_top", x=0, y=0, image="price_top:shop_scene", anchor="bottomLeft",
		children = {
			{class="Label", name="title", x=13, y=-8, font="FONT_TEXT:default", anchor="topLeft", align="left", roundPos=false},
			{class="Label", name="item_description", x=13, y=13, font="font_item_info:shop_scene", maxWidth=169, wrapStyle="word", anchor="topLeft", align="left", roundPos=false},
			{class="Sprite", name="extra_star", x=185, y=0, image="extra_star:shop_scene", anchor="center",
				children = {{class="Sprite", name="extra_text", x=0, y=0, image="premium_text:shop_scene", anchor="center"}},},
		}},
	},
}

scenes.trophy = {
	class = "SceneTrophy",
	roundAllPositions = true,
	scaleToFitScreen = true,
	background = "TROPHY_BACKGROUND:trophy_scene",
	sceneComponents = {
		{class="Button", name="BUTTON_BACK", x=5, y=719, image="BUTTON_BACK", setup=setups.btn},
		{class="Button", name="BUTTON_SHOW", x=1013, y=719, image="button_taste:trophy_scene", anchor="topRight", setup=setups.btn, },
		box = {
			class = "GameNode",
			name = "NODE_BOX_HIGHLIGHT",
			trophyZBtF = {6, 14, 16, 15, 8, 13, 3, 7, 19, 26, 22, 18, 2, 5, 1, 4, 25, 11, 9, 17, 20, 12, 21, 10, 24, 23},
			children = {
				{class="SpriteExt", name="trophy_1", x=241, y=249, baseAnimation="trophy_1:trophy_scene",},
				{class="SpriteExt", name="trophy_2", x=584, y=250, baseAnimation="trophy_2:trophy_scene",},
				{class="SpriteExt", name="trophy_3", x=596, y=124, baseAnimation="trophy_3:trophy_scene",},
				{class="SpriteExt", name="trophy_4", x=749, y=250, baseAnimation="trophy_4:trophy_scene",},
				{class="SpriteExt", name="trophy_5", x=382, y=227, baseAnimation="trophy_5:trophy_scene",},
				{class="SpriteExt", name="trophy_6", x=669, y=41, baseAnimation="trophy_6:trophy_scene",},
				{class="SpriteExt", name="trophy_7", x=485, y=151, baseAnimation="trophy_7:trophy_scene",},
				{class="SpriteExt", name="trophy_8", x=395, y=101, baseAnimation="trophy_8:trophy_scene",},
				{class="SpriteExt", name="trophy_9", x=537, y=320, baseAnimation="trophy_9:trophy_scene",},
				{class="SpriteExt", name="trophy_10", x=284, y=420, baseAnimation="trophy_10:trophy_scene",},
				{class="SpriteExt", name="trophy_11", x=669, y=344, baseAnimation="trophy_11:trophy_scene",},
				{class="SpriteExt", name="trophy_12", x=623, y=420, baseAnimation="trophy_12:trophy_scene",},
				{class="SpriteExt", name="trophy_13", x=767, y=101, baseAnimation="trophy_13:trophy_scene",},
				{class="SpriteExt", name="trophy_14", x=537, y=77, baseAnimation="trophy_14:trophy_scene",},
				{class="SpriteExt", name="trophy_15", x=131, y=67, baseAnimation="trophy_15:trophy_scene",},
				{class="SpriteExt", name="trophy_16", x=278, y=67, baseAnimation="trophy_16:trophy_scene",},
				{class="SpriteExt", name="trophy_17", x=320, y=321, baseAnimation="trophy_17:trophy_scene",},
				{class="SpriteExt", name="trophy_18", x=80, y=211, baseAnimation="trophy_18:trophy_scene",},
				{class="SpriteExt", name="trophy_19", x=221, y=167, baseAnimation="trophy_19:trophy_scene",},
				{class="SpriteExt", name="trophy_20", x=210, y=377, baseAnimation="trophy_20:trophy_scene",},
				{class="SpriteExt", name="trophy_21", x=407, y=377, baseAnimation="trophy_21:trophy_scene",},
				{class="SpriteExt", name="trophy_22", x=758, y=201, baseAnimation="trophy_22:trophy_scene",},
				{class="SpriteExt", name="trophy_23", x=428, y=505, baseAnimation="trophy_23:trophy_scene",},
				{class="SpriteExt", name="trophy_24", x=519, y=419, baseAnimation="trophy_24:trophy_scene",},
				{class="SpriteExt", name="trophy_25", x=131, y=303, baseAnimation="trophy_25:trophy_scene",},
				{class="SpriteExt", name="trophy_26", x=55, y=137, baseAnimation="trophy_26:trophy_scene",},

				{class="Label", name="LABEL_TROPHY_TITLE", x=539, y=677, anchor="center", align="center", font="FONT_TROPHY_BOX:default"},
				{class="Label", name="LABEL_TROPHY_DESCRIPTION", x=539, y=709, anchor="center", align="center", maxWidth=500, wrapStyle="word", font="FONT_TROPHY_PLATE:default"},
				{class="Label", name="LABEL_TROPHY_COUNTER", x=539, y=744, anchor="center", align="center", maxWidth=500, font="FONT_TROPHY_PLATE:default"},
			},
		},
	},
}

scenes.game = {
	class = "SceneGame",
	gui = {
		class = "GameNode",
		name = "NODE_GUI",
		children = 
		{
			{class="Sprite", name="GUIBAR", image="GUI_BAR:gamescene", x=0, y=768, anchor="bottomLeft",
				children={
					{class="Sprite", name="GUIBAR_RIGHT", image="GUI_BAR:gamescene", x=512, y=0, anchor="bottomLeft", currentFrame=1},
				}
			},
			{class="Button", name="BUTTON_MENU", command="menu", image="BUTTON_MENU:gamescene", x=11, y=722, anchor="topLeft", setup=setups.btn},
			{class="Sprite", name="SCORE_BAR", image="SCORE_BAR:gamescene", x=649, y=747 },
			{class="EventBar", name="EVENTBAR",
				labelX1 = 176, labelX2 = 246,
				labelY1 = 725, labelY2 = 715,
				valuesX1 = 317, valuesX2 = 246,
				children = {
					{class="Sprite", name="CLOSED_BAR", image="EVENTBAR_CLOSED:gamescene", x=164, y=768, anchor="bottomLeft" },
					{class="Sprite", name="EVENT_BAR", image="time_bar_event_white", x=177, y=747, startColor=0x80ce36, endColor=0xcd363a},
					--[[
					{class="Sprite", name="EVENT_BAR", image="EVENT_BAR:gamescene", x=177, y=747,
						children = {
							{class="Sprite", name="FRONT", image="EVENT_BAR_RED:gamescene", x=0, y=0, alpha=0}
						},					
					},
					]]--
					{class="Sprite", name="EVENT_ICON", x=355, y=732, anchor="center" },
					{class="Sprite", name="EVENT_CALLOUT", x=355, y=704, anchor="bottom", image="ICON_EXCLAMATION:icons"},
					{class="Sprite", name="EVENT_CURTAIN", image="CURTAIN:gamescene", x=330, y=704 },
					{class="Label", name="EVENT_TEXT", font="FONT_FLOATERS", color0=0xffffff, color1=0x471e1A, scaleX=0.8, scaleY=0.65, x=176, y=715, textId="TEXT_EVENT", anchor="topLeft", pivot="center" },
					{class="Label", name="EVENT_VALUE", font="FONT_FLOATERS", color0=0xfff88a, color1=0x471e1A, scaleX=0.8, scaleY=0.65, x=317, y=715, anchor="topRight", pivot="center", text="0/0" },
				},
			},
			{class="Sprite", name="CLOCK_FRAME_RED", image="CLOCK_FRAME_RED:gamescene", x=438, y=732, anchor="center"},
			{class="ThresholdSprite", name="CLOCK_RING", image="CLOCK_RING:gamescene", thresholdMask="CLOCK_THRESHOLD:gamescene", x=438, y=732, anchor="center", canShowBlack=true },
			{class="Sprite", name="CLOCK_FRAME", image="CLOCK_FRAME:gamescene", x=438, y=732, anchor="center"},
			{class="Sprite", name="CLOCK_POINTER", image="CLOCK_POINTER:gamescene", x=438, y=732, anchor="center" },
			{class="Label", name="SCORE_TEXT", font="FONT_FLOATERS", color0=0xffffff, color1=0x471e1A, scaleX=0.8, scaleY=0.65, x=647, y=715, textId="TEXT_SCORE", anchor="topLeft", pivot="center" },
			{class="Label", name="SCORE_VALUE", font="FONT_FLOATERS", color0=0xfff88a, color1=0x471e1A, scaleX=0.8, scaleY=0.65, x=695, y=715, text="0", anchor="topLeft", pivot="center" },

			{class="Sprite", name="TARGET_INDICATOR", image="TARGET_NORMAL:gamescene", y=743, anchor="bottom", },
			{class="Label", name="TARGET_SCORE", font="FONT_FLOATERS", color0=0xfff88a, color1=0x471e1A, scaleX=0.8, scaleY=0.65, scaleX=0.8, y=720 },
			{class="Sprite", name="EXPERT_INDICATOR", image="TARGET_EXPERT:gamescene", y=743, anchor="bottom", },
			{class="Label", name="EXPERT_SCORE", font="FONT_FLOATERS", color0=0xfff88a, color1=0x471e1A, scaleX=0.8, scaleY=0.65, scaleX=0.8, y=720 },
			{class="Tray", name="TRAY", x=4, y=643, children={{class="Sprite", name="ICONS", x=47, y=33}}, },
			--{class="Sprite", name="LIVES", x=9, y=35, anchor="left", },

			{class="Label", name="SHIFT_INDICATOR", font="FONT_DIALOG_HEADER:default", skewX=-0.3, color0=0xADEAF4, x=539, y=741, anchor="center" },

		},
	},
}

scenes.interstitial = {
	class = "InterstitialScene",
	roundAllPositions = true,
	scaleToFitScreen = true,
	calendarPos = {x=536, y=129},
	cliffHangersPos = {x=250, y=385},
	buttonsY = 14,
	star = {class="Sprite", name="STAR", x=44, y=12, anchor="center", image="extra_star:shop_scene", frameTime=100, 
				children={							
					{class="Sprite", x=0, y=0, anchor="center", image=_deluxe("extra_text:shop_scene", "premium_text:shop_scene") }
				},
			},
	sceneComponents = {
		{class="Sprite", name="BACKGROUND"},
		{class="RestaurantSelection", name="RESTAURANT_SELECTION", image="top:interstitial", x=0, y=-120,
			children={
				{class="Sprite", x=512, y=0, image="top:interstitial", currentFrame=1},
				{class="Switch", name="REST1", image="button_room1:calendar_scene", group=40, setup=setups.swtch, visible=false, },
				{class="Switch", name="REST2", image="button_room2:calendar_scene", group=40, setup=setups.swtch, visible=false},
				{class="Switch", name="REST3", image="button_room3:calendar_scene", group=40, setup=setups.swtch, visible=false},
				{class="Switch", name="REST4", image="button_room4:calendar_scene", group=40, setup=setups.swtch, visible=false},
				{class="Switch", name="REST5", image="button_room5:calendar_scene", group=40, setup=setups.swtch, visible=false},
				{class="Switch", name="REST6", image="button_room6:calendar_scene", group=40, setup=setups.swtch, visible=false},
				{class="Label", name="LABEL_PROGRESS", x=1024/2, y=100, font="FONT_TEXT:default", anchor="center"},
			},
		},	
		{class="Sprite", name="GUIBAR", x=0, y=1024, image="gui_bar:interstitial",
			children={
				{class="Sprite", x=512, y=0, image="gui_bar:interstitial", currentFrame=1},
				
				{class="Button", x=60, name="BUTTON_MENU", image="button_main_menu:default", setup=setups.btn},
				{class="Button", x=834, name="BUTTON_START", image="button_start:interstitial", setup=setups.btn},
				{class="Button", x=318, name="BUTTON_SHOP", image="button_shop:interstitial", setup=setups.btn, fireOnDown=true},
				{class="Button", x=576, name="BUTTON_TROPHY", image="button_trophy:interstitial", setup=setups.btn, enabled=false,},
				{class="Button", x=576, name="BUTTON_MEMORIES", image="button_memories:interstitial", setup=setups.btn, enabled=false, },
			},
		},
		{class="Calender", name="CALENDAR", buttonStarsOffset={x=3, y=-7}, blockHeight = 44,
			children={
				{class="Sprite", x=239, y=82, name="LOGO", anchor="center"},
				{class="Sprite", x=-45, y=21, name="SPECIALITEM"},
				{class="Sprite", x=303, y=234, name="MOUSE", image="mouse_appear:calendar_scene", leftX=303, rightX=369},

				{class="Sprite", x=0, y=0, name="TOP_EPISODECONTAINER",
				children={
					--' Children for story mode selections
					{class="Sprite", x=241, y=216, name="EPISODENRBIG", image="calendar_numbers_big1:calendar_scene", anchor="center"},
					{class="Label",  x=237, y=145, name="EPISODELABEL", font="font_calender_episode_not_selected:calendar_scene", anchor="center", roundPos=false},

--'					{class="Label",  x=270, y=148, name="EPISODELABEL", wrapStyle="word", maxWidth=350, font="font_calendar_episode_title", anchor="left", roundPos=false},
--'					{class="Label", x=227, y=180, name="DAYNR", font="font_calendar_day_numbers:calendar_scene", anchor="center", roundPos=false},

--'					{class="Sprite", x=399, y=174, name="STAREMPTY", image="star_empty_big:calendar_scene"},
--'					{class="Sprite", x=403, y=179, name="STARTARGET", image="star_target_big:calendar_scene"},
--'					{class="Sprite", x=403, y=179, name="STAREXPERT", image="star_expert_big:calendar_scene"},

					--'{class="Sprite", x=334, y=193, name="NOTE1", anchor="center"},
					--'{class="Sprite", x=345, y=198, name="NOTE2", anchor="center"},
				}},

				{class="Sprite", x=51, y=284, name="ACTIVE_EPISODE", image="room1_episode_select:calendar_scene"},

	--'			{class="Sprite", x=0, y=0, name="TOP_CHALLENGECONTAINER",
	--'			children={
	--'				{class="Sprite", x=238, y=145, name="EPISODEHEADER", image="challenge:calendar_scene", anchor="center"},
	--'
	--'				{class="Label", x=173, y=205, name="CHALLENGEREACHED", font="font_calendar_challenge_reached:calendar_scene", anchor="center", align="center", roundPos=false},
	--'				{class="Label",  x=349, y=197, name="HIGHSCORE", wrapStyle="word", maxWidth=350, font="font_calendar_day_numbers", anchor="center", align="center", roundPos=false},
	--'			}},

	--'			{class="Sprite", x=49, y=245, name="CHALLENGEBLOCK",
	--'			children={
	--'				{class="Sprite", x=153, y=150, name="EPISODENRSMALL", image="calendar_numbers_small:calendar_scene"},
	--'				{class="Label",  x=270, y=148, name="EPISODETITLE", wrapStyle="truncate", maxWidth=350, font="FONT_CALENDAR_EPISODE_TITLE", anchor="left", roundPos=false},

	--'				{class="SpecialSwitch", name="CHALLENGE", x=59, y=7, image="button_challenge_game:calendar_scene", group=42, hitMaskThreshold=0.9, reactWhenChecked=true},
	--'			}},
			},
		},
		{class="Sprite", x=258, y=425, name="cliffhanger_heart", image="heart:calendar_scene", anchor="center"},
		{class="Sprite", x=258, y=425, name="cliffhanger", image="room1_cliffhanger_1:calendar_scene", anchor="center"},
		{class="Sprite", x=116, y=280, name="NEXTTIME", image="next_time:calendar_scene", anchor="center"},

		{class="Sprite", x=97, y=634, name="FACEBOOK", image="facebook_button_info:sceneselection", anchor="left"},
		{class="Button", x=166, y=627, likedX=71, likedY=672, name="BUTTON_FACEBOOK", image="facebook_button:sceneselection", anchor="right", setup=setups.btn},

--'		{class="Sprite", name="POLAROIDSTACK", throwDuration=135, throwSpacing=115,
--'			polaroidSettings={
--'				--'{offset={x=0, y=40}, rotation=0}, --' Neutral
--'				{offset={x=0, y=37}, rotation=-0.08},--'xoffset, yoffset, rotation
--'				{offset={x=18, y=39}, rotation=0.1},
--'				{offset={x=-5, y=34}, rotation=-0.06},
--'				{offset={x=-15, y=41}, rotation=0.04},
--'				{offset={x=13, y=35}, rotation=-0.14},
--'				{offset={x=3, y=31}, rotation=-0.06},
--'				{offset={x=-13, y=38}, rotation=0.09},
--'				{offset={x=-5, y=43}, rotation=-0.05},
--'				{offset={x=19, y=39}, rotation=-0.11},
--'				{offset={x=1, y=38}, rotation=0.07},
--'			},
--'			children={
--'				{class="Sprite", name="POLAROIDS"},
--'				{class="Sprite", x=-132, y=-144, name="NEXTTIME", image="next_time:calendar_scene", anchor="center"},
--'				{class="Sprite", x=0, y=205, name="CLIFFHANGERCLOUD", image="cliffhanger_cloud:calendar_scene", anchor="center",
--'					children={
--'						{class="Label", x=0, y=0, name="CLIFFHANGER", font="font_calendar_cliffhanger:calendar_scene", anchor="center", align="center", roundPos=false},
--'					}
--'				},
--'			},
--'		},
	--'	{class="Sprite", x=10, y=80, name="challenge_dialog", image="challenge_dialog:calendar_scene", visible=false, },
	},
}

blueprints.calendar_episode_block = {
	class="Sprite", x=49, y=287,
	children={
--'		{class="Label", name="EPISODENR", x=17, y=24, wrapStyle="word", maxWidth=75, font="font_calendar_episode_numbers:calendar_scene", anchor="right", roundPos=false},
		{class="Sprite", name="UNLOCKED",
		children={
			{class="Label", name="EPISODETITLE", x=17, y=21, wrapStyle="truncate", maxWidth=225, font="font_calendar_episode:calendar_scene", anchor="left", roundPos=false},

			{class="SpecialSwitch", name="DAY1", x=243, y=4, image="button_day_1:calendar_scene", group=42, hitMaskThreshold=0.9, reactWhenChecked=true},
			{class="SpecialSwitch", name="DAY2", x=310, y=4, image="button_day_2:calendar_scene", group=42, hitMaskThreshold=0.9, reactWhenChecked=true},
		}},
--		{class="Sprite", name="LOCKED",
--		children={
--			{class="Label", name="PLAYNEXTEPISODE", x=24, y=23, wrapStyle="word", maxWidth=250, font="font_calendar_next_episode_active:calendar_scene", anchor="left", align="center", roundPos=false},
--			
--			{class="Sprite", name="COINS", x=220, y=20, image="coins:shop_scene", anchor="center", frame=2, },
--			{class="Label", name="PRICE", x=298, y=22, font="FONT_DIALOG_HEADER:default", anchor="right", roundPos=false},
--			{class="Button", name="BUYNOW",x=300, y=7, image="deco_buy:shop_scene", hitMaskThreshold=0.9, reactWhenChecked=true},
--		}},
	},
}

blueprints.calendar_polaroid = {
	class="Sprite", image="calendar_polaroid:calendar_scene", anchor="center",
	children={
		{class="Sprite", x=-7, y=-22, name="DAYPREVIEW", anchor="center"},
	},
}

dialogs.yes_no = {
	class = "DialogYesNo",
	minWidth = 500, minHeight = 300,
	autoCenter = true,
	painter = blueprints.default_painter,
	components = {
		{ class="Label", name="HEADER", x=246, y=100, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Label", name="MESSAGE", x=250, y=143, maxWidth=340, anchor="top", align="center", wrapStyle="word", font="FONT_TEXT:default"},
		{ class="Button", name="BUTTON_YES", x=240, y=170, image="BUTTON_YES:default", anchor="topRight", setup=setups.btn},
		{ class="Button", name="BUTTON_NO", x=260, y=170, image="BUTTON_NO:default", anchor="topLeft", setup=setups.btn},
	},
}

dialogs.hint = {
	class = "DialogHint",
	name = "DIALOG_HINT",
	doDarkenBackground = false,
	autoCenter = false,
	minWidth = 424, minHeight = 200,
	lty1 = 158, lty2 = 168,
	painter = {
		class = "DialogPainter",
		section = "default",
		images = {
			"BORDER_HINT_TOP_LEFT", "BORDER_HINT_TOP_CENTER", "BORDER_HINT_TOP_RIGHT",
			"BORDER_HINT_CENTER_LEFT", "BORDER_HINT_CENTER", "BORDER_HINT_CENTER_RIGHT",
			"BORDER_HINT_BOTTOM_LEFT", "BORDER_HINT_BOTTOM_CENTER", "BORDER_HINT_BOTTOM_RIGHT",
		},
	},
	components = {
		{ class="Label", name="TIP_HEADER", x=212, y=65, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Label", name="TIP_TEXT", x=212, y=100, maxWidth=300, align="center", wrapStyle="word", anchor="top", lineHeight=18, font="FONT_TEXT:default"},
		{ class="Button", name="BUTTON_OK", x=212, y=105, image="balloon_ok:gamescene", anchor="top", setup=setups.btn},
	},
}

setups.visual_hint = 
{
	name = "DIALOG_VISUAL_HINT",
	autoCenter = false,
	components = {
		{ class="Sprite", name="background", x=0, y=0, image="vh_dialog:gui",
		children = {
			{ class="Sprite", name="content_holder", x=84, y=0,
				children = {
					{ class="Label", name="title", x=219, y=75, anchor="top", font="font_hint_dialog_header:default",},
					{ class="Sprite", name="content", x=219, y=150, anchor="center",
						children = {
							{ class="Label", name="content_label", anchor="center", align="center", wrapStyle="word", maxWidth=300, font="font_hint_dialog:default",},	
						}},
					{ class="Label", name="instruction", x=219, y=216, maxWidth=300, align="center", wrapStyle="word", anchor="center", font="font_hint_dialog:default",},
				},
			},
			{ class="Sprite", name="character", x=108, y=246, arrowLeftX=414, anchor="bottom", image="evelyn_new:gui",},
		},},
	},
}

dialogs.visual_hint = {
	class = "DialogVisualHint",
	setup = setups.visual_hint,
}
 dialogs.visual_hint_text = {
	class = "DialogVisualHintText",
	setup = setups.visual_hint,
}
dialogs.visual_hint_compound = {
	class = "DialogVisualHintCompound",
	setup = setups.visual_hint,
}

dialogs.help = {
	class="DialogHelp", name="DIALOG_HELP", autoCenter=true, width=1024, height=768, doDarkenBackground=false,
	components = {
		{ class="Sprite", name="BACK_1", x=0, y=0, image="HELP1:gamescene", },
		{ class="Sprite", name="BACK_2", x=0, y=0, image="HELP2:gamescene", alpha=0, },
		{ class="Button", name="BUTTON_PREV", x=166, y=640,image="BUTTON_PREV:gamescene", anchor="topRight", setup=setups.btn},
		{ class="Button", name="BUTTON_OK", x=512, y=660, image="BUTTON_OK:default", anchor="top", setup=setups.btn},
		{ class="Button", name="BUTTON_NEXT", x=854, y=640, image="BUTTON_NEXT:gamescene", anchor="topLeft", setup=setups.btn},
	},
}

dialogs.advert = {
	class="DelDialog", 
	background = _deluxe("background:advert", "background_premium:advert"),
	components = {
		{ class="Button", name="BUTTON_CONTINUE", x=603, y=714, image="button_buy:default", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_NOT_NOW", x=394, y=714, image="button_not_now:sceneselection", anchor="top", setup=setups.btn, },
	},
}

dialogs.facebook_like = {
	class="DelDialog", 
	background = "background_like_emily:advert",
	components = {
		{ class="Button", name="BUTTON_LIKE", x=528, y=475, image="facebook_button:sceneselection", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_CONTINUE", x=512, y=686, image="button_no_thanks:default", anchor="top", setup=setups.btn, },
	},
}

dialogs.player_select = {
	class="DialogPlayerSelect", minWidth=690, minHeight=630, autoCenter=true, painter=blueprints.default_painter,
	buttonSpacing = 50,
	nameButton = { class="Button", y=160, image="NAME_SELECT_BUTTON:default", anchor="top", setup=setups.btn, },
	nameLabel = { class="Label", y=12, anchor="top", font="FONT_TEXT:default", },
	components = {
		{ class="Sprite", x=88, y=121, image="PLAYER_SELECT_BACK:default", },
		{ class="Label", x=345, y=108, anchor="top", textId="PLAYER_SELECT", font="FONT_DIALOG_HEADER:default", },
		{ class="Sprite", name="BORDER", x=0, y=0, anchor="top", image="PLAYER_BORDER:default", },
		{ class="Button", name="BUTTON_ADD", x=180, y=503, image="BUTTON_ADD:default", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_REMOVE", x=345, y=503, image="BUTTON_REMOVE:default", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_OK", x=515, y=503, image="BUTTON_OK:default", anchor="top", setup=setups.btn, },
	},
}

dialogs.new_player = {
	class="DialogNameInput", minWidth=690, minHeight=630, autoCenter=true, painter=blueprints.default_painter,
	components = {
		{ class="Sprite", x=89, y=122, image="NAME_INPUT_BACK:default", },
		{ class="Label", x=345, y=107, anchor="top", textId="PLAYER_SELECT", font="FONT_DIALOG_HEADER:default", },
		{ class="LabelInput", name="INPUT_NAME", x=345, y=151, anchor="top", image="INPUTLABEL:default",
			cursorImage="CARET", cursorX=4, cursorY=-5, maxWidth=340,
			durationOn=500, durationOff=500,
			selectionColor=0x0099ee, borderColor=0x000044,
			label = { class="Label", x=0, y=13, anchor="top", font="FONT_TEXT:default", },
		},

		{ class="Label", x=345, y=237, anchor="top", textId="DIFFICULTY", font="FONT_DIALOG_HEADER:default", },
		{ class="Switch", name="D0", x=122, y=264, group=781, setup=setups.swtch, },
		{ class="Label", name="LABEL_D0", x=181, y=289, textId="EASY", font="FONT_DIALOG_HEADER", scale=0.70, },
		{ class="Switch", name="D1", x=271, y=264, group=781, setup=setups.swtch, },
		{ class="Label", name="LABEL_D1", x=325, y=289, textId="MEDIUM", font="FONT_DIALOG_HEADER", scale=0.70, },
		{ class="Switch", name="D2", x=425, y=264, group=781, setup=setups.swtch, },
		{ class="Label", name="LABEL_D2", x=485, y=289, textId="HARD", font="FONT_DIALOG_HEADER", scale=0.70, },

		{ class="Label", textId="AUDIO", x=345, y=359, anchor="top", font="FONT_DIALOG_HEADER:default"},
		{ class="Sprite", name="singing_birds_bush", x=347, y=406, image="singing_birds_bush:default", anchor="center"},
		{ class="Sprite", name="AUDIO_BIRDS", x=347, y=406, image="AUDIO_BIRDS:default", anchor="center"},
		{ class="Sprite", name="NOTE1", x=210, y=347, image="AUDIO_NOTE:default", anchor="center"},
		{ class="Sprite", name="NOTE2", x=229, y=347, image="AUDIO_NOTE2:default", anchor="center"},
		{ class="Sprite", name="NOTE3", x=440, y=353, image="AUDIO_NOTE:default", anchor="center"},
		{ class="Sprite", name="NOTE4", x=456, y=353, image="AUDIO_NOTE2:default", anchor="center"},
		{ class="Label", textId="TURN_ON_AUDIO", x=354, y=407, maxWidth=340, anchor="top", align="center", wrapStyle="word", font="FONT_TEXT:default"},

		{ class="Button", name="BUTTON_CANCEL", x=180, y=503, image="BUTTON_CANCEL:default", anchor="topLeft", setup=setups.btn, },
		{ class="Button", name="BUTTON_OK", x=488, y=502, image="BUTTON_OK:default", anchor="topRight", setup=setups.btn, },
	},
}

dialogs.settings = {
	class="DialogSettings", minWidth=690, minHeight=630, autoCenter=true, painter=blueprints.default_painter,
	components = {
		{ class="Sprite", x=89, y=122, image="SETTINGS_BACK:default", },
		{ class="Label", x=345, y=113, textId="CTEXT_SETTINGS_HEADER", anchor="top", font="FONT_DIALOG_HEADER:default", },

		{ class="Label", x=135, y=162, textId="CTEXT_SETTINGS_MUSIC", font="FONT_DIALOG_HEADER:default", scale=0.70, },
		{ class="Slider", name="SLIDER_MUSICVOL", x=220, y=167, image="SLIDER_BACK:default", minX=20, minY=14, maxX=337, maxY=14,
			button = { class="Button", y=-7, image="SLIDER_BUTTON:default", anchor="center", },
		},
		{ class="Sprite", name="YELLOW_BACK_1", image="SLIDER_BACK_FILLED:default", },

		{ class="Label", x=135, y=206, textId="CTEXT_SETTINGS_SOUND", font="FONT_DIALOG_HEADER:default", scale=0.70, },
		{ class="Slider", name="SLIDER_FXVOL", x=220, y=212, image="SLIDER_BACK:default", minX=20, minY=14, maxX=337, maxY=14,
			button = { class="Button", y=-7, image="SLIDER_BUTTON:default", anchor="center", },
		},
		{ class="Sprite", name="YELLOW_BACK_2", image="SLIDER_BACK_FILLED:default", },

		{ class="Switch", name="SWITCH_FULLSCREEN", x=120, y=234, image="CHECKBOX:default", setup=setups.swtch, visible=_iOS(false, true), },
		{ class="Label", name="LABEL_FULLSCREEN", x=185, y=257, textId="FULLSCREEN", font="FONT_DIALOG_HEADER:default", scale=0.70, visible=_iOS(false, true), },
		
		{ class="Switch", name="SWITCH_SHOWHINTS", x=120, y=_iOS(250, 284), image="CHECKBOX:default", setup=setups.swtch, },
		{ class="Label", name="LABEL_SHOWHINTS", x=185, y=_iOS(273, 307), textId="SHOW_HINTS", font="FONT_DIALOG_HEADER:default", scale=0.70, },

		{ class="Label", x=345, y=371, textId="DIFFICULTY", anchor="top", font="FONT_DIALOG_HEADER:default", },
		{ class="Switch", name="D0", x=122, y=400, group=783, setup=setups.swtch, },
		{ class="Label", name="LABEL_D0", x=181, y=425, textId="EASY", font="FONT_DIALOG_HEADER", scale=0.70, },
		{ class="Switch", name="D1", x=271, y=400, group=783, setup=setups.swtch, },
		{ class="Label", name="LABEL_D1", x=325, y=425, textId="MEDIUM", font="FONT_DIALOG_HEADER", scale=0.70, },
		{ class="Switch", name="D2", x=425, y=400, group=783, setup=setups.swtch, },
		{ class="Label", name="LABEL_D2", x=485, y=425, textId="HARD", font="FONT_DIALOG_HEADER", scale=0.70, },

		{ class="Button", name="BUTTON_CREDITS", x=258, y=502, image="BUTTON_CREDITS:default", anchor="topRight", setup=setups.btn, },
		{ class="Button", name="BUTTON_OK", x=354, y=502, image="BUTTON_OK:default", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_CANCEL",	x=460, y=502, image="BUTTON_CANCEL:default", setup=setups.btn, },
	},
}

dialogs.credits = {
	class="DialogCredits", name="credits", doDarkenBackground=false,
	background="background_credits_dialog:credits",
	clipHeight=250, clipY=60,
	startDelay=2000, endDelay=2000, scrollDuration=60000,
	startSpacing=100,
	preNameSpacing=28,
	nameSpacing=32,
	postNameSpacing=60,
	postHeadSpacing=60,
	noClickDelay=4000,
	labelsX=512,
	allDoneLabelsX=(1024 / 4) * 3,
	headerColor = 0xff0000,
	allDoneHeaderColor = 0xffbb00,
	nameColor = 0x000000,
	allDoneNameColor = 0xffffff,
	labelMaxWidth=(1024-680)*2,
	slope=0,
	components = {
		{ class="Sprite", name="BACK" },
		{ class="Sprite", name="LABELS", y=768/4,
			children={
				{ class="Sprite", name="LOGO", x=512, y=0, anchor="center", image="delicious_logo_credits:credits", },
			},
		},
		{ class="Label", name="VERSION", x=336, y=366, },
	},
}

dialogs.ingame_menu = {
	class="DialogMenu", name="ingame_menu", autoCenter=true, minWidth=320, minHeight=535, painter=blueprints.default_painter,
	components = {
		{ class="Label", x=162, y=96, anchor="top", textId="CTEXT_MAKE_CHOICE", font="FONT_DIALOG_HEADER:default"},
		{ class="Button", name="BUTTON_SETTINGS", x=160, y=150, image="MENU_SETTINGS:gamescene", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_HELP", x=160, y=210, image="MENU_HELP:gamescene", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_CALENDAR", x=160, y=270, image="MENU_CALENDAR:gamescene", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_RETRY", x=160, y=330, image="button_restart_day:gamescene", anchor="top", setup=setups.btn},
--'		{ class="Button", name="BUTTON_MENU", x=160, y=330, image="BUTTON_EXIT:sceneselection", anchor="top", setup=setups.btn, },
		{ class="Button", name="BUTTON_RESUME", x=160, y=390, image="MENU_RESUME:gamescene", anchor="top", setup=setups.btn, },
	},
}

dialogs.premium_menu = {
	class="DialogPremium", name="premium_menu", width=1024, height=768, doDarkenBackground=false, background="BACKGROUND:prem",
	children = {
		{ class="GameNode", name="INFO", 
			children= 
			{
				{ class="GameNode", visible=false, name="bonus_days", --'BUTTON_10_BONUS_DAYS
					children= { 
						{ class="Sprite", name="BG", x=204, y=101, image="10_bonus_days:prem", },		
						{ class="Sprite", name="BG_SPARKLES", x=204, y=101, image="10_bonus_days_sparkles:prem", },		
						{ class="Sprite", x=281, y=152, image="10_complete_bonus_days:prem", },
						{ class="Sprite", x=647, y=152, image="new_events:prem", },
						{ class="Sprite", x=277, y=395, image="new_story:prem", },
						{ class="Sprite", x=650, y=395, image="play_as_francois:prem", },
								
						{ class="Sprite", name="FRAME", x=0, y=0, image=_deluxe("extras_frame:prem", "premium_frame:prem"), },
						{ class="Label", x=604, y=87, anchor="top", textId="TEXT_PREMIUM_MENU_10_BONUS_DAYS", font="FONT_FLOATERS", color0=0xffffff, color1=0x8b2110, scaleX=1, scaleY=0.75, },

						{ class="Sprite", name="STAR", x=594, y=660, image="play_star:prem", anchor="center", frameTime=100, },		
						{ class="Button", name="BUTTON_PLAY_BONUS", x=594, y=660, image="button_play:prem", anchor="center", setup=setups.btn, },
					},
				},
				{ class="GameNode", visible=false, name="bonus_items", --'BUTTON_10_BONUS_ITEMS
					children= {
						{ class="Sprite", name="BG", x=204, y=101, image="10_bonus_shop_items:prem", },				
						{ class="Sprite", name="FRAME", x=0, y=0, image=_deluxe("extras_frame:prem", "premium_frame:prem"), },
						{ class="Label", x=604, y=87, anchor="top", textId="TEXT_PREMIUM_MENU_10_BONUS_ITEMS", font="FONT_FLOATERS", color0=0xffffff, color1=0x8b2110, scaleX=1, scaleY=0.75, },
					},
				},
				{ class="GameNode", visible=false, name="guide", --'BUTTON_GUIDE
					children= {
						{ class="Sprite", name="BG", x=204, y=101, image="strategy_guide:prem", },	
						{ class="Sprite", name="BG_SPARKLES", x=204, y=101, image="strategy_guide_sparkles:prem", },							
						{ class="Sprite", name="FRAME", x=0, y=0, image=_deluxe("extras_frame:prem", "premium_frame:prem"), },
						{ class="Label", x=604, y=87, anchor="top", textId="TEXT_PREMIUM_MENU_GUIDE", font="FONT_FLOATERS", color0=0xffffff, color1=0x8b2110, scaleX=1, scaleY=0.75, },
						{ class="Button", name="BUTTON_GUIDE_OPEN", x=594, y=660, image="button_open:prem", anchor="center", setup=setups.btn, },
					},
				},
				{ class="GameNode", visible=false, name="screen", --'BUTTON_SCREEN
					children= {
						{ class="Sprite", name="BG", x=204, y=101, image="screensaver:prem", },	
						{ class="Sprite", name="BG_MONITOR", x=204, y=101, image="screensaver_monitor:prem", },	
						{ class="Sprite", name="BG_SPARKLES", x=204, y=101, image="screensaver_sparkles:prem", },	
									
						{ class="Sprite", name="FRAME", x=0, y=0, image=_deluxe("extras_frame:prem", "premium_frame:prem"), },
						{ class="Label", x=604, y=87, anchor="top", textId="TEXT_PREMIUM_MENU_SCREEN", font="FONT_FLOATERS", color0=0xffffff, color1=0x8b2110, scaleX=1, scaleY=0.75, },						
						{ class="Button", name="BUTTON_SCREEN_INSTALL", x=594, y=660, image="button_install:prem", anchor="center", setup=setups.btn, },
					},
				},
				{ class="GameNode", visible=false, name="wallpapers", --'BUTTON_WALLPAPER
					children= {
						{ class="Sprite", name="BG", x=204, y=101, image="wallpapers:prem", },				
						{ class="Sprite", name="BG_SPARKLES", x=204, y=101, image="wallpapers_sparkles:prem", },				
						
						{ class="Sprite", name="FRAME", x=0, y=0, image=_deluxe("extras_frame:prem", "premium_frame:prem"), },
						{ class="Label", x=604, y=87, anchor="top", textId="TEXT_PREMIUM_MENU_WALLPAPER", font="FONT_FLOATERS", color0=0xffffff, color1=0x8b2110, scaleX=1, scaleY=0.75, },						
						{ class="Button", name="BUTTON_WALL1_INSTALL", x=378, y=383, image="button_install:prem", anchor="center", setup=setups.btn, },
						{ class="Button", name="BUTTON_WALL2_INSTALL", x=797, y=383, image="button_install:prem", anchor="center", setup=setups.btn, },
						{ class="Button", name="BUTTON_WALL3_INSTALL", x=583, y=589, image="button_install:prem", anchor="center", setup=setups.btn, },
					},
				},
			},
		},
		
		{ class="Switch", name="BUTTON_10_BONUS_DAYS", x=15, y=210, image="CHECKBOX:default", group=1, setup=setups.swtch, layoutId="bonus_days"},
		{ class="Label", name="LABEL_10_BONUS_DAYS", x=75, y=242, wrapStyle="word", maxWidth=180, font="FONT_DIALOG_HEADER", scale=0.70, textId="TEXT_PREMIUM_MENU_10_BONUS_DAYS_BUTTON", anchor="left", },

		{ class="Switch", name="BUTTON_10_BONUS_ITEMS", x=15, y=276, image="CHECKBOX:default", group=1, setup=setups.swtch, layoutId="bonus_items", },
		{ class="Label", name="LABEL_10_BONUS_ITEMS", x=75, y=308, wrapStyle="word", maxWidth=180, font="FONT_DIALOG_HEADER", scale=0.70, textId="TEXT_PREMIUM_MENU_10_BONUS_ITEMS", anchor="left", },
		
		{ class="Switch", name="BUTTON_GUIDE", x=15, y=342, group=1, image="CHECKBOX:default", setup=setups.swtch, layoutId="guide", },
		{ class="Label", name="LABEL_GUIDE", x=75, y=374, wrapStyle="word", maxWidth=180, font="FONT_DIALOG_HEADER", scale=0.70, textId="TEXT_PREMIUM_MENU_GUIDE", anchor="left", },

		{ class="Switch", name="BUTTON_WALLPAPER", x=15, y=408, group=1, image="CHECKBOX:default", setup=setups.swtch, layoutId="wallpapers", checked=true, },
		{ class="Label", name="LABEL_WALLPAPER", x=75, y=440, wrapStyle="word", maxWidth=180, font="FONT_DIALOG_HEADER", scale=0.70, textId="TEXT_PREMIUM_MENU_WALLPAPER", anchor="left", },

		{ class="Switch", name="BUTTON_SCREEN", x=15, y=474, group=1, image="CHECKBOX:default", setup=setups.swtch, layoutId="screen", },
		{ class="Label", name="LABEL_SCREEN", x=75, y=506, wrapStyle="word", maxWidth=180, font="FONT_DIALOG_HEADER", scale=0.70, textId="TEXT_PREMIUM_MENU_SCREEN", anchor="left", },

		{ class="Button", name="BUTTON_BACK", x=82, y=714, image="BUTTON_BACK:default", anchor="top", setup=setups.btn, },
	},
}

dialogs.episode = {
	class="EpisodeDialog", autoCenter=true, width=1024, height=768, dialogDuration=3300, trailDuration=1500,
	components = {
		{ class="Sprite", name="back", image="envelope:gamescene", anchor="top", x=512, y=180, },
		{ class="Sprite", name="end", image="the_end_of:gamescene", anchor="top", x=512, y=240, },
		{ class="Sprite", name="episode", image="day:gamescene", anchor="top", x=512, y=290, },
		{ class="Sprite", name="number", image="episode_numbers:gamescene", y=296, },
		{ class="Sprite", name="title", anchor="top", x=512, y=350, },
	},
}

dialogs.story_shift_start = {
	class="DialogShiftStart", autoCenter=true, width=1024, height=768,
	components = {
		{ class="Sprite", name="back", image="shift_starts:gamescene", anchor="center", x=512, y=330, },
		{ class="Sprite", name="level_starts", image="shift_starts_text:gamescene", anchor="center", x=512, y=330, },
--'		{ class="Sprite", name="text_back", image="day_dialog:gamescene", anchor="center", x=512, y=354,},
--'		{ class="Label", name="text_day", font="font_day_dialog:default", anchor="center", x=512, y=289,},
	},
}

dialogs.story_shift_close = {
	class="DialogShiftClose", autoCenter=true, width=1024, height=768, modal=false,
	components = {
		{ class="Sprite", name="back", image="shift_closed:gamescene", anchor="center", x=512, y=340, },
		{ class="Sprite", name="level_closed", image="day_ends:gamescene", anchor="center", x=512, y=340, },
	},
}

dialogs.challenge_shift_start = {
	class="DialogShiftStart", autoCenter=true, width=1024, height=768,
	components = {
		{ class="Sprite", name="back", image="challenge_begin_number_dialog:gamescene", anchor="center", x=512, y=340, },
		{ class="Sprite", name="level_starts", image="challenge:gamescene", anchor="center", x=512, y=262, },
		{ class="Label", name="text_challenge_level", font="font_score_challenge_number:default", anchor="center", x=512, y=350, },

		{ class="Sprite", name="text_back", image="day_dialog_2:gamescene", anchor="center", x=512, y=448, },
		{ class="Label", name="text_day", font="font_day_dialog:default", anchor="center", },
	},
}

dialogs.challenge_shift_close = {
	class="DialogShiftClose", autoCenter=true, width=1024, height=768, modal=false,
	components = {
		{ class="Sprite", name="back", image="challenge_begin_number_dialog:gamescene", anchor="center", x=512, y=340, },
		{ class="Sprite", name="level_closed", image="challenge:gamescene", anchor="center", x=512, y=262, },
		{ class="Label", name="text_challenge_level", font="font_score_challenge_number:default", anchor="center", x=512, y=350, },

		{ class="Sprite", name="text_back", image="day_dialog_2:gamescene", anchor="center", x=512, y=448, },
		{ class="Label", name="text_day", font="font_day_dialog:default", anchor="center", },
	},
}

dialogs.upsell_menu = {
	class="DialogUpsell", name="upsell_menu", width=1024, height=768, doDarkenBackground=false, background="upsell_background:upsell",
	children = {
		{ class="SpriteExt", name="UPSELL_D5", x=188, y=364, baseAnimation="upsell_del5:upsell", anchor="center", hitMaskThreshold=0.1},
		{ class="SpriteExt", name="UPSELL_D6", x=511, y=364, baseAnimation="upsell_del6:upsell", anchor="center", hitMaskThreshold=0.1},
		{ class="SpriteExt", name="UPSELL_HM", x=835, y=364, baseAnimation="upsell_heartsmedicine:upsell", anchor="center", hitMaskThreshold=0.1},

		{ class="Button", name="BUTTON_TRY_D5", x=253, y=648, image="BUTTON_TRY_NOW_FOR_FREE:upsell", anchor="center", setup=setups.btn, },
		{ class="Button", name="BUTTON_TRY_D6", x=505, y=648, image="BUTTON_TRY_NOW_FOR_FREE:upsell", anchor="center", setup=setups.btn, },
		{ class="Button", name="BUTTON_TRY_HM", x=778, y=648, image="BUTTON_TRY_NOW_FOR_FREE:upsell", anchor="center", setup=setups.btn, },

		{ class="Button", name="BUTTON_BACK", x=509, y=714, image="button_no_thanks:default", setup=setups.btn, anchor="top", },
	},
}

--'dialogs.shop_sell_dialog = {
--'	class="SellDialog", autoCenter=true, background="deco_buyitem_dialog:shop_scene",
--'	components = {
--'		{ class="Label", name="header", anchor="center", x=445, y=52, textId="SHOP_BUY_ITEM", font="FONT_DIALOG_TEXT:default", },
--'		{ class="Sprite", name="arrow", anchor="center", x=445, y=250, image="deco_sell_arrow:shop_scene"},
--'		{ class="Sprite", name="old_item", anchor="right", x=445-20, y=250, },
--'		{ class="Sprite", name="new_item", anchor="left", x=445+20, y=250, },
--'		--'{ class="Sprite", image="deco_value_love:shop_scene", anchor="top", x=91, y=486, },
--'		--'{ class="Sprite", image="deco_value_green:shop_scene", anchor="top", x=187, y=486, },
--'		--'{ class="Sprite", image="deco_value_empty:shop_scene", anchor="top", x=249, y=582, },
--'		--'{ class="Button", name="give", image="deco_give:shop_scene", anchor="top", x=91, y=448, },
--'		--'{ class="Button", name="recycle", image="deco_recycle:shop_scene", anchor="top", x=187, y=448, },
--'		--'{ class="Button", name="sell", image="deco_sell:shop_scene", anchor="top", x=248, y=594, },
--'		--'{ class="Label", name="price", font="FONT_DIALOG_TEXT:default", anchor="top", x=249, y=596, },
--'		{ class="Button", name="sell_ok", image="deco_ok:shop_scene", anchor="top", x=445-50, y=544, },
--'		{ class="Button", name="sell_cancel", image="deco_cancel:shop_scene", anchor="top", x=445+50, y=544, },
--'	},
--'}
