--' ************************************ Player ************************************ '--
Player = getClass("Player")

function Player:getChallengeLevels()
	if (not self.challengeLevels) then
		self.challengeLevels = {}
		local shifts = ghf.getShiftFiles("room"..self.room, "script/challenge/levels/");
		for _,v in ipairs(shifts) do
			table.push_back(self.challengeLevels, {shift=v, weight=1000})
		end
	end
	return self.challengeLevels
end

function Player:getChallengeEventsLevels()
	if (not self.challengeEventLevels) then
		self.challengeEventLevels = {}
		local shifts = ghf.getShiftFiles("room"..self.room, "script/challenge/events/");
		for _,v in ipairs(shifts) do
			table.push_back(self.challengeEventLevels, {shift=v, weight=1000})
		end
	end
	return self.challengeEventLevels
end

function math.getRandomItemFromWeightedList(list, reditribute)
	local totalWeight = 0
	for _,v in ipairs(list) do
		totalWeight = totalWeight + v.weight
	end

	local selectedWeight = math.Random(totalWeight)
	if (selectedWeight < 1) then
		error("selectedWeight = "..tostring(selectedWeight).." totalWeight = "..tostring(totalWeight))
	end
	assert(selectedWeight <= totalWeight)

	local chosen
	for _,v in ipairs(list) do
		selectedWeight = selectedWeight - v.weight
		if (selectedWeight <= 0) then
			chosen = v
			break
		end
	end

	if (chosen and reditribute) then
		local num = #list - 1
		if (num > 0) then
			num = chosen.weight / num
			for _,v in ipairs(list) do
				if (v ~= chosen) then v.weight = v.weight + num end
			end
		end
		chosen.weight = 0
	end
	return chosen
end

function Player:setNextChallenge()
	local levels = self:getChallengeLevels()
	local choice = math.getRandomItemFromWeightedList(levels, true)
	self.challengeLevelFile = choice.shift

	local addEvent = (not self.nextChallengeEventLevel or self.nextChallengeEventLevel <= 0)
	if (addEvent) then
		player:initNextChallengeEventCounter()
		local eventLevels = self:getChallengeEventsLevels()
		local eventChoice = math.getRandomItemFromWeightedList(eventLevels, true)
		self.challengeEventFile = eventChoice and eventChoice.shift or ""
	else
		self.nextChallengeEventLevel = self.nextChallengeEventLevel - 1
		self.challengeEventFile = ""
	end
end

function Player:initNextChallengeEventCounter()
	self.nextChallengeEventLevel = math.Random(minChallengeLevelsBetweenEvents, maxChallengeLevelsBetweenEvents)
end

--' ************************************ DelPlayer ************************************ '--
DelPlayer = getClass("DelPlayer")
