--' ************************************ Memory Task ************************************ '--
LoveMomentTask = deriveLuaClass("LoveMomentTask", "LuaTask")
function LoveMomentTask:start()
	assert(self.momentImage)
	assert(self.momentPosition)
	
	level:showClickToContinue(1500)

	self.moment = scene:newChild({
		class = "LoveMoment",
		momentImage = self.momentImage,
		momentPosition = self.momentPosition,
	})
	
	return self.moment ~= nil
end

function LoveMomentTask:update(time)
	return 
		not self.moment or
		self.moment.__deleted
end

function LoveMomentTask:skip()
	if (isTable(self.moment) and self.moment.remove and not self.moment.__deleted) then
		self.moment:hideMoment(true)
	end
end

function LoveMomentTask:click()
	self.moment:hideMoment(false)
	return true
end
