--' ************************************ Level ************************************ '--
Level = getClass("Level")

function Level:fireTrigger(trigger, data1, data2, data3, data4)
	local handled = false
	if (not handled and self.event) then
		handled = self.event:handleTrigger(trigger, data1, data2, data3, data4)
	end
	if (not handled) then
		handled = taskSystem:handleTrigger(trigger, data1, data2, data3, data4)
	end
	if (not handled) then
		handled = self:handleTrigger(trigger, data1, data2, data3, data4)
	end
	return handled
end

function Level:onRemoveProductFromTray(product)
	local handled, halt
	if (product and product.source and product.source.onRemoveProductFromTray) then
		 --' *** pb("["..self.name.."] onRemoveProductFromTray: calling remove product from tray for "..product.name)
		handled, halt = product.source:onRemoveProductFromTray(product)
		if (halt) then return handled end
	end
	if (self.event and self.event.onRemoveProductFromTray) then
		 --' *** pb("["..self.name.."] onRemoveProductFromTray for event: "..self.event.name)
		handled, halt = self.event:onRemoveProductFromTray(product)
		if (halt) then return handled end
	end
	return handled
end

function Level:onWorkStart(task)
	return false
end

function Level:onWorkFinish(task)
end

function Level:onAnimationStarted(anim)
	local musicMoodStart = musicMoodString(anim.musicMoodStart)
	anim.musicMoodEnd_original = self.musicMood
	if (isCallable(self.setMusicAndMood) and musicMoodStart) then
		print("musicMoodStart: ".. musicMoodStart)
		self:setMusicAndMood({mood=musicMoodStart, quickFade=true})
	end

	if (self.selectedObject) then
		self.wasSelected = self.selectedObject.selected
		self.selectedObject.selected = false
	end
end

function Level:onAnimationFinished(anim)
	local musicMoodEnd = musicMoodString(anim.musicMoodEnd)
	if (not musicMoodEnd) then
		musicMoodEnd = anim.musicMoodEnd_original
	end
	if (isCallable(self.setMusicAndMood)) then
		self:setMusicAndMood({mood=musicMoodEnd, quickFade=true})
	end

	if (self.selectedObject) then
		self.selectedObject.selected = self.wasSelected
	end

	anim.resetEmotionsOnFinish = anim.resetEmotionsOnFinish or "default"
	if (anim.resetEmotionsOnFinish ~= "none") then
		local actors = { hero, cleaner, entertainer }
		if (anim.resetEmotionsOnFinish == "all") then
			actors = anim:getActors()
		elseif (anim.resetEmotionsOnFinish ~= "default") then
			actors = {level:getSpriteExt(anim.resetEmotionsOnFinish)}
		end
		for _,v in ipairs(actors) do
			if (v) then
				local emo = v.emotion
				if (isString(emo) and emo ~= "") then
					v.emotion = ""
				end
			end
		end
	end
end

function Level:resolveValue(v)
	if (v == "hero") then return hero end
	return nil
end

function Level:getDifficultyValue(t)
	return getInterpolatedEmbedValue(t, player.difficultyFrac, player.metaDifficultyFrac)
end

function getInterpolatedEmbedValue(t, frac, ...)
	if (isNumber(t)) then
		return t
	end
	assert(isTable(t))
	local min, max
	for k,_ in pairs(t) do
		assert(isNumber(k))
		if (min == nil or k < min) then min = k end
		if (max == nil or k > max) then max = k end
	end
	assert(isNumber(min))
	assert(isNumber(max))
	frac = (isNumber(frac) and frac) or 0
	local index = min + (max - min) * frac
	local v = t[index]
	if (v) then
		return getInterpolatedEmbedValue(v, unpack(arg))
	end
	local lo, hi
	for k,v in pairs(t) do
		if (lo == nil or (k < lo and k > index)) then lo = k end
		if (hi == nil or (k < hi and k > index)) then hi = k end
	end
	local vLo = getInterpolatedEmbedValue(t[lo], unpack(arg))
	local vHi = getInterpolatedEmbedValue(t[hi], unpack(arg))

--'print("index: " .. index)
--'print("vLo: " .. vLo)
--'print("vHi: " .. vHi)

	return math.lerp(math.inv_lerp(index, lo, hi), vLo, vHi)
end

function getInterpolatedValue(t, frac)
	if (isNumber(t)) then
		return t
	end
	assert(isTable(t))
	-- for now only support 2 value's
	assert(#t == 2)
	return math.lerp(frac, t[1], t[2])
end

--' ************************************ Game Level ************************************ '--
DelLevel = getClass("DelLevel")

function DelLevel:init(desc)
	DelLevel.superInit(self, desc)

	self.closeDelay = self.closeDelay or 4000
	self.maxTableGroupSize = self.maxTableGroupSize or 0
	self:mergeProducts()
	self:updateProductSettings()
 	self:startGame(desc)

	self.placeChances = self.placeChances or { table = 50, counter = 50 }
end

function DelLevel:onLevelInitialized()
	self:traverse(function(_, node)
		if (node.onLevelInitialized and node ~= self) then
			node:onLevelInitialized()
		end
	end)
    self:onInitialized()

    if (hero) then
		hero.doWalkToLock = true
		hero.positionLock = hero.location
	end
    if (entertainer) then
		entertainer.doWalkToLock = true
		entertainer.positionLock = entertainer.location
	end
    if (cleaner) then
		cleaner.doWalkToLock = true
		cleaner.positionLock = cleaner.location
	end
end

function DelLevel:getNumTimedProductOrdered(productName)
	local groups = self.customerGroups
	print("DelLevel:hasOrderWithProduct(productName)")
	local numTimesOrdered = 0
	for _,v in ipairs(groups) do
		if (v.order) then
			numTimesOrdered = numTimesOrdered + v.order:getProductCount(productName)
		end
	end
	return numTimesOrdered
end

function DelLevel:onArrowRemoved(arrowId, object)
	if (arrowId == "Entertainer") then
		assert(object)
		assert(object.hintTable)
		hintManager:placeArrow({hintId="EntertainTable", parent=object.hintTable})
		switchHintArrowClick(object.hintTable, "EntertainTable")
	elseif (arrowId == "CompoundOrdered") then
		if (object.nextObject) then
			doCompoundArrow("compound_ordered_2", object.nextObject)
		end
	elseif (arrowId == "compound_ordered_2") then
		if (object.nextObject) then
			doCompoundArrow("compound_ordered_3", object.nextObject)
		end
	elseif (arrowId == "compound_ordered_3") then
		if (object.nextObject) then
			doCompoundArrow("compound_ordered_4", object.nextObject)
		end
	elseif (arrowId == "compound_ordered_4") then
		if (object.nextObject) then
			doCompoundArrow("compound_ordered_5", object.nextObject)
		end
	elseif (arrowId == "PaprikaReady") then
		if (object.nextObject) then
			doCompoundArrow("paprika_1", object.nextObject)
		end
	elseif (arrowId == "rice_1") then
		if (object.nextObject) then
			doCompoundArrow("rice_2", object.nextObject)
		end
	elseif (arrowId == "clean_rubbish") then
		if (object.nextObject) then
			hintManager:placeArrow({hintId="clean_rubbish_bin", parent=object.nextObject})
		end
--'	elseif (arrowId == "blenderIce") then
--'		player:removeNeverShowHint("blenderFruitDoneIce")
--'	elseif (arrowId == "blenderGlass") then
--'		player:removeNeverShowHint("blenderFruitDoneGlass")
--'	elseif (arrowId == "blenderFruitDoneIce") then
--'		if (object.nextObject) then
--'			doCompoundArrow("Ice", object.nextObject)
--'		end
--'	elseif (arrowId == "blenderFruitDoneGlass") then
--'		if (object.nextObject) then
--'			doCompoundArrow("Glass", object.nextObject)
--'		end
	elseif (arrowId == "blenderFruitDone") then
		if (object.nextObject) then
			doCompoundArrow("blenderCompound", object.nextObject)
		end

	elseif (arrowId == "FruitBasket") then
		if (object.nextObject) then
			doCompoundArrow("fruit_for_basket_1", object.nextObject, "right")
		end
	elseif (arrowId == "fruit_for_basket_1") then
		if (object.nextObject) then
			doCompoundArrow("fruit_for_basket_2", object.nextObject, "right")
		end
	elseif (arrowId == "fruit_for_basket_2") then
		if (object.nextObject) then
			doCompoundArrow("fruit_for_basket_3", object.nextObject, "right")
		end

	elseif (arrowId == "Lasagna") then
		if (object.nextObject1) then
			doCompoundArrow("lasagna_layer_2", object.nextObject1)
		end
	elseif (arrowId == "lasagna_layer_2") then
		if (object.nextObject) then
			doCompoundArrow("lasagna_layer_3", object.nextObject)
		end
	elseif (arrowId == "lasagna_layer_3") then
		if (object.nextObject2) then
			doCompoundArrow("lasagna_layer_4", object.nextObject2)
		end
	elseif (arrowId == "lasagna_layer_4") then
		if (object.nextObject) then
			doCompoundArrow("lasagna_layer_5", object.nextObject)
		end
	elseif (arrowId == "lasagna_layer_5") then
		if (object.nextObject3) then
			doCompoundArrow("lasagna_layer_6", object.nextObject3)
		end

--'	elseif (arrowId == "Lobster_drawer") then
--'		if (object.nextObject) then
--'			local arrowId = "Lobster"
--'			hintManager:placeArrow({hintId=arrowId, x=object.nextObject.screenCenter.x, y=object.nextObject.screenY + object.nextObject.height/2, parent=level.dragLayer})
--'			switchHintArrowClick(object.nextObject, arrowId)
--'		end
--'	elseif (arrowId == "Crab_drawer") then
--'		if (object.nextObject) then
--'			local arrowId = "Crab"
--'			hintManager:placeArrow({hintId=arrowId, x=object.nextObject.screenCenter.x, y=object.nextObject.screenY + object.nextObject.height/2, parent=level.dragLayer})
--'			switchHintArrowClick(object.nextObject, arrowId)
--'		end
	end
end

function doCompoundArrow(arrowId, object, arrowType)
	assert(object)
	hintManager:placeArrow({hintId=arrowId, x=object.x + object.width/2, y=object.y + object.height/2, parent=level.dragLayer, type=arrowType})
	switchHintArrowClick(object, arrowId)
end

function DelLevel:onHintClosed(hintId, object)
	if (hintId == "SendEntertainer") then
		if (entertainer) then
			hintManager:placeArrow({
				hintId="Entertainer",
				parent=level.dragLayer,
				x = entertainer.x,
				y = entertainer.y - entertainer.height,
			})
			entertainer.hintTable = object
			switchHintArrowClick(entertainer, "Entertainer")
		end

	elseif (hintId == "PatatasReady") then
		local object = level:getSpriteExt("redsauce")
		if (object) then
			hintManager:placeArrow({
				hintId="Redsauce",
				parent=level.dragLayer,
				x = object.x + (object.width / 2.0),
				y = object.y,
			})
			switchHintArrowClick(object, "Redsauce")
		end

--'	elseif (hintId == "PupNotHere") then
--'		hintManager:openHint({hintId="KeepSearching", showButton=false, closeOnClickAnywhere=true})

--'	elseif (hintId == "AllDecorations") then
--'		for i=1,4 do
--'			hintManager:removeArrows("AllDecorationsArrow"..i)
--'		end

--'	elseif (hintId == "AngelaSadBar") then
--'		local evelyn = level:getCharacter("evelyn")
--'		hintManager:openHint({hintId="DoLittleDance", showButton=false, subject=evelyn, target=evelyn})

--'	elseif (hintId == "CupOverflowGlass") then
--'		local object = level:getSpriteExt("glass")
--'		if (object) then
--'			hintManager:placeArrow({
--'				hintId="glass",
--'				parent=level.dragLayer,
--'				x = object.x + (object.width / 2.0),
--'				y = object.y,
--'			})
--'			switchHintArrowClick(object, "glass")
--'
--'			object = level:getSpriteExt("vanillaice")
--'			switchHintArrowClick(object, "glass")
--'		end
	end
end

function DelLevel:getIngredientButton(ingredientName)
	return self.gameLayer:traverse(function(_, node)
		if (node.ingredientName == ingredientName) then
			return node
		end
	end)
end

function DelLevel:mergeProducts()
	if (self.productSettings) then
		for k, v in pairs(self.productSettings) do
			local productInfo = table.copy(self.defaultPoductSettings, true)
			table.copy_into(productInfo, v, true)
			self.productSettings[k] = productInfo
		end
	end
end

function DelLevel:onDeliver(order, productsDelivered, owner)
	 --' *** pr("["..ts(owner.name).."] Receiving order:")
	 --' *** pi()
	for _,v in ipairs(productsDelivered) do
		 --' *** pb("Received "..v)
	end
	local orderedProducts = order.currentStep.productNames
	local deliveredProducts = order.currentStep.deliveredProductNames
	for _,v in ipairs(orderedProducts) do
		if (not table.contains(deliveredProducts, v)) then
			 --' *** pb("Did not yet receive "..v)
		end
	end
	 --' *** pd()

	if (event and event.onDeliver) then
		local n = event:onDeliver(order, owner)
		if (n) then return n end
	end
end

function DelLevel:onOrderCompleted(order, owner)
	 --' *** pi("["..ts(owner.name).."] On Order Completed")
	--' Check for paper order delivery
--'	local products = order.currentStep.deliveredProductNames
--'	local paperPos = owner.table and owner.table.paperPosition or nil
--'	if (self.paperStep and paperPos) then
--'		local wasPaperOrder = true
--'		for i=1,#self.paperStep do
--'			if (products[i] ~= self.paperStep[i]) then --' Order might get shuffled?
--'				wasPaperOrder = false
--'				break
--'			end
--'		end
--'		if (wasPaperOrder) then
--'			 --' *** pi("["..ts(owner.name).."] Order was paper order")
--'			local tipScore = owner:calculateTipScore("paperTip")
--'			if (tipScore > 0) then
--'				owner:tipPlayer(tipScore)
--'				 --' *** pb("["..ts(owner.name).."] Tipped you "..tipScore.." for the paper")
--'			end
--'			if (owner.mood < 3) then
--'				owner.mood = 3
--'			end
--'			 --' *** pd()
--'		end
--'	end
--'	 --' *** pd()
end

function DelLevel:onCustomerGroupStepDone(orderStep, group)
	local stepProducts = orderStep.deliveredProductNames

	if (isBeta) then
		--'print("["..ts(group.name).."] Done with step:")
		 --' *** pi()
		for _,v in ipairs(stepProducts) do
			 --' *** pb(v)
		end
		 --' *** pd()
	end

	--' Leave paper after done readin
--'	if (self.paperStep) then
--'		--' Check if the current order matches paperStep
--'		local wasPaperOrder = true
--'		for i=1,#self.paperStep do
--'			if (stepProducts[i] ~= self.paperStep[i]) then
--'				wasPaperOrder = false
--'				break
--'			end
--'		end
--'		if (wasPaperOrder) then
--'		--'print("Please leave that paper here!")
--'			local tbl = group.table
--'			if (not tbl.paper) then
--'				tbl.paper = tbl:newChild({
--'					class="IngredientButton",
--'					name="Paper that was left",
--'					location=tbl.paperPosition or {0,0},
--'					anchor="center",
--'					baseAnimation="button"..self.paperStep[1],
--'					section=self.resourceSection,
--'					workPos=tbl.workPos,
--'					deactivateOnWorkFinish=true,
--'					removeTrayHandler=self.paperHandler,
--'				})
--'				tbl.paper.floor = -tbl.paper.height
--'			end
--'			tbl.paper.state = "available"
--'		end
--'	end
end

function DelLevel:resolveValue(v)
	if (v == "cleaner") then return cleaner end
	if (v == "entertainer") then return entertainer end
	return DelLevel.super.resolveValue(self, v)
end

function DelLevel:createCharacter(desc)
	local classDesc = table.copy(self.characterTypes.default, true)
	local base = self.characterTypes[desc.base]
	table.copy_into(classDesc, base, true)
	table.copy_into(classDesc, desc, true)
--'if (classDesc.location) then
--'	print(classDesc.location)
--'	print("location x:" .. classDesc.location.x)
--'	print("location y:" .. classDesc.location.y)
--'end
	local character = self:add(classDesc)
	if (character.onCreated) then
		character:onCreated()
	end
	return character
end

function DelLevel:spawnCustomerGroup(meta, playSound)
	--' Build a class to spawn a customer
	--' The properties of the character can be defined in 3 places with increasing priority
	--' * classDesc (defaults)
	--' * self.customerList (overwrites defaults)
	--' * trigger metaData (overwrites defaults and self)

	--' Determine room
	local room = nil
	if (isNumber(self.areaId)) then
		room = self:getRoom(self.areaId)
	end

	--' Determine entrance
	local entrance = {x=512, y=300}
	local entrances = room and room.entrances
	if (entrances) then
		assert(#entrances > 0, "The room has no entrances!")
		entrance = entrances[math.Random(#entrances)]
		assert(entrance.x and entrance.y)
	end

	--' Build class description
	--' These properties might be overwritten below
	local classDesc = {}
	classDesc.class = "CustomerGroup"

	--' Get customer info
	--' If the trigger predefines a type, take that one...
	--' ... otherwise choose one at random,
	--' ... otherwise no info
	classDesc.customers = {}
	local customerInfo = meta and meta.customers
	if (isTable(customerInfo)) then
		for _,v in pairs(customerInfo) do
			local ci = (isString(v) and self.customerList and self.customerList[v]) or v
			if (isTable(ci)) then
				table.push_back(classDesc.customers, table.copy(ci))
			else
				print("Error! Customer info table could not be found: "..tostring(v).." ("..tostring(ci)..")")
			end
		end
	end
	meta.customers = nil

	--' Determine the place
	meta.place = meta.place or randomFromWeightedTable(self.placeChances)

	meta.size = meta.size or 0
	if (isNumber(meta.male)) then
		meta.size = meta.size + meta.male
	end
	if (isNumber(meta.female)) then
		meta.size = meta.size + meta.female
	end

	--' Create customer desctiptions
	if (self.customerList) then
		if (table.empty(classDesc.customers)) then
			local customerCount = 1
			if (meta.place == "table") then
				assert(self.maxTableGroupSize > 0, "No tables (or chairs) have been added to the level!")
				customerCount = meta.size ~= 0 and meta.size or math.Random(self.maxTableGroupSize-1) + 1
				customerCount = math.min(customerCount, self.maxTableGroupSize)
			elseif (meta.place == "disco") then
				assert(self.maxDiscoGroupSize and self.maxDiscoGroupSize > 0, "maxDiscoGroupSize needs to be set in the rest default file!")
				customerCount = meta.size ~= 0 and meta.size or math.Random(self.maxDiscoGroupSize-1) + 1
				customerCount = math.min(customerCount, self.maxDiscoGroupSize)
			end

			local tempCharacter = randomFromWeightedTable(self.customerList)

			assert(customerCount > 0)
			for i=1, customerCount do
				table.push_back(classDesc.customers, table.copy(tempCharacter))
			end
		else
			local tempCharacter = randomFromWeightedTable(self.customerList)
			for _,v in ipairs(classDesc.customers) do
				if (not isTable(v) or not v.base) then
					table.copy_into(v, tempCharacter, true, false)
				end
			end
		end
	end

	--' Set a unique id
	self.customerGroupId = (self.customerGroupId or 0) + 1
	if (classDesc.name == nil or classDesc.name == "") then
		classDesc.name = "CustomerGroup "..tostring(self.customerGroupId)
	end

	meta.male = meta.male or 0
	meta.female = meta.female or 0

	if (isTable(meta.customer)) then
		for _,v in ipairs(classDesc.customers) do
			table.copy_into(v, meta.customer)
		end
	end

	for k,v in pairs(classDesc.customers) do
		assert(v and v.base)
		assert(not v.__used)
		v.__used = true

		v.class = "Customer"
		v.x = entrance.x
		v.y = entrance.y

		assert(meta.male == nil or isNumber(meta.male), "'male' was not number (probably a string from XML)!")
		assert(meta.female == nil or isNumber(meta.female), "'female' was not number (probably a string from XML)!")
		assert(meta.size == nil or isNumber(meta.size), "'size' was not number (probably a string from XML)!")

		local chosenGender
		if (k <= meta.male) then
			chosenGender = "male"
		elseif (k <= meta.male + meta.female) then
			chosenGender = "female"
		else
			chosenGender = (math.Random(1000) < 500 and "male") or "female"
		end

		v.gender = v.gender or chosenGender
		if (meta.place == "table") then
			v.edible = true --' Table customers only order edible products
		end

		v.name = v.name or ("Customer "..self.customerGroupId.."-"..k)
	end

	--' Set the initial mood
	classDesc.startMood = self:calcValueI("startMood")

--' Print order
--' --' *** pr("["..classDesc.name.."] Create order:")
--'for k,p in ipairs(meta.order.steps) do
--'	if (isTable(p)) then
--'		 --' *** pi("Step: "..k)
--'		for _,i in ipairs(p) do
--'			 --' *** pb(i)
--'		end
--'		 --' *** pd()
--'	end
--'end

	--' Merge with trigger
	--' This overwrites existing properties
	if (meta) then
		for k, v in pairs(meta) do
			if (k ~= "trigger" and
				k ~= "delay" and
				k ~= "type" and
				k ~= "customer")
			then
				if (isTable(v)) then
					classDesc[k] = {}
					classDesc[k] = table.copy_into(classDesc[k], v, true, false, true)
				else
					classDesc[k] = v
				end
			end
		end
	end

	classDesc.size = #classDesc.customers
	
	--' Add CustomerGroup
	local customerGroup = self.systemLayer:newChild(classDesc)
	customerGroup:onInitialized()
	return customerGroup
end

function DelLevel:createOrder(orderSteps, orderSize, customer, selfExclusive)
	local order = {}
	if (customer.group.place == "table") then
		orderSize = orderSize or (math.min(self.tableOrderSize, customer.group.size))
		orderSteps = orderSteps or self.orderSteps or 1
	else --' counter
		orderSize = orderSize or self.counterOrderSize
		orderSteps = 1
	end

	--' last resort fallback
	if (orderSize == 0) then
		orderSize = 2
	end

	order = self:createOrder_Delicious6(orderSteps, orderSize, customer, selfExclusive)

--'	if (customer.group.place == "table") then
--'		if (self.paperChance and self.paperStep and customer.group.size == 1) then --' Customer has a chance to order a paper
--'			local orderPaper = true
--'			local possibleProducts = self.possibleProducts --' Can only order paper if it is a possible product (calc this once per shift?)
--'			for _,v in ipairs(self.paperStep) do
--'				if (not table.contains(possibleProducts, v)) then
--'					orderPaper = false
--'					break
--'				end
--'			end
--'			orderPaper = orderPaper and math.Random() < self.paperChance
--'			--'print("Chance to order a paper: Order "..(orderPaper and "succeeded" or "failed"))
--'			if (orderPaper) then
--'				local alreadyPaperOrder = false
--'				 --' *** pi("Order is "..table.tostring(order.steps))
--'				repeat
--'					if (alreadyPaperOrder) then
--'						order = self:createOrder_Delicious6(orderSteps, orderSize, customer, selfExclusive)
--'						 --' *** pb("New order is "..table.tostring(order.steps))
--'					end
--'					alreadyPaperOrder = true
--'					for _,step in ipairs(order.steps) do
--'						if (#step == #self.paperStep) then
--'							local same = true
--'							for i=1,#self.paperStep do
--'								if (step[i] ~= self.paperStep[1]) then
--'									same = false
--'									break
--'								end
--'							end
--'							if not same then
--'								alreadyPaperOrder = false
--'								break
--'							end
--'						end
--'					end
--'				until (not alreadyPaperOrder)
--'				 --' *** pd()
--'				table.insert(order.steps, 1, self.paperStep)
--'				orderSteps = orderSteps + 1
--'			end
--'		end
--'		assert(self.paperChance or not self.paperStep, "paperStep was defined without matching paperChance")
--'		assert(self.paperStep or not self.paperChance, "paperChance was defined without matching paperStep")
--'	end
	
	return order
end

function DelLevel:createOrder_Delicious6(orderSteps, orderSize, customer, selfExclusive)
	local products = self.possibleProducts
	local order = { class="Order", }
	order.steps = {}
	local chosen = {}
	for stepsIdx = 1, orderSteps do
		customer.hasHardProduct = false
		local step = table.push_back(order.steps, {})
		for ingIdx=1, orderSize do
			local product
			repeat
				product = self:getNewProductFor(customer)
			until (not selfExclusive or not table.contains(chosen, product))
			table.push_back(chosen, product)
			table.push_back(step, product)
		end
	end
	return order
end

--' Update All ProductSettings
function DelLevel:updateProductSettings()
	for _,p in ipairs(self.possibleProducts) do
		self.productSettings = self.productSettings or {}
		local product = self.productSettings[p]
		if (not product) then
			product = table.copy(level.defaultPoductSettings)
			self.productSettings[p] = product
		end
	end
end

--' Get a product using the settings in the customer and the productInfo
function DelLevel:getNewProductFor(customer)
	local posibleProducts = self.possibleProducts
	local products = {}
	for _,p in ipairs(posibleProducts) do
		assert(self.productSettings)
--'print("Product: "..p)
		local product = self.productSettings[p]
		assert(product)

		local weight = 1
		if (not product.orderable) then
--'print("Not orderable "..p)
			weight = 0
		elseif (customer.hasHardProduct and product.hard) then
--'print("Hard "..p)
			weight = 0
		else
			for k, v in pairs(product) do
--'print("      "..k.." = "..tostring(customer[k]))
				if (isBoolean(v) and isBoolean(customer[k]) and customer[k] ~= v) then
					weight = 0
--'print("No match: "..p)
					break
				elseif (isNumber(v) and (k == "chance" or customer[k] == true)) then
					weight = weight * (v / 100) --' Percentage
--'print("Weight: "..p.." ("..weight..")")
				end
			end
		end

		if (weight > 0) then
			products[p] = weight * 1000
		end
	end

	if (not table.empty(products)) then
		local resultProduct = randomFromWeightedTable(products)
		local settings = self.productSettings[resultProduct]
		if (settings and settings.hard) then
			customer.hasHardProduct = true
		end
		return resultProduct
	end

	--' Fallback
	if (not table.empty(self.possibleProducts)) then
		local orderableProducts = {}
		for _,v in ipairs(self.possibleProducts) do
			local settings = self.productSettings[v]
			if (settings and settings.orderable and not settings.hard) then
				table.push_back(orderableProducts, v)
			end
		end
		return orderableProducts[math.Random(#orderableProducts)]
	end

	return nil --' Error!
end

function DelLevel:handleTrigger(trigger, meta)
	if (trigger == "spawn" or trigger == "spawnCustomer") then
		if (--'not meta.storyLevelIdx or meta.storyLevelIdx == player.challengeProgressIdx or
			not meta.requiresUpgrade == true or self.valueAdders.spawnBonusCharacters
			) then
			self:spawnCustomerGroup(meta, meta.playSound)
		end

	elseif (trigger == "object") then
		if (not meta.name) then
			DelLevel.super.handleTrigger(self, trigger, meta)

		else
			local object = level:getSpriteExt(meta.name)
			if (object and isCallable(object.handleTrigger)) then
				object:handleTrigger(meta.type, meta)
			end
		end

	elseif (trigger == "startShift") then
		self:shiftStart()

	elseif (trigger == "finishShift") then
		self:shiftFinish()

	elseif (trigger == "finishGame") then
		self:gameFinished()

	elseif (trigger == "showTray") then
		tray:animate({alpha=1, duration=meta.duration or 0})

	elseif (trigger == "hideTray") then
		tray:animate({alpha=0, duration=meta.duration or 0})

	else
		DelLevel.super.handleTrigger(self, trigger, meta)
	end
end

function DelLevel:createPostShiftAnimation()
	local doPostShiftAnimation = true
	if (self.isGamePlayLevel) then
		doPostShiftAnimation = level.score >= level.targetScore
	end

	local anim
	if (event) then
		if (event.onShiftFinish) then
			anim = event:onShiftFinish()
		end
	end
	anim = anim or ghf.anim.animation()

	if (not anim or not anim.atEnd) then
		anim = ghf.anim.animation()
		assert(anim.atEnd, "1. the famous atEnd error!!!!!!!!!!!!!")
	end
	
	if (anim and anim.atEnd) then
		anim:atEnd({class="CallTask", func=function()
			if (doPostShiftAnimation) then
				local anim2 = taskSystem:createAnimation("postShift")
				if (anim2) then
					self.levelDeleted = true --'nasty var to keep track of this level...
					anim2:atEnd({class="CallTask", func=function() if (level.levelDeleted ~= nil) then self:onShiftFinishEnd() end end})
					return anim2
				end
			end
			self:onShiftFinish()
		end})
	end
	return anim
end

function DelLevel:onShiftFinishStart()
	if (event) then
		event:onShiftFinishStart()
	end
end

function DelLevel:onCancelChain()
end

function DelLevel:debugHeroWalkTo(x, y)
	if (level.beforeAddWorkTaskOnClick) then
		level:beforeAddWorkTaskOnClick(nil, hero)
	end
	hero:addTask({class="WalkToTask", target={x=x, y=y}, playDefaultOnFinish=true})
end