--[[
hintTypeKeywords = 
{
	"image",--'default
	"text",
	"compound",
}
]]--

hintFuncs = {}
hintFuncs.clearPendingWorkTasks = function(obj)
--' For now just cancel them all; later maybe try to restore them
	local workChar = obj:getWorkCharacter()
	if (workChar and obj:allowWork(workChar)) then
		taskSystem:cancelAllTasksFor(workChar)
	end
end
hintFuncs.progressHintAfterWorkDone = function(obj, hintId)
	local workChar = obj:getWorkCharacter()
	if (workChar and obj:allowWork(workChar)) then
		workChar:addTask({class="CallTask", func=function() hintManager:tryProgressHint(hintId) end, shouldCheckForCompound=false})
		return true
	end
end

hintFuncs.makeSureOvenIsEmpty = function(obj, hintId)
	local cookProductName
	if (hintId == "paprika_filling_1" or hintId == "paprika_filling_2") then
		cookProductName = "paprika_cooked"
	end
	if (not cookProductName) then return end
	local ovenProduct = level:getObject(cookProductName)
	assert(ovenProduct, "\nCould not find object '"..ts(cookProductName).."' for hint '"..ts(hintId).."'")
	if (ovenProduct) then
		ovenProduct.state = "inactive"
	end
end
hintFuncs.buildTrayHint = function(obj, hintDesc, step)
	local t = {}
--' First construct tray from the left
	local openWidth = 26
	local middleWidth = 44
	local totalWidth = openWidth + middleWidth*tray.maxSize
	table.insert(t, {"TRAY_LEFT", x=0})
	for i=0, tray.maxSize-1 do
		table.insert(t, {"TRAY_MIDDLE", x=((openWidth+middleWidth)/2) + middleWidth*i})
	end
	table.insert(t, {"TRAY_RIGHT", x=totalWidth})
	products = tray.products
	local c = 0
	for _,v in ipairs(products) do
		local xPos = ((openWidth+middleWidth)/2) + middleWidth*c
		table.insert(t, {"product"..v.name, x=xPos})
		if (hintDesc.subject and hintDesc.subject.name == v.name) then
			table.insert(t, {"DELETE", x=xPos, frame=9, alpha=0.9})
		end
		c = c + 1
	end
--' Then offset all by half distance to center align
	for _,v in ipairs(t) do
		v.x = v.x - (totalWidth/2)
	end
	hintDesc.images = t
end

hintDescs =
{
	--' Products Room 1
	bruschetta = {
		character="evelyn",
		emotion="serve",
		tipType="bottomRight",
		clearTray=true,
		constrainToRoom=1,
		constrainToShift=3,
		{hintType="image", title="New_Recipe", label="ClickToContinue", labelBlink=true, image="button#bruschetta#tomato#olive:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
		{hintType="compound", product="#bruschetta#tomato#olive", subjectActiveFocus=true, offset={x=-9, y=-9}, onClickFunc=hintFuncs.clearPendingWorkTasks},
		{hintType="image", title="Product_bruschetta", label="Click_ToDeliver", image="button#bruschetta#tomato#olive:room1_icons", offset={x=-17, y=7}, offsetFrom="top", updateHero=true},
	},
	bruschetta_delight = {
		character="evelyn",
		emotion="serve",
		tipType="bottomRight",
		clearTray=true,
		constrainToRoom=1,
		constrainToShift=6,
		{hintType="image", title="New_Recipe", label="ClickToContinue", labelBlink=true, image="button#bruschetta#lettuce#tomato#olive:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
		{hintType="compound", product="#bruschetta#lettuce#tomato#olive", subjectActiveFocus=true, offset={x=-9, y=-9}, onClickFunc=hintFuncs.clearPendingWorkTasks},
		{hintType="image", title="Product_bruschetta_delight", label="Click_ToDeliver", image="button#bruschetta#lettuce#tomato#olive:room1_icons", offset={x=-17, y=7}, offsetFrom="top", updateHero=true},
	},
	bruschetta_super_deluxe = {
		character="evelyn",
		emotion="serve",
		tipType="bottomRight",
		clearTray=true,
		constrainToRoom=1,
		constrainToShift=9,
		{hintType="image", title="New_Recipe", label="ClickToContinue", labelBlink=true, image="button#bruschetta#lettuce#tomato#mozzarella#olive:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
		{hintType="compound", product="#bruschetta#lettuce#tomato#mozzarella#olive", subjectActiveFocus=true, offset={x=-9, y=-9}, onClickFunc=hintFuncs.clearPendingWorkTasks},
		{hintType="image", title="Product_bruschetta_super_deluxe", label="Click_ToDeliver", image="button#bruschetta#lettuce#tomato#mozzarella#olive:room1_icons", offset={x=-17, y=7}, offsetFrom="top", updateHero=true},
	},
	paprika_filling_1 = {
		character="evelyn",
		emotion="serve",
		tipType="bottomRight",
		clearTray=true,
		constrainToRoom=1,
		constrainToShift=5,
		{hintType="image", title="New_Recipe", label="ClickToContinue", labelBlink=true, image="button#paprika#filling1:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
		{hintType="compound", product="#paprika#filling1.ready", subjectActiveFocus=true, offset={x=-9, y=-9}, onClickFunc=function(subject,hintId,x,y) hintFuncs.clearPendingWorkTasks(subject,hintId,x,y) hintFuncs.makeSureOvenIsEmpty(subject,hintId,x,y) hintManager.activeHint.updateHero=true end},
		{hintType="image", title="New_Recipe", label="Wait", labelDots=true, images={{"oven", x=-7, y=17}, {"button#paprika#filling1.ready:room1_icons", x=-19, y=9}, {"oven_door", x=-7, y=17}}, subject="paprika_cooked", offsetFrom="topLeft", closeOnClickSubject=false},
		{hintType="image", title="New_Recipe", label="Click_Paprika", images={{"oven", x=-7, y=17}, {"button#paprika#filling1.ready:room1_icons", x=-19, y=9}}, subject="paprika_cooked", updateHero=true, updateSubject=false, offsetFrom="topLeft"},
		{hintType="image", title="Product_paprika_filling_1", label="Click_ToDeliver", image="button#paprika#filling1:room1_icons", offset={x=-17, y=7}, offsetFrom="top", updateHero=true},
	},
	paprika_filling_2 = {
		character="evelyn",
		emotion="serve",
		tipType="bottomRight",
		clearTray=true,
		constrainToRoom=1,
		constrainToShift=10,
		{hintType="image", title="New_Recipe", label="ClickToContinue", labelBlink=true, image="button#paprika#filling2:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
		{hintType="compound", product="#paprika#filling2.ready", subjectActiveFocus=true, offset={x=-9, y=-9}, onClickFunc=function(subject,hintId,x,y) hintFuncs.clearPendingWorkTasks(subject,hintId,x,y) hintFuncs.makeSureOvenIsEmpty(subject,hintId,x,y) hintManager.activeHint.updateHero=true end},
		{hintType="image", title="New_Recipe", label="Wait", labelDots=true, images={{"oven", x=-7, y=17}, {"button#paprika#filling2.ready:room1_icons", x=-19, y=9}, {"oven_door", x=-7, y=17}}, subject="paprika_cooked", offsetFrom="topLeft", closeOnClickSubject=false},
		{hintType="image", title="New_Recipe", label="Click_Paprika", images={{"oven", x=-7, y=17}, {"button#paprika#filling2.ready:room1_icons", x=-19, y=9}, }, subject="paprika_cooked", updateHero=true, updateSubject=false, offsetFrom="topLeft"},
		{hintType="image", title="Product_paprika_filling_2", label="Click_ToDeliver", image="button#paprika#filling2:room1_icons", offset={x=-17, y=7}, offsetFrom="top", updateHero=true},
	},
	newspaper = {
		character="evelyn",
		emotion="serve",
		tipType="bottom",
		clearTray=true,
		constrainToRoom=1,
		constrainToShift=8,
		{hintType="image", title="New_Product", label="ClickToContinue", labelBlink=true, image="button#newspaper:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-17, y=7}, offsetFrom="top"},
		{hintType="image", title="New_Product", label="Click_Newspaper", image="button#newspaper:room1_icons", subject="newspaper", updateHero=true, x=9, y=-9, subjectActiveFocus=true, onClickFunc=hintFuncs.clearPendingWorkTasks},
		{hintType="image", title="Product_newspaper", label="Click_ToDeliver", images={{"button#newspaper:room1_icons", x=-55}, {"hint_is:gui"}, {"hint_hearts:gui", x=49, y=-4}}, offset={x=-17, y=7}, offsetFrom="top", subjectHighlight=true, updateHero=true},
	},
--'	coffee = 
--'	{
--'		character="evelyn",
--'		emotion="serve",
--'		tipType="bottom",
--'		clearTray=true,
--'		constrainToRoom=1,
--'		constrainToShift=7,
--'		{hintType="image", title="New_Recipe", label="ClickToContinue", labelBlink=true, image="button#coffee:room1_icons", closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
--'		{hintType="image", title="New_Recipe", label="Click_Coffee", image="button#coffee:room1_icons", subject="coffee_tap", updateHero=true, updateSubject=false, offsetFrom="topLeft"},
--'		{hintType="image", title="New_Recipe", label="Wait", labelDots=true, image="button#coffee_prepare:room1_icons", subject="coffee_container", offsetFrom="topLeft", closeOnClickSubject=false},
--'		{hintType="image", title="New_Recipe", label="Click_Coffee", image="button#coffee:room1_icons", subject="coffee_tap", updateHero=true, updateSubject=false, offsetFrom="topLeft"},
--'		{hintType="image", title="Product_coffee", label="Click_ToDeliver", image="button#coffee:room1_icons", offset={x=-17, y=7}, offsetFrom="top", updateHero=true},
--'	},
	restock_paprika = {
		constrainToRoom=1,
		{hintType="image", title="No_Stock", label="Click_Paprika_Restock", image="button#paprika:room1_icons", subject="paprika_3", updateHero=true, character="evelyn", emotion="oops", subjectActiveFocus=true, onClickFunc=hintFuncs.clearPendingWorkTasks},
	},

	paprika_filling1_burned = {
		character="evelyn",
		emotion="oops",
		constrainToRoom=1,
		{hintType="image", title="Product_Decay", label="ClickToContinue", images={{"oven", x=-7, y=17}, {"button#paprika#filling1.ready_decay:room1_icons", x=-19, y=1, frame=10}}, subject="paprika_cooked", labelBlink=true, closeOnClickAnywhere=true, updateSubject=false, offsetFrom="topLeft"},
	},
	paprika_filling2_burned = {
		character="evelyn",
		emotion="oops",
		constrainToRoom=1,
		{hintType="image", title="Product_Decay", label="ClickToContinue", images={{"oven", x=-7, y=17}, {"button#paprika#filling2.ready_decay:room1_icons", x=-19, y=1, frame=10}}, subject="paprika_cooked", labelBlink=true, closeOnClickAnywhere=true, updateSubject=false, offsetFrom="topLeft"},
	},
	coffee_spilled = {
		character="evelyn",
		emotion="oops",
		constrainToRoom=1,
		{hintType="image", title="Product_Decay", label="ClickToContinue", image="button#coffee_decay:room1_icons", subject="coffee_container", labelBlink=true, closeOnClickAnywhere=true, updateSubject=false, offsetFrom="topLeft"},
	},

	--' Personel Room 1
	cleaner = {
		character="evelyn",
		emotion="new",
		constrainToRoom=1,
		constrainToShift=3,
		{hintType="image", title="Cleaner", label="Click_DirtyTable", image="evelyn_cleaner:room1_hints", offset={y=10}, waitForCompletion=false},
	},
	entertainer = {
		character="evelyn",
		emotion="new",
		constrainToRoom=1,
		constrainToShift=6,
		{hintType="image", title="Entertainer", label="Click_Entertainer", image="francois_entertainer:room1_hints", subject="francois", offset={y=10},
			preInitFunc=function() assert(not entertainer.clickable, "\nFor the entertainer hint the entertainer should initially be unclickable!") entertainer.clickable = true end,
			onClickFunc=function(obj, hintId) entertainer.selected = true taskSystem:cancelAllTasksFor(entertainer) return true end,},
		{hintType="image", title="Entertainer", label="Click_Table", images={{"francois_entertainer_mime:room1_hints", x=-55}, {"hint_is:gui"}, {"hint_hearts:gui", x=49, y=-4}}, onClickFunc=function(obj, hintId) entertainer.selected = true end, waitForCompletion=false},
	},

	--' Events Room 1
	event_clean_plates = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Clean_Plates", label="Click_ToClean", image="clean_event:room1_hints", subject="fixmix3", onClickFunc=hintFuncs.clearPendingWorkTasks, waitForCompletion=false},
	},
	event_read_letter = {
		character="evelyn",
		emotion="serve",
		{hintType="image", title="Read_Letter", label="Click_Letter", image="love_letter:room1_hints", subject="letter", subjectActiveFocus=true, onClickFunc=hintFuncs.clearPendingWorkTasks, waitForCompletion=false},
	},
	event_serve_jimmy = {
		character="evelyn",
		emotion="serve",
		{hintType="image", title="Serve_Jimmy", label="ClickToContinue", image="jimmy_order:room1_hints", subject="table5", x=-45, y=-45, offsetFrom="topLeft", tipType="bottom", labelBlink=true, closeOnClickAnywhere=true},
	},
	event_clean_rubbish = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Recycle", label="Click_Rubbish", image="glass_bottle:room1_hints", subject="glass1", offset={x=8, y=4}, tipType="topLeft", subjectActiveFocus=true, onClickFunc=function(subject,hintId,x,y) hintFuncs.clearPendingWorkTasks(subject,hintId,x,y) hintManager.activeHint.updateHero=true end,},
		{hintType="image", title="Recycle_Bin", label="Click_Bin", image="bin_glass:room1_hints", subject="bin_glass", offsetFrom="topLeft", tipType="bottomRight", updateHero=true},
	},

	--' Events Room 2
	event_find_luggage = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Find_Luggage", label="Click_Suitcase", image="suitcase_1:room2_hints", subject="suitcase_1", subjectActiveFocus=true, tipType="topRight", x=-5, y=15, updateSubject=false, waitForCompletion=false},
	},
	event_vacuum_cleanup = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Vacuum_Cleanup", label="Click_Collect", image="green_pants:room2_hints", subject="vacuum_cleanup_item4", subjectActiveFocus=true, waitForCompletion=false},
	},
	event_dancing_lesson = {
		character="evelyn",
		emotion="serve",
		{hintType="image", title="Serve_Jimmy", label="ClickToContinue", image="jimmy_order:characters", subject="table5", labelBlink=true, closeOnClickAnywhere=true},
	},
	event_comfort_carlos = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Comfort", label="Click_Comfort", image="carlos_event:room2_hints", subject="carlos2", x=20, y=20, updateSubject=true, waitForCompletion=false, onClickFunc=function(subject,hintId,x,y) hintFuncs.clearPendingWorkTasks(subject,hintId,x,y) hintManager.activeHint.updateHero=true end},--'Does not tick the event! (which is good)
	},

	--' Events Room 3
	event_delivery_cart = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Delivery_Cart", label="Click_Retrieve", image="trolley:room3_hints", subject="dining_car", updateSubject=false, onClickFunc=function(subject,hintId,x,y) taskSystem:cancelAllTasksFor(hero) hintManager.activeHint.updateHero=true end, subjectHighlight = true, waitForCompletion=false,},
	},
	event_store_it = {
		character="evelyn",
		emotion="serve",
		{hintType="image", title="Store_It", label="Click_Store", image={"delivery_box:room3_hints", y=8}, subject="conductor", tipType="bottomRight", offsetFrom="topLeft", offset={x=10, y=7}, updateSubject=false, subjectHighlight=true, waitForCompletion=false, onClickFunc=function(subject,hintId,x,y) hintFuncs.clearPendingWorkTasks(subject,hintId,x,y) hintManager.activeHint.updateHero=true end},
	},

	--' Products Room 4
	drawer = {
		character="evelyn",
		emotion="new",
		tipType="bottomRight",
		constrainToRoom=4,
		constrainToShift=5,
		{hintType="image", title="New_Product", label="ClickToContinue", image="button#lobster.ready:room4_icons", labelBlink=true, closeOnClickAnywhere=true, subjectHighlight=false, offset={x=-9, y=-58}, offsetFrom="top"},
		{hintType="image", title="Drawer", label="Click_Drawer", image="open_drawer:room4_hints", subject="drawer", y=20, updateHero=true},
	},

	--' Events Room 4
	event_chase_jean_paul = {
		character="evelyn",
		emotion="oops",
		tipType="bottom",
		{hintType="image", title="Chase_JP", label="Click_Chase", image=":room4_hints", subject="jeanpaul", updateSubject=false},
	},

	--' Products Room 5

	--' Events Room 5


	--' Etc
	tray_unused_item = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Tray_Unused_Item", label="ClickToContinue", preInitFunc=hintFuncs.buildTrayHint, closeOnClickAnywhere=true, labelBlink=true, subjectHighlight=false}, --'Init with func
	},
	tray_full = {
		character="evelyn",
		emotion="oops",
		{hintType="image", title="Tray_Full", label="ClickToContinue", preInitFunc=hintFuncs.buildTrayHint, closeOnClickAnywhere=true, labelBlink=true, subjectHighlight=false, y=-30}, --'Init with func
	},
	shop = {
		character="francois",
		emotion="ecstatic",
		tipType="bottomLeft",
		{hintType="text", title="Shop_Welcome", message="Shop_Msg_Welcome", label="ClickToContinue", tipType="none", closeOnClickAnywhere=true, labelBlink=true,},
		{hintType="text", title="Shop_DecoMoney", message="Shop_Msg_DecoMoney", label="ClickToContinue", x=287, y=587, labelBlink=true, closeOnClickAnywhere=true},
		{hintType="text", title="Shop_GoShop", message="Shop_Msg_GoShop", label="ClickToContinue", x=120, y=387, labelBlink=true, closeOnClickAnywhere=true},
	},
	calendar_shop = {
		character="francois",
		emotion="ecstatic",
		{hintType="text", title="Shop_Unlocked", message="Shop_Msg_Unlocked", label="Click_Shop", updateSubject=true},
	},
	score_shop = {
		character="francois",
		emotion="ecstatic",
		{hintType="text", title="Shop_Score_DecoMoney", message="Shop_Score_Msg_DecoMoney", label="ClickToContinue", offsetFrom="topRight", tipType="bottomLeft", closeOnClickAnywhere=true, labelBlink=true,},
	},
}
