dofile("script/rooms/rest5_defaults.lua")
dofile("script/animations/shift5_8_animations.lua")

levelDesc.name = "shift5_8"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 6

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		
		{ trigger="spawn", delay=2500, 		place="counter",  order={class="Order", steps={{"#bottle_grape","#veggiesoup#springonion",},} }},
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="table", 	size=4, },
		{ trigger="spawn", delay=10000, 	place="table",  size=2, },
		{ trigger="spawn", delay=17000, 	place="counter",  },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=13000, 	place="table", 	size=4, },
		{ trigger = "startEvent", delay=0},
		
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=17000, 	place="table", 	size=4, },
		{ trigger="spawn", delay=10000, 	place="table",  size=2, },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="table", 	size=2, },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=17000, 	place="table", 	size=4, },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=10000, 	place="counter",  },
		{ trigger="spawn", delay=2500, customers={"p10","p13"}, specialFriend=true, moodDropEnabled=false, place="table", },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=10000, 	place="table",  size=2, },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=17000, 	place="counter",  },
		{ trigger="spawn", delay=10000, 	place="counter",  },
		{ trigger="spawn", delay=10000, 	place="table",  size=2, },
		{ trigger="spawn", delay=12000, 	place="counter",  },

	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
	
	-- Special friends
	p8 = { weight=0, base="cameo_betty", gender="FEMALE" },
	p9 = { weight=0, base="cameo_bully", gender="MALE" },
	p10 = { weight=0, base="cameo_charles", gender="MALE" },
	p11 = { weight=0, base="cameo_elvis", gender="MALE" },
	p12 = { weight=0, base="cameo_mailman", gender="MALE" },
	p13 = { weight=0, base="cameo_matthew", gender="MALE" },
	p14 = { weight=0, base="cameo_mayor", gender="FEMALE" },
	p15 = { weight=0, base="cameo_mo", gender="MALE" },
	p16 = { weight=0, base="cameo_tashi", gender="FEMALE" },
}

levelDesc.eventDesc =
{
	class="ShoutAndMakeEvent",
	bar = "progressbar_big",
	productPool = {"#jam#blueberry", "#blueberry", "#bottle_grape", "#bottle_grapefruit", "#bottle_orange", "#cheesecake#currants", "#jam#currants", "#currants"},
	numProductsPerOrder = 2,
	numOrders = 10,
	scoreOneDone = 50,
	timeUntilFirstOrder = 0,
	timeUntilNextOrder = 8000,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 9,	
	eventBarIconObject = "table2-4",
	items = 
	{
		{ obj="table2-4", barPos = {x=35, y=160}, workDuration=10, timeUntilEnd=140000, },
	},
	objectAllProductsDone = function(event, item) 
		ShoutAndMakeEvent.objectAllProductsDone(event, item)
		-- stop eating
		if (event.eating) then
			level:getCharacter("CUSTOMER1"):playAnimation("SIT")
			level:getCharacter("CUSTOMER2"):playAnimation("SIT")
			level:getCharacter("CUSTOMER3"):playAnimation("SIT")
			level:getCharacter("BIGGIE"):playAnimation("SIT")
		end
		event.eating = false
	end,
	
	orderFirstTime = function(event,item)
		print(item.numOrders)
		print(event.numOrders)
		if (item.numOrders == event.numOrders) then
			level:getCharacter("CUSTOMER1"):playAnimation("ORDER", -1)
			level:getCharacter("CUSTOMER2"):playAnimation("ORDER", -1)
			level:getCharacter("CUSTOMER3"):playAnimation("ORDER", -1)
			level:getCharacter("BIGGIE"):playAnimation("ORDER", -1)
		end
	end,
}

function levelDesc:onDeliverProducts(item)
	if (not event.completed and not event.eating) then
		event.eating = true
		level:getCharacter("CUSTOMER1"):playAnimation("DRINK", -1)
		level:getCharacter("CUSTOMER2"):playAnimation("DRINK", -1)
		level:getCharacter("CUSTOMER3"):playAnimation("EAT", -1)
		level:getCharacter("BIGGIE"):playAnimation("EAT", -1)
	end
end

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	level:getObject("table2-4").usedInGameplay = false
	level:getObject("table2-4").clickable = false
end