dofile("script/rooms/rest5_defaults.lua")
dofile("script/animations/shift5_5_animations.lua")

levelDesc.name = "shift5_5"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 6

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger="spawn", delay=2500, 		place="counter", order={class="Order", steps={{"#jam#blueberry","#cheesecake#currants",},} } },
		{ trigger="pickup_flower1", delay=12000},
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="table",  size=4, },
		{ trigger="spawn", delay=14000, 	place="table",  size=2, },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=2500, customers={"p15","p16"}, specialFriend=true, moodDropEnabled=false, place="table", },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="pickup_flower2", delay=10000},
		{ trigger="spawn", delay=14000, 	place="table",  size=4, },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=10000, 	place="counter",  },
		{ trigger="spawn", delay=14000, 	place="table",  size=2, },
		{ trigger="spawn", delay=11000, 	place="counter",  },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="pickup_flower3", delay=13000},
		{ trigger="spawn", delay=10000, 	place="table",  size=2, },
		{ trigger="spawn", delay=13000, 	place="counter",  },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=12000, 	place="table", 	size=2, },
		{ trigger="spawn", delay=14000, 	place="counter",  },
		{ trigger="pickup_flower4", delay=10000},
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="table", 	size=3, },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=8000, 		place="counter",  },
		{ trigger="spawn", delay=9000, 		place="table",  size=2, },
		{ trigger="pickup_flower5", delay=10000},
        { trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=9000, 		place="counter",  },
        { trigger="spawn", delay=10000, 	place="counter",  },
		{ trigger="spawn", delay=9000, 		place="table",  size=4, },
        { trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=9000, 		place="counter",  },
	}
	
}

function levelDesc:handleTrigger(trigger, data)
	if (trigger == "pickup_flower1" and not event.completed) then
		local character = level:createCharacter({base="elderly", gender="FEMALE"})
		character:addTask({class="PositionTask", position=level.currentRoom.entrances[math.Random(#level.currentRoom.entrances)-1],})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-ELDERLY",})
		character:addTask({class="WalkToTask", target={x=91,y=471}, playDefaultOnFinish=true})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-ELDERLY-FLOWERS",})
		character:addTask({class="Task", duration=1000})
		character:addTask({class="ExitTask", exit=math.Random(#level.currentRoom.exits)-1})

	elseif (trigger == "pickup_flower2" and not event.completed) then
		local character = level:createCharacter({base="yup", gender="FEMALE"})
		character:addTask({class="PositionTask", position=level.currentRoom.entrances[math.Random(#level.currentRoom.entrances)-1],})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-YUP",})
		character:addTask({class="WalkToTask", target={x=91,y=471}, playDefaultOnFinish=true})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-YUP-FLOWERS",})
		character:addTask({class="Task", duration=1000})
		character:addTask({class="ExitTask", exit=math.Random(#level.currentRoom.exits)-1})
	
	elseif (trigger == "pickup_flower3" and not event.completed) then
		local character = level:createCharacter({base="designer", gender="FEMALE"})
		character:addTask({class="PositionTask", position=level.currentRoom.entrances[math.Random(#level.currentRoom.entrances)-1],})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-DESIGNER",})
		character:addTask({class="WalkToTask", target={x=91,y=471}, playDefaultOnFinish=true})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-DESIGNER-FLOWERS",})
		character:addTask({class="Task", duration=1000})
		character:addTask({class="ExitTask", exit=math.Random(#level.currentRoom.exits)-1})

	elseif (trigger == "pickup_flower4" and not event.completed) then
		local character = level:createCharacter({base="big", gender="FEMALE"})
		character:addTask({class="PositionTask", position=level.currentRoom.entrances[math.Random(#level.currentRoom.entrances)-1],})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-BIG",})
		character:addTask({class="WalkToTask", target={x=91,y=471}, playDefaultOnFinish=true})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-BIG-FLOWERS",})
		character:addTask({class="Task", duration=1000})
		character:addTask({class="ExitTask", exit=math.Random(#level.currentRoom.exits)-1})
	
	elseif (trigger == "pickup_flower5" and not event.completed) then
		local character = level:createCharacter({base="regular", gender="FEMALE"})
		character:addTask({class="PositionTask", position=level.currentRoom.entrances[math.Random(#level.currentRoom.entrances)-1],})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-REGULAR",})
		character:addTask({class="WalkToTask", target={x=91,y=471}, playDefaultOnFinish=true})
		character:addTask({class="BaseAnimationTask", baseAnimation="CUSTOMER-REGULAR-FLOWERS",})
		character:addTask({class="Task", duration=1000})
		character:addTask({class="ExitTask", exit=math.Random(#level.currentRoom.exits)-1})
		end
	
	return DelLevel.handleTrigger(self, trigger, data)
end

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
	
	-- Special friends
	p8 = { weight=0, base="cameo_betty", gender="FEMALE" },
	p9 = { weight=0, base="cameo_bully", gender="MALE" },
	p10 = { weight=0, base="cameo_charles", gender="MALE" },
	p11 = { weight=0, base="cameo_elvis", gender="MALE" },
	p12 = { weight=0, base="cameo_mailman", gender="MALE" },
	p13 = { weight=0, base="cameo_matthew", gender="MALE" },
	p14 = { weight=0, base="cameo_mayor", gender="FEMALE" },
	p15 = { weight=0, base="cameo_mo", gender="MALE" },
	p16 = { weight=0, base="cameo_tashi", gender="FEMALE" },
}

levelDesc.eventDesc =
{
	class="ClickFixEvent",	
	bar="progressbar_click_fix",	
	hideItemOnDone = true,
	clickSoundId = "SOUND_HAMMER:sound",
	customCursor = {image="SHOVEL:icons", x=10, y=65, frameTime=120, mousePointer="none"},
	scoreAllDone = 100,
	scoreOneDone = 25,
	event_onWorkUpdate = function(self, task)
		  print("update")  
		 end,
}