dofile("script/rooms/rest5_defaults.lua")
dofile("script/animations/shift5_4_animations.lua")

levelDesc.name = "shift5_4"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 6

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="spawn", delay=2500, 		place="counter", order={class="Order", steps={{"#sweater","#cheesecake#currants",},} } },
		{ trigger="spawn", delay=12000, 	place="table",  size=3, },
		{ trigger="spawn", delay=9000, 		place="counter",  },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=13000, 	place="counter",  },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="table",  size=4, },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=12000, 	place="table",  size=4, },
		{ trigger="spawn", delay=17000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=18000, 	place="table",  size=3, },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=12000, 	place="table",  size=2, },
		{ trigger="spawn", delay=18000, 	place="counter",  },
		{ trigger="spawn", delay=2500, customers={"p12","p14"}, specialFriend=true, moodDropEnabled=false, place="table", },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=17000, 	place="table",  size=3, },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
		{ trigger="spawn", delay=14000, 	place="table",  size=4, },
		{ trigger="spawn", delay=12000, 	place="counter",  },
		{ trigger="spawn", delay=15000, 	place="counter",  },
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
	
	-- Special friends
	p8 = { weight=0, base="cameo_betty", gender="FEMALE" },
	p9 = { weight=0, base="cameo_bully", gender="MALE" },
	p10 = { weight=0, base="cameo_charles", gender="MALE" },
	p11 = { weight=0, base="cameo_elvis", gender="MALE" },
	p12 = { weight=0, base="cameo_mailman", gender="MALE" },
	p13 = { weight=0, base="cameo_matthew", gender="MALE" },
	p14 = { weight=0, base="cameo_mayor", gender="FEMALE" },
	p15 = { weight=0, base="cameo_mo", gender="MALE" },
	p16 = { weight=0, base="cameo_tashi", gender="FEMALE" },
}

levelDesc.eventDesc =
{
	class="FixEvent",
	scoreAllDone = 400,
	autoStart = true,
	hintArrowDesc = {hintId="FixTableArrow3", parent="table2-2", x=136, y=30},
	items = {
		{
			obj="table2-2", workAnimation="WORK", fixAmount=70000, barPos={x=136, y=100},
			onEventItemDone = function(self)
				self.usedInGameplay = true
				self:playDefaultAnimation()
				self.location = level.oldTableLocation
				level:getObject("table2-2_chair1").visible = true
				level:getObject("table2-2_chair2").visible = true
			end
		},
	},
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	local table2_2 = level:getObject("table2-2")
	table2_2.usedInGameplay = false
	table2_2:playAnimation("BROKEN")
	level.oldTableLocation = table2_2.location
	table2_2.location = {x=170, y=303}
	level:getObject("table2-2_chair1").visible = false
	level:getObject("table2-2_chair2").visible = false
end
