dofile("script/rooms/rest4_defaults.lua")
dofile("script/animations/shift4_9_animations.lua")

levelDesc.name = "shift4_9"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 6

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		

		{ trigger = "spawn", delay=2500, 	place="counter", },
		{ trigger = "spawn", delay=10000,	place="table", size=3},
		{ trigger = "spawn", delay=10000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=15000, 	place="table", size=4},
		{ trigger = "spawn", delay=14000,	place="table", size=4},
		{ trigger = "spawn", delay=10000, 	place="counter", },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "spawn", delay=14000,	place="table", size=4},
		{ trigger = "spawn", delay=10000, 	place="counter", },
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "startEvent", delay=0},
		{ trigger = "spawn", delay=18000,	place="table", size=4},
		{ trigger = "spawn", delay=14000, 	place="counter", },
		{ trigger = "spawn", delay=18000,	place="table", size=2},
		{ trigger = "spawn", delay=14000, 	place="counter", },
		{ trigger = "spawn", delay=14000, 	place="counter", },
		{ trigger = "spawn", delay=16000,	place="table", size=3},
		{ trigger = "spawn", delay=14000, 	place="counter", },
		{ trigger = "spawn", delay=19000,	place="counter", },
		{ trigger = "spawn", delay=19000,	place="counter", },
		{ trigger = "spawn", delay=12000,	place="table", size=4},
		{ trigger = "spawn", delay=15000, 	place="counter", },
		{ trigger = "spawn", delay=15000, 	place="counter", },
		{ trigger = "spawn", delay=15000, 	place="counter", },
		{ trigger = "spawn", delay=15000, 	place="table", size=4},
		{ trigger = "spawn", delay=14000,	place="table", size=4},

	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="ShoutAndMakeEvent",
	bar = "progressbar_big",
	productPool = {"#coffee", "#special_coffee", "#garlic_bread", "#pumpkin_soup", "#tomato_soup", "#ravioli#carbonara", "#ravioli#bolognese", "#dough#bolognese", "#dough#carbonara"},
	numProductsPerOrder = 2,
	numOrders = 10,
	scoreOneDone = 40,
	timeUntilFirstOrder = 0,
	timeUntilNextOrder = 8000,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 9,
	eventBarIconObject = "table6",
	items =
	{
		{ obj="table6", barPos = {x=55, y=215}, timeUntilEnd=150000, },
	},
	objectAllProductsDone = function(self, item) 
		ShoutAndMakeEvent.objectAllProductsDone(self, item)
		-- Stop eating
		if (self.eating) then
			level:getCharacter("MAYOR"):playAnimation("SIT")
			level:getCharacter("CEO"):playAnimation("SIT")
			level:getCharacter("customer2"):playAnimation("SIT")
			level:getCharacter("customer3"):playAnimation("SIT")
			level:getCharacter("customer4"):playAnimation("SIT")
			level:getCharacter("customer5"):playAnimation("SIT")
			level:getCharacter("customer6"):playAnimation("SIT")
			level:getCharacter("customer7"):playAnimation("SIT")
		end
		self.eating = false
	end,
	eventLost = function(self) 
		ShoutAndMakeEvent.eventLost(self)
		-- Stop eating
		level:getCharacter("MAYOR"):playAnimation("SIT")
		level:getCharacter("CEO"):playAnimation("SIT")
		level:getCharacter("customer2"):playAnimation("SIT")
		level:getCharacter("customer3"):playAnimation("SIT")
		level:getCharacter("customer4"):playAnimation("SIT")
		level:getCharacter("customer5"):playAnimation("SIT")
		level:getCharacter("customer6"):playAnimation("SIT")
		level:getCharacter("customer7"):playAnimation("SIT")
		self.eating = false
	end,

	orderFirstTime = function(self, item)
		if (item.numOrders == self.numOrders) then
			level:getCharacter("MAYOR"):playAnimation("ORDER", -1)
			level:getCharacter("CEO"):playAnimation("ORDER", -1)
			level:getCharacter("customer2"):playAnimation("ORDER", -1)
			level:getCharacter("customer3"):playAnimation("ORDER", -1)
			level:getCharacter("customer4"):playAnimation("ORDER", -1)
			level:getCharacter("customer5"):playAnimation("ORDER", -1)
			level:getCharacter("customer6"):playAnimation("ORDER", -1)
			level:getCharacter("customer7"):playAnimation("ORDER", -1)	
		end
	end,	
}

function levelDesc:onDeliverProducts(item)
	if (not event.completed and not event.eating) then
		event.eating = true
		level:getCharacter("MAYOR"):playAnimation("DRINK", -1)
		level:getCharacter("CEO"):playAnimation("EAT", -1)
		level:getCharacter("customer2"):playAnimation("DRINK", -1)
		level:getCharacter("customer3"):playAnimation("EAT", -1)
		level:getCharacter("customer4"):playAnimation("EAT", -1)
		level:getCharacter("customer5"):playAnimation("DRINK", -1)
		level:getCharacter("customer6"):playAnimation("EAT", -1)
		level:getCharacter("customer7"):playAnimation("DRINK", -1)
	end
end

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	level:getObject("table6").usedInGameplay = false
	level:getObject("table6").clickable = false
end
