dofile("script/rooms/rest4_defaults.lua")
dofile("script/animations/shift4_7_animations.lua")

levelDesc.name = "shift4_7"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 6

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=100},
	
		{ trigger = "spawn", delay=2500, 	place="counter", order={class="Order", steps={{"#bottle#grape","#garlic_bread",},} }},
		{ trigger = "spawn", delay=11000,	place="table", size=3},
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=15000, 	place="table", size=4},
		{ trigger = "spawn", delay=14000,	place="table", size=4},
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "spawn", delay=14000,	place="table", size=4},
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "spawn", delay=14000,	place="table", size=4},
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=14000,	place="table", size=2},
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=11000, 	place="counter", },
		{ trigger = "spawn", delay=13000,	place="table", size=3},
		{ trigger = "spawn", delay=13000, 	place="counter", },
		{ trigger = "spawn", delay=16000,	place="counter", },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "spawn", delay=10000,	place="table", size=4},
		{ trigger = "spawn", delay=12000, 	place="counter", },
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="FixEvent",
	scoreAllDone = 300,
	hintArrowDesc = {hintId="FixTableArrow2", parent="table6-2", x=0, y=0},
	items = {{ obj = "table6-2", workAnimation="SIT_WORK", fixAmount = 70000, barPos = {x=58, y=130}, 
		event_onWorkStart = function(self, task) self:getChair(0):place(task.actor) end,
		event_onWorkFinish = function(self, task) self:getChair(0):standUp() end, }},
	
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	level:getObject("table6-2").usedInGameplay = false
	level:getObject("table6-2").clickable = false
end
