dofile("script/rooms/rest4_defaults.lua")
dofile("script/animations/shift4_5_animations.lua")

levelDesc.name = "shift4_5"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 6

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=100},
	
		{ trigger = "spawn", delay=2500,  place="table", size=2, order={class="Order", steps={{"#ravioli#bolognese","#coffee",},} }},
		{ trigger = "spawn", delay=12000, 	place="table", size=2},
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=15000,	place="table", size=3},
		{ trigger = "spawn", delay=12000, 	place="table", size=2},
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="table", size=2},
		{ trigger = "spawn", delay=15000,	place="table", size=2},
		{ trigger = "spawn", delay=12000, 	place="table", size=4},
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=15000,	place="table", size=2},
		{ trigger = "spawn", delay=12000, 	place="table", size=2},
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="table", size=4},
		{ trigger = "spawn", delay=5000,	place="table", size=2},
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=7000, 	place="table", size=2},
		{ trigger = "spawn", delay=8000, 	place="counter", },
		{ trigger = "spawn", delay=7000,	place="table", size=3},
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="table", size=2},
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=7000,	place="table", size=3},
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="table", size=2},
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=12000, 	place="counter", },
		{ trigger = "spawn", delay=5000, 	place="table", size=2},
		{ trigger = "spawn", delay=15000,	place="table", size=2},
		{ trigger = "spawn", delay=5000, 	place="table", size=3},
		{ trigger = "spawn", delay=5000, 	place="counter", },
		{ trigger = "spawn", delay=5000, 	place="counter", },
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big"},
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="KeepItUpEvent",
	duration = 99999999, --' TODO Event
	bar = "progressbar_big", --' TODO Event
	scoreAllDone = 300,
	playStartAnimation = true,
	startAnimation = "SIT",
	startAnimationCycles = -1,
	startAnimationFrameTime = 300,
	floaterPos = {x=578, y=276},
	onInitialized = function(self)
		KeepItUpEvent.onInitialized(self)
		local table4_4 = level:getObject("table4-4")
		table4_4.usedInGameplay = false		
		table4_4.old_onClick = table4_4.onClick
		table4_4.onClick = function(t)
			level:getCharacter("angela"):onClick()
		end
	end,
	eventWon = function(self)
		KeepItUpEvent.eventWon(self)
		local table4_4 = level:getObject("table4-4")
		table4_4.onClick = table4_4.old_onClick 
	end,
	eventLost = function(self) 
		KeepItUpEvent.eventLost(self)
		local table4_4 = level:getObject("table4-4")
		table4_4.onClick = table4_4.old_onClick
	end, 
	items = {
		{ obj={base="angela"}, absBarPos={x=530, y=275}, barFloor=100, workPos={646, 424}, workAnimation="SIT", workDuration=2000, drainDuration=90000,
		 	event_onWorkStart = function(self, task) level:getObject("table4-4"):getChair(3):place(task.actor) end,
			event_onWorkFinish = function(self, task) level:getObject("table4-4"):getChair(3):standUp() end, 
		},
	},
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	level:getObject("table4-4").usedInGameplay = false
end

function levelDesc:handleTrigger(trigger, meta)
	if (trigger == "activateTable") then
		level:getObject("table4-4").usedInGameplay = true
	else
		DelLevel.handleTrigger(self, trigger, meta)
	end
end

function levelDesc:onFillBarStart(item)
	local clouds = {"DAD_CLOUD", "HEART_CLOUD", "MOM_CLOUD", "RON_CLOUD", "TATTOO_CLOUD"}
	item.obj:createOverhead(clouds[math.Random(#clouds)])
end

function levelDesc:onFillBarEnd(item)	
	item.obj:removeOverhead()
end
