dofile("script/rooms/rest3_defaults.lua")
dofile("script/animations/shift3_8_animations.lua")

levelDesc.name = "shift3_8"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 5
levelDesc.biggerTray = true

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger = "spawn", delay=2500,	place="counter", },
		{ trigger = "spawn", delay=8000,	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=4, },
		{ trigger = "spawn", delay=5000,	place="disco", size=2, },
		{ trigger = "spawn", delay=11000,	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=9500,	place="table", size=4, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=4, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=9500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=5000,	place="disco", size=4, },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=4, },
		{ trigger = "spawn", delay=8000,	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=8500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=4, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=7500,	place="table", size=1, },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=4, },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=7000,	place="counter", },
		{ trigger = "spawn", delay=8500,	place="table", size=1, },
		{ trigger = "spawn", delay=8500,	place="table", size=1, },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="FixEvent",
	hideItemOnDone = false,
	scoreAllDone = 350,
	matchItemAppearance = false,
	hintArrowDesc = {hintId="BeautyCaseArrow", x=615, y=143},
	onInitialized = function(self)
		FixEvent.onInitialized(self)
		level.francois = level:getSpriteExt("francois")
		level.table6 = level:getSpriteExt("table6")
		level.beauty_case = level:getSpriteExt("beauty_case")
		local onClick = function()
			level.table6.clickable = false
			level.beauty_case.clickable = false
			level.francois.clickable = false
			return level.francois:onClick()
		end
		level.table6.onClick = onClick
		level.beauty_case.onClick = onClick
		level.beauty_case:becomeChildOf(level.table6)
		level.beauty_case:sendToBack()
	end,
	items = {
		{ obj={base="francois"}, barPos={x=80, y=-131}, fixAmount=30000,
			workPos={x=673, y=284}, workDirection="left", workAnimation="SITMAKEUP",
		 	event_onWorkStart = function(self, task)
				level.table6.clickable = false
				level.beauty_case.clickable = false
				level.francois.clickable = false
				level.francois:playAnimation("DOMAKEUP", -1, 150)
				level.table6:getChair():place(task.actor)
			end,
			event_onWorkFinish = function(self, task)
				level.francois:playDefaultAnimation()
				level.table6:getChair():standUp()
				local done = (self.item.progress >= self.item.fixAmount)
				level.table6.clickable = not done
				level.beauty_case.clickable = not done
			end,
		},
	},
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	level:getSpriteExt("table6").usedInGameplay = false		
end
