dofile("script/rooms/rest3_defaults.lua")
dofile("script/animations/shift3_10_animations.lua")

levelDesc.name = "shift3_10"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 5

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "spawn", delay=2500,	place="counter", },
		{ trigger = "spawn", delay=2500,	place="table", size=1, },
		{ trigger = "spawn", delay=7500,	place="counter", },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=5000,	place="disco", size=3, },
		{ trigger = "spawn", delay=11500,	place="table", size=1, },
		{ trigger = "spawn", delay=11500,	place="table", size=1, },
		{ trigger = "spawn", delay=10000,	place="counter", },
		{ trigger = "spawn", delay=11500, 	place="counter", },
		{ trigger = "spawn", delay=11500,	place="table", size=1, },
		{ trigger = "spawn", delay=11500,	place="table", size=1, },
		{ trigger = "spawn", delay=11000,	place="counter", },
		{ trigger = "spawn", delay=11500,	place="table", size=1, },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "spawn", delay=11500, 	place="counter", },
		{ trigger = "spawn", delay=11500,	place="table", size=1, },
		{ trigger = "spawn", delay=14000,	place="counter", },
		{ trigger = "startEvent", delay=0},
		{ trigger = "spawn", delay=8500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=5000,	place="disco", size=2, },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=15000,	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=7000,	place="table", size=1, },
		{ trigger = "spawn", delay=7000,	place="table", size=1, },
		{ trigger = "spawn", delay=7000,	place="table", size=1, },
		{ trigger = "spawn", delay=12500, 	place="counter", },
		{ trigger = "spawn", delay=12500,	place="table", size=1, },
		{ trigger = "spawn", delay=15000,	place="counter", },
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="ShoutAndMakeEvent",
	bar = "progressbar_big",
	productPool = {"#rocket", "#soda_pink", "#soda_yellow","#conewhite", "#toast#cheese_toast#toast", },
	numProductsPerOrder = 2,
	numOrders = 10,
	scoreOneDone = 40,
	timeUntilFirstOrder = 0,
	timeUntilNextOrder = 8000,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 9,
	items = 
	{
		{ obj="table9", barPos = {x=40, y=310}, timeUntilEnd=150000, },
	},
	objectAllProductsDone = function(event, item) 
		ShoutAndMakeEvent.objectAllProductsDone(event, item)
		-- Stop eating
		if (event.eating) then
			level:getCharacter("customer1"):playAnimation("SIT")
			level:getCharacter("customer2"):playAnimation("SIT")
			level:getCharacter("customer3"):playAnimation("SIT")
			level:getCharacter("customer4"):playAnimation("SIT")
			level:getCharacter("customer5"):playAnimation("SIT")
			level:getCharacter("customer6"):playAnimation("SIT")
			level:getCharacter("customer7"):playAnimation("SIT")
			level:getCharacter("customer8"):playAnimation("SIT")
			level:getCharacter("customer9"):playAnimation("SIT")
			level:getCharacter("customer10"):playAnimation("SIT")
		end
		event.eating = false
	end,

	eventLost = function(event) 
		ShoutAndMakeEvent.eventLost(event)
		-- Stop eating
		level:getCharacter("customer1"):playAnimation("SIT")
		level:getCharacter("customer2"):playAnimation("SIT")
		level:getCharacter("customer3"):playAnimation("SIT")
		level:getCharacter("customer4"):playAnimation("SIT")
		level:getCharacter("customer5"):playAnimation("SIT")
		level:getCharacter("customer6"):playAnimation("SIT")
		level:getCharacter("customer7"):playAnimation("SIT")
		level:getCharacter("customer8"):playAnimation("SIT")
		level:getCharacter("customer9"):playAnimation("SIT")
		level:getCharacter("customer10"):playAnimation("SIT")
		event.eating = false
	end,
	
	orderFirstTime = function(event, item)
		if (item.numOrders == event.numOrders) then
			level:getCharacter("customer1"):playAnimation("ORDER", -1)
			level:getCharacter("customer2"):playAnimation("ORDER", -1)
			level:getCharacter("customer3"):playAnimation("ORDER", -1)
			level:getCharacter("customer4"):playAnimation("ORDER", -1)
			level:getCharacter("customer5"):playAnimation("ORDER", -1)
			level:getCharacter("customer6"):playAnimation("ORDER", -1)
			level:getCharacter("customer7"):playAnimation("ORDER", -1)
			level:getCharacter("customer8"):playAnimation("ORDER", -1)
			level:getCharacter("customer9"):playAnimation("ORDER", -1)
			level:getCharacter("customer10"):playAnimation("ORDER", -1)
		end
	end,
}

function levelDesc:onDeliverProducts(item)
	if (not event.completed and not event.eating) then
		event.eating = true
		level:getCharacter("customer1"):playAnimation("DRINK", -1)
		level:getCharacter("customer2"):playAnimation("EAT", -1)
		level:getCharacter("customer3"):playAnimation("EAT", -1)
		level:getCharacter("customer4"):playAnimation("EAT", -1)
		level:getCharacter("customer5"):playAnimation("DRINK", -1)
		level:getCharacter("customer6"):playAnimation("EAT", -1)
		level:getCharacter("customer7"):playAnimation("EAT", -1)
		level:getCharacter("customer8"):playAnimation("DRINK", -1)
		level:getCharacter("customer9"):playAnimation("DRINK", -1)
		level:getCharacter("customer10"):playAnimation("EAT", -1)
	end
end
