dofile("script/rooms/rest2_defaults.lua")
dofile("script/animations/shift2_7_animations.lua")

levelDesc.name = "shift2_7"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 5

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger = "spawn", delay=500, place="counter", },
		{ trigger = "spawn", delay=12000, place="counter", },
		{ trigger = "spawn", delay=15000, place="table", size=4, },
		{ trigger = "spawn", delay=20000, place="table", size=2, },
		{ trigger = "spawn", delay=12000, place="table", size=2, },
		{ trigger = "spawn", delay=16000, place="table", size=3, },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="table", size=2, },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="table", size=4, },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=14000, place="table", size=2, },
		{ trigger = "spawn", delay=16000, place="table", size=4, },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="table", size=2, },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="table", size=4, },
		{ trigger = "spawn", delay=15000, place="counter", },
		{ trigger = "spawn", delay=15000, place="table", size=2, },
		{ trigger = "spawn", delay=15000, place="counter", },
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="FixEvent",
	scoreAllDone = 400,
	hintArrowDesc = {hintId="FixTableArrow", parent="table5-2", x=0, y=0},
	items = {{
		obj = "table5-2", workAnimation = "SIT", fixAmount = 70000, barPos = {x=33, y=130}, 
		onRestoreItem = function(self)
			self.obj:getChair(0):standUp()
			taskSystem:cancelAllTasksFor(self.obj:getWorkCharacter())
			level:getCharacter("grandma"):playAnimation("SIT", 0)
		end,
		event_onWorkStart = function(self, task)
			self:getChair(0):place(task.actor)
			level:getCharacter("grandma"):playAnimation("SIT", -1)
		end,
		event_onWorkFinish = function(self, task)
			self:getChair(0):standUp()
			level:getCharacter("grandma"):playAnimation("SIT", 0)
		end,
	}},
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	level:getObject("table5-2").usedInGameplay = false
	level:getObject("table5-2").clickable = false
end
