dofile("script/rooms/rest1_defaults.lua")
dofile("script/animations/shift1_9_animations.lua")

levelDesc.name = "shift1_9"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 4

levelDesc.heroId = "grandma"

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger = "spawn", delay=2500, 	place="table",	size=3},
		{ trigger = "spawn", delay=11000, 	place="table",	size=4},
		{ trigger = "spawn", delay=14000, 	place="table",	size=2},
		{ trigger = "spawn", delay=18000, 	place="counter"},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=14000, 	place="table",	size=1},
		{ trigger = "spawn", delay=15000, 	place="table",	size=1},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=14000,	place="table", size=2},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=11000,	place="table", size=4},
		{ trigger = "spawn", delay=15000,	place="table", size=3},
		{ trigger = "spawn", delay=16000,	place="table", size=1},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=15000, 	place="counter"},
		{ trigger = "spawn", delay=16000,	place="table", size=2},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=14000,	place="table", size=4},
		{ trigger = "spawn", delay=14000, 	place="counter"},
		{ trigger = "spawn", delay=15000, 	place="counter"},
		{ trigger = "spawn", delay=14000, 	place="table"},
		{ trigger = "spawn", delay=10000, 	place="counter"},
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="ClickFixEvent",	
	bar="progressbar_click_fix",
	hideItemOnDone = false,
	customCursor = {image="HAMMER:icons", x=25, y=25, frameTime=120, mousePointer="none"},
	clickSoundId = "SOUND_HAMMER:sound",
	hintDesc = {hintId="FixDecorations", target="decorations2", offset={x=90,y=170}, subject="decorations2", showButton=false},
	scoreAllDone = 100,
	scoreOneDone = 25,
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	cleaner.followObject = "grandma"
end

function levelDesc:onEventProgress(event, progress)
	local stork = level:getChild("decorations2")
	local floors = { -80, -36, -28 }
	stork.floor = floors[stork.frame+1]
end

function levelDesc:onEventStepDone(event, item)
	if (item and item.obj and item.obj.name == "decorations2") then
		hintManager:openHint({hintId="AllDecorations"})
		local off = {
			{x=90,y=190},
			{},
			{x=40,y=200},
			{x=100,y=230},
		}
		for i=1,4 do
			local obj = level:getObject("decorations"..i)
			if (obj and i ~= 2) then
				hintManager:placeArrow({hintId="AllDecorationsArrow"..i, parent=obj, x=off[i].x, y=off[i].y})
			end
		end
	end
end
