dofile("script/rooms/rest1_defaults.lua")
dofile("script/animations/shift1_10_animations.lua")

levelDesc.name = "shift1_10"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2

levelDesc.values.maxTraySize = 4

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger = "spawn", delay=500,  	place="table",	size=2},
		{ trigger = "spawn", delay=15000,  	place="table",	size=2},
		{ trigger = "spawn", delay=10000,  	place="table",	size=4},
		{ trigger = "spawn", delay=15000,  	place="counter"},
		{ trigger = "spawn", delay=14000,  	place="table",	size=3},
		{ trigger = "spawn", delay=15000,  	place="counter"},
		{ trigger = "spawn", delay=15000,  	place="counter"},
		{ trigger = "spawn", delay=15000,  	place="table",	size=4},
		{ trigger = "spawn", delay=16000,  	place="counter"},
		{ trigger = "spawn", delay=15000,  	place="table",	size=2},
		{ trigger = "spawn", delay=15000,  	place="counter"},
		{ trigger = "spawn", delay=13000,  	place="counter"},
		{ trigger = "spawn", delay=10000,  	place="table",	size=2},
		{ trigger = "spawn", delay=10000,  	place="counter"},
		{ trigger = "spawn", delay=14000,  	place="table",	size=4},
		{ trigger = "spawn", delay=14000,  	place="counter"},
		{ trigger = "spawn", delay=14000,  	place="counter"},
		{ trigger = "spawn", delay=14000,  	place="counter"},
		{ trigger = "spawn", delay=10000,  	place="counter"},
		{ trigger = "spawn", delay=12000,  	place="table",	size=4},
		{ trigger = "spawn", delay=15000,  	place="counter"},
		{ trigger = "spawn", delay=15000,  	place="counter"},
		{ trigger = "spawn", delay=12000,  	place="table",	size=2},
		{ trigger = "spawn", delay=15000,  	place="table",	size=3},
		{ trigger = "spawn", delay=14000,  	place="counter"},
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
}

function shift1_10_onTick(self, time)
	KeepItUpEvent.onTick(self, time)

	if (not self.started or self.completed) then
		return
	end

	self.evelyn = self.evelyn or level:getCharacter("evelyn")
	if (self.evelyn) then
		if (eventBar.progress > 0.7) then
			self.evelyn:stopLoopSample()
			if (self.evelyn.currentAnimation ~= "SITLAUGH") then
				self.evelyn:playAnimation("SITLAUGH")
				self.evelyn:playSample("SOUND_BABY_LAUGH:sound")
			end
		elseif (eventBar.progress > 0.4) then
			self.evelyn:stopLoopSample()
			if (self.evelyn.currentAnimation ~= "SITTING") then
				self.evelyn:playAnimation("SITTING")
			end
		else
			if (eventBar.progress < 0.2) then
				hintManager:openHint({hintId="BarAlmostEmpty", target=self.evelyn, subject=self.evelyn, offset={x=10,y=20}})
			end
			if (self.evelyn.currentAnimation ~= "SITCRY") then
				self.evelyn:playAnimation("SITCRY")
				self.evelyn:loopSample("SOUND_BABY_CRYING:sound")
			end
		end
	end
end

levelDesc.eventDesc =
{
	class="KeepItUpEvent",
	duration = 999999999999,
	bar = "progressbar_big",
	floaterPos = {x=939, y=100},
	scoreAllDone = 300,
	initialProgress = 0.7,
	onTick = shift1_10_onTick,
	items = {
		{
			obj = {base="evelyn"},
			barPos = {x=-10, y=-160},
			workPos = {x=939, y=260},
			workAnimation = "DANCING",
			workDuration = 2000, drainDuration = 90000,
			workCharacter = "emily",
			event_onWorkStart = function(self, task)
				self:stopLoopSample()
			end,
		},
	},
	eventLost = function(self)
		local anim = KeepItUpEvent.eventLost(self)
		self.completed = true
		self.evelyn:stopLoopSample()
		if (self.evelyn.station) then
			self.evelyn.station:standUp()
		end		
		self.evelyn:playAnimation("CRYSERIOUS", 0, nil, "stay")
		self.evelyn:addTask({class="Task", duration=3000})
		self.evelyn:addTask({class="WalkToTask", target={x=800, y=-10}})
		self.evelyn.walkSpeed = 200
		return anim
	end,
	hintDesc = {hintId="AngelaSadBar", target="evelyn", offset={x=40,y=90}},
}
