dofile("script/rooms/rest1_defaults.lua")
dofile("script/animations/shift1_1_animations.lua")

levelDesc.name = "shift1_1"
levelDesc.musicMood = "1"
levelDesc.levelsWonForHigherDifficulty = 1
levelDesc.levelsLostForLowerDifficulty = 2
levelDesc.autoStartShift = false
levelDesc.values.maxTraySize = 3
levelDesc.tutorialActive = false
levelDesc.tutorialState = -1
levelDesc.currentGroup = nil
levelDesc.tutorialCharacter = nil

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{

-----' Example: -----------------------------------
--'	{ trigger = "spawn", delay=2500, customers={"p1", "p1"}, place="table", female=1, male=1, order={class="Order", steps={{"#milk", "#milk"},} }},
--' special friend 
--'	{ trigger = "spawn", customers={"p8"}, delay=0,	place="counter", moodDropEnabled=false, order={class="Order", steps={{"#lantern", "#gas"},},} },
--------------------------------------------------

		{ trigger = "spawn", delay=2500, place="counter"},
		{ trigger = "spawn", delay=12500, place="counter" },
		{ trigger = "spawn", delay=12500, place="table", size=2},
		{ trigger = "spawn", delay=12500, place="counter", },
		{ trigger = "startEvent", delay=2000},
		{ trigger = "spawn", delay=12500, place="table", size=2 },
		{ trigger = "spawn", delay=12500, place="counter", },
		{ trigger = "spawn", delay=12500, place="counter", },
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="designer" },
	p4 = { weight=50, base="elderly" },
	p5 = { weight=50, base="farmer" },
	p6 = { weight=50, base="regular" },
	p7 = { weight=50, base="yup" },
--' special friend
--' p8 = { weight=0, base="stacy" },
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	cleaner.workActive = false
end

levelDesc.eventDesc =
{
	class="FixEvent",
	scoreAllDone = 300,
	hintArrowDesc = {hintId="SheepArrow", parent="sheep", x=0, y=0},
	items = {
		{obj="sheep",
		 fixAmount=17500,
		 barPos={x=0, y=-100},
		 base_animations = {"SHEEP-STATE1","SHEEP-STATE2","SHEEP-STATE3","SHEEP-STATE4",},
		 stateChange = function(self) self:playSample("SOUND_SHEEP:sound") end,
		 event_onWorkStart = function(self, task)
		  self:playSample("SOUND_SHEEP:sound")
		  local obj = level:getSpriteExt("emily")
		  if (obj) then
			obj.old_stationaryActive = obj.stationaryActive
			obj.stationaryActive = false
			obj:addTask({class="WalkToTask", target={x=699,y=470}, playDefaultOnFinish=true})
			obj:addTask({class="DirectionTask", direction="right"})
			obj:addTask({class="PlayAnimationTask", animation="PETTING", cycles=-1, frameTime=150})			
		  end
		 end,
		 event_onWorkFinish = function(self, task)
		  local obj = level:getSpriteExt("emily")		  
		  if (obj) then
			obj.stationaryActive = obj.old_stationaryActive
			taskSystem:cancelAllTasksFor(obj)	
		  end		  
		 end,
		},		
	},
}

function doHintArrow(obj, id, offset)
	assert(obj)
	obj.oldClick = obj.onClick
	obj.onClick = onArrowObjectClick
	offset = offset or {x=0, y=0}
	hintManager:placeArrow({
		hintId=id,
		parent=level.dragLayer,
		x=obj.left + offset.x + obj.width/2,
		y=obj.top + offset.y,
	})
	level:disableAllObjects()
	obj.clickable = true
end

function levelDesc:disableAllObjects()
	local objs = self:getObjects()
	for _,v in ipairs(objs) do
		if (v.old_clickable == nil) then
			v.old_clickable = v.old_clickable or (v.clickable == true)
		end
		v.clickable = false
	end
	if (tray) then
		if (tray.old_clickable == nil) then
			tray.old_clickable = tray.old_clickable or (tray.clickable == true)
		end
		tray.clickable = false
	end
end

function levelDesc:restoreAllObjects()
	local objs = self:getObjects()
	for _,v in ipairs(objs) do
		v.clickable = v.old_clickable
	end
	if (tray) then
		tray.clickable = tray.old_clickable
	end
end

function levelDesc:onMessageClick(command, id, object)
	if (id == "DO_TUTORIAL") then
		if (command == "yes") then
			level:startTutorial()
		elseif (command == "no") then
			taskSystem:createAnimation("startShift")
		end
	end
end

function levelDesc:removeLastMessage()
	if (self.tutorialCharacter and self.tutorialCharacter.currentMessageId ~= "") then
		self.tutorialCharacter:removeMessageDialog(self.tutorialCharacter.currentMessageId)
		self.tutorialCharacter.currentMessageId = ""
	end
end

function levelDesc:doTutorialMessage(messageId, wait)
	self:removeLastMessage()
	if (wait) then
		self.tutorialCharacter:addTask({class="StartStoryTask"})
		self.tutorialCharacter:addTask({class="MessageTask", textId=messageId, tipSide="right"})
		self.tutorialCharacter:addTask({class="TriggerTask", trigger=messageId})
		self.tutorialCharacter:addTask({class="EndStoryTask"})
	else
		self.tutorialCharacter.currentMessageId = messageId
		self.tutorialCharacter:addTask({class="MessageTask", tipSide="right", textId=messageId, keepOpen=true, needsClick=false })
		self.tutorialCharacter:addTask({class="TriggerTask", trigger=messageId})
	end
end

function levelDesc:startTutorial()
	self.tutorialState = 0
	self.tutorialActive = true
	self.inputAlwaysEnabled = true
	self.tutorialCharacter = self:getCharacter("edward")
	self.tutorialCharacter.currentMessageId = ""
	self:disableAllObjects()
	
	level.isGamePlayLevel = false
	
	self.tutorialCharacter:addTask({class="MessageTask", textId="TUTORIAL_1"})
	self.tutorialCharacter:addTask({class="TriggerTask", trigger="TUTORIAL_1"})
	self.tutorialCharacter:addTask({class="EndStoryTask"})
end

function levelDesc:handleTrigger(trigger, data)
	if (trigger == "TUTORIAL_1") then
		self:fireTrigger("spawn", {delay=10000, customers={{base="big", thinkTime=2000}}, place="counter", moodDropEnabled=false, male=1, order={class="Order", steps={{"#sunflower"},} }})

	elseif (trigger == "TUTORIAL_2") then
		local obj = self:getSpriteExt("sunflower")
		doHintArrow(obj)
		self.tutorialState = 1

	elseif (trigger == "TUTORIAL_3") then
		doHintArrow(self.currentGroup.main, nil, {x=0, y=-50})
		self.tutorialState = 2	

	elseif (trigger == "TUTORIAL_4") then
		local obj = self:getSpriteExt("register")
		doHintArrow(obj)
		self.tutorialState = 3

	elseif (trigger == "TUTORIAL_5") then
		self:getCharacter("emily"):resetTimer()
		self:getCharacter("emily"):addTask({class="PlayAnimationTask", animation="NODYES", cycles=3})
		self:fireTrigger("spawn", {delay=2500, customers={{base="designer", thinkTime=2000, eatTime=2000}, {base="designer", thinkTime=2000, eatTime=2000}}, place="table", moodDropEnabled=false, female=1, male=1, order={class="Order", steps={{"#lemonade", "#glasslemonade"},} }})
		self.tutorialState = 4

	elseif (trigger == "TUTORIAL_6") then
		local obj = self:getSpriteExt("lemonade")
		doHintArrow(obj)
		self.tutorialState = 5

	elseif (trigger == "TUTORIAL_7") then
		local obj = level:getSpriteExt("register")	
		doHintArrow(obj)
		level.tutorialState = 8	

	elseif (trigger == "TUTORIAL_8") then
		self.tutorialCharacter:addTask({class="PlayAnimationTask", animation="SMILING"})
		level:doTutorialMessage("TUTORIAL_9", false)

	elseif (trigger == "TUTORIAL_9") then
		assert(level.currentTable)
		doHintArrow(level.currentTable)	
		level.tutorialState = 9

	elseif (trigger == "END_TUTORIAL") then
		level.tutorialState = 100
		self.tutorialActive = false
		self.inputAlwaysEnabled = false
		self:restoreAllObjects()
		level.isGamePlayLevel = true
		self.tutorialCharacter:addTask({class="WalkToTask", target=self.heroPosition, playDefaultOnFinish=true})
		taskSystem:createAnimation("startShift")
	end
	
	return DelLevel.handleTrigger(self, trigger, data)
end

function levelDesc:onCustomerGroupStateEnter(customerGroup, state, prevState)
	if (state == "Ordering") then
		if (self.tutorialState == 0) then
			-- counter group
			self.currentGroup = customerGroup
			self:doTutorialMessage("TUTORIAL_2", false)

		elseif (self.tutorialState == 4) then
			-- table group
			self.currentGroup = customerGroup
			self.currentTable = customerGroup.table
			self:doTutorialMessage("TUTORIAL_6", false)

		end
	elseif (state == "Paying") then
		if (self.tutorialState == 2) then
			self:doTutorialMessage("TUTORIAL_4", false)

		elseif (self.tutorialState == 7) then
			self:doTutorialMessage("TUTORIAL_7", false)

		end
	end		
end

function levelDesc:onWorkFinish(task)
	if (level.tutorialState == 10) then
		self.tutorialCharacter:addTask({class="StartStoryTask"})
		self.tutorialCharacter:addTask({class="MessageTask", textId="TUTORIAL_10"})
		self.tutorialCharacter:addTask({class="MessageTask", textId="TUTORIAL_11"})
		self.tutorialCharacter:addTask({class="MessageTask", textId="TUTORIAL_12"})
		self.tutorialCharacter:addTask({class="TriggerTask", trigger="END_TUTORIAL"})
	end
end

function onArrowObjectClick(object)
	object:oldClick()
	object.onClick = object.oldClick
	object.clickable = false
	hintManager:removeArrows("", true)
	
	if (level.tutorialState == 1) then
		level.tutorialCharacter:addTask({class="WalkToTask", target=level.heroPosition, playDefaultOnFinish=true})
		level:doTutorialMessage("TUTORIAL_3", false)

	elseif (level.tutorialState == 3) then
		level.tutorialCharacter:addTask({class="WalkToTask", target=level.heroPosition, playDefaultOnFinish=true})
		level:doTutorialMessage("TUTORIAL_5", true)

	elseif (level.tutorialState == 5) then
		level:removeLastMessage()
		local obj = level:getSpriteExt("glasslemonade")
		doHintArrow(obj)
		level.tutorialState = 6

	elseif (level.tutorialState == 6) then
		assert(level.currentTable)
		level.tutorialCharacter:addTask({class="WalkToTask", target=level.heroPosition, playDefaultOnFinish=true})
		doHintArrow(level.currentTable)
		level.tutorialState = 7

	elseif (level.tutorialState == 8) then
		level.tutorialCharacter:addTask({class="WalkToTask", target=level.heroPosition, playDefaultOnFinish=true})
		level:doTutorialMessage("TUTORIAL_8", true)

	elseif (level.tutorialState == 9) then
		level.tutorialCharacter:addTask({class="WalkToTask", target=level.heroPosition, playDefaultOnFinish=true})
		level:removeLastMessage()
		level.tutorialCharacter:playDefaultAnimation()
		level.tutorialState = 10
	end
	return true
end

