local shiftDir = "script/shifts/"

function getLevelIdxFromFileName(fileName)
	return table.index_of(shifts, fileName)
end

function getLevelIdxFromShiftIdx(roomIdx, shiftIdx)
	return getLevelIdxFromFileName(shiftDir.."shift"..roomIdx.."_"..shiftIdx..".lua")
end

shifts = {
	shiftDir.."intro.lua",		--' 1

	shiftDir.."shift1_1.lua",
	shiftDir.."shift1_2.lua",
	shiftDir.."shift1_3.lua",
	shiftDir.."shift1_4.lua",
	shiftDir.."shift1_5.lua",
	shiftDir.."shift1_6.lua",
	shiftDir.."shift1_7.lua",
	shiftDir.."shift1_8.lua",
	shiftDir.."shift1_9.lua",
	shiftDir.."shift1_10.lua",

	shiftDir.."shift2_0.lua",	--' 12
	shiftDir.."shift2_1.lua",
	shiftDir.."shift2_2.lua",
	shiftDir.."shift2_3.lua",
	shiftDir.."shift2_4.lua",
	shiftDir.."shift2_5.lua",
	shiftDir.."shift2_6.lua",
	shiftDir.."shift2_7.lua",
	shiftDir.."shift2_8.lua",
	shiftDir.."shift2_9.lua",
	shiftDir.."shift2_10.lua",

	shiftDir.."shift3_0.lua",	--' 23
	shiftDir.."shift3_1.lua",
	shiftDir.."shift3_2.lua",
	shiftDir.."shift3_3.lua",
	shiftDir.."shift3_4.lua",
	shiftDir.."shift3_5.lua",
	shiftDir.."shift3_6.lua",
	shiftDir.."shift3_7.lua",
	shiftDir.."shift3_8.lua",
	shiftDir.."shift3_9.lua",
	shiftDir.."shift3_10.lua",

	shiftDir.."shift4_0.lua",	--' 34
	shiftDir.."shift4_1.lua",
	shiftDir.."shift4_2.lua",
	shiftDir.."shift4_3.lua",
	shiftDir.."shift4_4.lua",
	shiftDir.."shift4_5.lua",
	shiftDir.."shift4_6.lua",
	shiftDir.."shift4_7.lua",
	shiftDir.."shift4_8.lua",
	shiftDir.."shift4_9.lua",
	shiftDir.."shift4_10.lua",

	shiftDir.."shift5_0.lua",	--' 45
	shiftDir.."shift5_1.lua",
	shiftDir.."shift5_2.lua",
	shiftDir.."shift5_3.lua",
	shiftDir.."shift5_4.lua",
	shiftDir.."shift5_5.lua",
	shiftDir.."shift5_6.lua",
	shiftDir.."shift5_7.lua",
	shiftDir.."shift5_8.lua",
	shiftDir.."shift5_9.lua",
	shiftDir.."shift5_10.lua",
	
	shiftDir.."outro.lua",		--' 56
}

--' Info:
--' Enter your PC's name here to specify where you go when you start the game.
--' If your PC name isn't here, you'll go trough the normal loading/selection/game path.

--' 1) Entering a number will make you go to the level at that index in the 'shifts' table (see above)
--'    Example: PC666 = 2, will make Luc enter "script/shifts/intro2.lua" on startup.

--' 2) Entering a table containing two numbers will make you go to a specific Room & Shift.
--'    Example: PC666 = {2,5}, will make Luc enter Room 2 Shift 5 on startup.

--' 3) Entering a filename will simply load that level.
--'    Example: PC666 = "script/shifts/intro2.lua", will make Luc enter the 2nd intro on startup.
--'    Example: PC666 = "script/shifts/intro2.lua", will make Luc enter the 2nd intro on startup.

--' 4) Entering "load", "selection", "interstitial", "trophy" or "game" will open that specific scene.
--'    Example: PC666 = "trophy", will make Luc enter the Trophy Scene on startup.

startLevelsForPCs = {
	--PC085 = {1,0},				--' Luc
	--PC076 = {1,0},				--' Roel
	--PC037 = {1,1},  			--' Ruud
	--PC039 = {1,1},			--' Dirk
	--PC062 = {1,1},			--' Andrea
	--PC042 = {2,4},			--' Paul
	--LT042 = {1,1},			--' Sebastiaan
	--LT056 = {1,1}, 			--' Tjien
	--["pc-olga"] = {1,1},		--' Jeremy
	ghmac = {1,0},				--' Studio MiniMac
	["ipad simulator"] = "selection",
}
