if (not skipIncludes) then
	dofile("script/rooms/rest5.lua")
	dofile("script/upgrades/rest5_upgrades.lua")
end

levelDesc.productSettings =
{
	["#pancakes.ready"]									= {big=25, 		chance=50,			elderly=50,			kid=25,			veg=true,	hard=true},
	["#pancakes.ready#pancakes.ready"]					= {big=25, 		chance=25,			elderly=0,			kid=50,			veg=true,	hard=true},
	["#pancakes.ready#pancakes.ready#pancakes.ready"]	= {big=50, 		chance=25,			elderly=0,			kid=25,			veg=true,	hard=true},
	["#cheesecake#blueberry"]							= {big=125, 	chance=100,			elderly=100,		kid=100,		veg=true	},
	["#jam#blueberry"]									= {big=75, 		chance=75,			elderly=100,		kid=0,			veg=true	},
	["#blueberry"]										= {big=150, 	chance=150,			elderly=150,		kid=100,		veg=true	},
	["#bottle_grape"]									= {big=125, 	chance=100,			elderly=100,		kid=75,			veg=true	},
	["#bottle_grapefruit"]								= {big=100, 	chance=100,			elderly=125,		kid=0,			veg=true	},
	["#bottle_orange"]									= {big=100, 	chance=100,			elderly=100,		kid=125,		veg=true	},
	["#cheesecake#currants"]							= {big=125, 	chance=100,			elderly=100,		kid=150,		veg=true	},
	["#jam#currants"]									= {big=120, 	chance=75,			elderly=100,		kid=0,			veg=true	},
	["#currants"]										= {big=150, 	chance=150,			elderly=100,		kid=150,		veg=true	},
	["#lasagna.ready"]									= {big=75, 		chance=50,			elderly=25,			kid=25,			veg=false	},
	["#meatpie.ready"]									= {big=75, 		chance=50,			elderly=25,			kid=25,			veg=false	},
	["#shawl"]											= {big=100, 	chance=125,			elderly=150,		kid=0,			veg=true, 	edible=false	},
	["#sweater"]										= {big=100, 	chance=125,			elderly=150,		kid=0,			veg=true, 	edible=false	},
	["#veggiesoup#springonion"]							= {big=75, 		chance=100,			elderly=125,		kid=75,			veg=true	},
	["#veggiesoup#meatball"]							= {big=125, 	chance=100,			elderly=125,		kid=75,			veg=false	},
	["#veggiesoup#noodles"]								= {big=75, 		chance=100,			elderly=125,		kid=75,			veg=true	},
	["#treat-pizza"]									= {orderable=false},	
}

function levelDesc:onDelivered(deliveredProduct, originalProduct)
	if (string.contains(deliveredProduct,"#veggiesoup")) then
		if (player:isObjectBought("pot", 5)) then
			local pot = level:getSpriteExt("pot")
			if (pot) then
				local pos = hero.floaterPosition
				local score = pot:calcValue("extraSoupbowlBonus")
				level:handleScore(score, pos.x, pos.y, false, 0)
				effects.createScoreFloater(level.floaterLayer, ghf.getString("R5_EXTRASOUPBOWL_BONUS") .. score, pos.x, pos.y, score, 0)
			end
		end
	end
end

function levelDesc:onCustomerPay(character, register, delay)
	if (character.specialFriend) then
		local pos = character.floaterPosition
		local score = character:calcValue("extraFriendsBonus")
		level:handleScore(score, pos.x, pos.y, false, delay)
		effects.createScoreFloater(level.floaterLayer, ghf.getString("SPECIALFRIEND_BONUS") .. score, pos.x, pos.y, score, 0)
	end	
end

function levelDesc:spawnCustomerGroup(meta, playSound)
	if (meta.specialFriend) then
		if (not player:isObjectBought("invitingfriends", 5)) then
			return
		end
	end
	DelLevel.spawnCustomerGroup(self, meta, playSound)
end
