if (not skipIncludes) then
	dofile("script/rooms/rest4.lua")
	dofile("script/upgrades/rest4_upgrades.lua")
end

levelDesc.productSettings =
{
	["#bottle#grape"]			= {big=100, chance=75,		elderly=100,	kid=50,		veg=true	},
	["#bottle#grapefruit"]		= {big=50, 	chance=75,		elderly=75,		kid=0,		veg=true	},
	["#bottle#orange"]			= {big=50, 	chance=75,		elderly=25,		kid=100,	veg=true	},
	["#tomato_soup"]			= {big=75, 	chance=100,		elderly=125,	kid=100,	veg=true	},
	["#pumpkin_soup"]			= {big=75, 	chance=100,		elderly=125,	kid=100,	veg=true	},
	["#coffee"]					= {big=100, chance=150,		elderly=150,	kid=0,		veg=true,	easy=true},
	["#special_coffee"]			= {big=150, chance=150,		elderly=75,		kid=0,		veg=true	},
	["#garlic_bread"]			= {big=150, chance=150,		elderly=150,	kid=150,	veg=true	},
	["#pizza#4cheese"]			= {big=50, 	chance=25,		elderly=50,		kid=0,		veg=true,	hard=true},
	["#pizza#funghi.ready"]		= {big=0, 	chance=25,		elderly=0,		kid=0,		veg=true,	hard=true},
	["#pizza#pepperoni.ready"]	= {big=50, 	chance=25,		elderly=0,		kid=75,		veg=false,	hard=true},
	["#pizza#tuna.ready"]		= {big=0, 	chance=25,		elderly=50,		kid=0,		veg=false,	hard=true},
	["#ravioli#bolognese"]		= {big=0, 	chance=50,		elderly=75,		kid=25,		veg=false	},
	["#ravioli#carbonara"]		= {big=0, 	chance=50,		elderly=25,		kid=75,		veg=true	},
	["#tagliatelli#bolognese"]	= {big=75, 	chance=50,		elderly=75,		kid=25,		veg=false	},
	["#tagliatelli#carbonara"]	= {big=75, 	chance=50,		elderly=25,		kid=75,		veg=true	},
	["#treat-macaroon1"]		= {orderable=false},
	["#treat-macaroon2"]		= {orderable=false},
	["#treat-macaroon3"]		= {orderable=false},
	["#treat-macaroon4"]		= {orderable=false},
}

function levelDesc:onCustomerPay(character, register, delay)
	local wallDecoration = level:getSpriteExt("wall_decorations_upgrade")
	if (wallDecoration) then
		local pos = character.floaterPosition
		local score = wallDecoration:calcValue("extraWalldecorationsBonus")
		level:handleScore(score, pos.x, pos.y, false, delay)
		effects.createScoreFloater(level.floaterLayer, ghf.getString("R4_WALLDECORATION_BONUS") .. score, pos.x, pos.y, score, 0)
	end
end