if (not skipIncludes) then
	dofile("script/rooms/rest2.lua")
	dofile("script/upgrades/rest2_upgrades.lua")
end

levelDesc.productSettings =
{
	["#carrot"]					= {big=60, 		chance=160,		elderly=135,		kid=20,		veg=true	},
	["#lettuce"]				= {big=60, 		chance=160,		elderly=110,		kid=20,		veg=true	},
	["#pumpkin"]				= {big=60, 		chance=160,		elderly=135,		kid=20,		veg=true,	edible=false},
	["#melon"]					= {big=125, 	chance=100,		elderly=0,			kid=125,	veg=true	},
	["#jam#melon"]				= {big=65,		chance=50,		elderly=0,			kid=75,		veg=true	},
	["#pie#melon.ready"]		= {big=40,		chance=15,		elderly=0,			kid=40,		veg=true,	hard=true},
	["#orange"]					= {big=0,		chance=100,		elderly=125,		kid=100,	veg=true	},
	["#jam#orange"]				= {big=0,		chance=50,		elderly=75,			kid=55,		veg=true	},
	["#pie#orange.ready"]		= {big=0,		chance=15,		elderly=40,			kid=20,		veg=true,	hard=true},
	["#pear"]					= {big=100,		chance=100,		elderly=125,		kid=75,		veg=true	},
	["#jam#pear"]				= {big=55,		chance=50,		elderly=75,			kid=25,		veg=true	},
	["#pie#pear.ready"]			= {big=25,		chance=15,		elderly=20,			kid=20,		veg=true,	hard=true},
	["#strawberry"]				= {big=150,		chance=125,		elderly=100,		kid=150,	veg=true	},
	["#jam#strawberry"]			= {big=70,		chance=50,		elderly=55,			kid=70,		veg=true	},
	["#pie#strawberry.ready"]	= {big=45,		chance=15,		elderly=20,			kid=40,		veg=true,	hard=true},
}

levelDesc.controllers = {
	{ objects = {"tree_orange", "orange_1", "orange_2", "orange_3"} },
	{ objects = {"tree_pear", "pear_plant_1", "pear_plant_2", "pear_plant_3"} },
	{ objects = {"tree_strawberry", "strawberry_plant_1", "strawberry_plant_2", "strawberry_plant_3", "strawberry_plant_4", "strawberry_plant_5"} },
}

function levelDesc:onCustomerPay(character, register, delay)
	local scarecrow = level:getSpriteExt("scarecrow_upgrade")
	if (scarecrow) then
		local pos = character.floaterPosition
		local score = scarecrow:calcValue("extraScarecrowBonus")
		level:handleScore(score, pos.x, pos.y, false, delay)
		effects.createScoreFloater(level.floaterLayer, ghf.getString("R2_SCARECROW_BONUS") .. score, pos.x, pos.y, score, 0)
	end
end
