if (not skipIncludes) then
	dofile("script/rooms/rest1.lua")
	dofile("script/upgrades/rest1_upgrades.lua")
end

levelDesc.productSettings =
{
	["#bread#bacon#tomato"]			= {chance=75,	big=125, 	elderly=50,		kid=100,						veg=false,	},
	["#bread#cheese#tomato"]		= {chance=75,	big=125,	elderly=50,		kid=75,							veg=true,	},
	["#bread#bacon#cheese#tomato"]	= {chance=25,	big=50, 	elderly=0,		kid=25,							veg=false,	},
	["#egg.ready#mushroom"]			= {chance=25,	big=25,		elderly=25,		kid=0,							veg=true,	hard=true},
	["#egg.ready#salt_pepper"]		= {chance=25,	big=25,		elderly=25,		kid=0,							veg=true,	hard=true},
	["#egg_big.ready#mushroom"]		= {chance=25,	big=25,		elderly=25,		kid=0,							veg=true,	hard=true},
	["#egg_big.ready#salt_pepper"]	= {chance=25,	big=25,		elderly=25,		kid=0,							veg=true,	hard=true},
	["#honey"]						= {chance=75,	big=100, 	elderly=100,	kid=75,							veg=true,	hard=true},
	["#milk"]						= {chance=150,	big=100, 	elderly=150,	kid=50,							veg=true,	},
	["#lemonade"]					= {chance=150,	big=100,	elderly=0,		kid=100,						veg=true,	},
	["#glasslemonade"]				= {chance=150,	big=100,	elderly=0,		kid=150,						veg=true,	},
	["#rose"]						= {chance=150,	big=0,		elderly=120, 	kid=0,			edible=false,	veg=true,	},
	["#sunflower"]					= {chance=150,	big=0, 		elderly=120,	kid=0,			edible=false,	veg=true,	},
	["#treat-macaroons"]			= {orderable=false,														},
}

function levelDesc:onDelivered(deliveredProduct, originalProduct)
	if (deliveredProduct == "#egg_big.ready#mushroom" or deliveredProduct == "#egg_big.ready#salt_pepper") then
		local ostrich = level:getSpriteExt("ostrich")
		if (ostrich) then
			local pos = hero.floaterPosition
			local score = ostrich:calcValue("bigEggBonus")
			level:handleScore(score, pos.x, pos.y, false, 0)
			effects.createScoreFloater(level.floaterLayer, ghf.getString("R1_BIGEGG_BONUS") .. score, pos.x, pos.y, score, 0)
		end
	end
end

function levelDesc:onCustomerPay(character, register, delay)
	local flowers = level:getSpriteExt("flowers_porch_upgrade")
	if (flowers) then
		local pos = character.floaterPosition
		local score = flowers:calcValue("extraPorchBonus")
		level:handleScore(score, pos.x, pos.y, false, delay)
		effects.createScoreFloater(level.floaterLayer, ghf.getString("R1_PORCHFLOWERS_BONUS") .. score, pos.x, pos.y, score, 0)
	end
end
