--' ************************************ Tap ************************************ '--
Tap = deriveLuaClass("Tap", "IngredientButton")

function Tap:onLevelInitialized()
	Tap.super.onLevelInitialized(self)
	
	self.blockInputDuringWork = true

	self.tapTimer = level:getSpriteExt(self.timerId or "")
	self.container = level:getSpriteExt(self.containerId or "")
	--''pi("["..self.name.."] Level initialized:")
	--''pr("timer: "..self.timerId.."="..tostring(self.tapTimer ~= nil))
	--''pr("container: "..self.containerId.."="..tostring(self.container ~= nil))

	if (self.container) then
		self.oneThirdWorkDuration = self:calcValue("workDuration") / 3
		self.container.state = "inactive"
		self.container.prepareDuration = self.oneThirdWorkDuration
		self.container.decayDelay = self.oneThirdWorkDuration
		self.container.decayDuration = -1 --' Infinite
		self.ingredientName = self.container.ingredientName or ""
		--''pr("ingredientName = "..self.ingredientName)
	end
	--''pd()
end

function Tap:listPossibleIngredients()
	return {self.container and self.container.ingredientName or ""}
end

function Tap:onWorkStart(task)
	if (Tap.super.onWorkStart(self, task)) then
		if (self.container) then
			self.container.visible = true
			self.container.state = "prepare"
		end
		if (self.hideDuringWork) then
			self.visible = false
		end
	end
	self.clicked = false
	return true
end

function Tap:onWorkClick(task)
	self.clicked = true
	return true
end

function Tap:isSuccess(time)
	return time >= self.oneThirdWorkDuration and
		time <= self.oneThirdWorkDuration * 2
end

function Tap:onWorkUpdate(task, time)
	if (not self.clicked and task.timer.time >= self.oneThirdWorkDuration*1.25) then
		hintManager:openHint({hintId="TapReady", showButton=false, closeOnClickAnywhere=true, blockInputToLevel=false})
	end
	if (self.tapTimer) then
		self.tapTimer:setFraction(task.timer.fraction)
	end
	if (Tap.super.onWorkUpdate(self, task, time)) then
		return true
	end
	return self.clicked
end

function Tap:getProductCenter()
	if (self.container) then
		return self.container.screenCenter
	end
	return self.screenCenter
end

function Tap:onWorkFinish(task)
	if (self:isSuccess(task.timer.time)) then
		Tap.super.onWorkFinish(self, task)
		player:setNeverShowHint("HoneyReady")
		player:setNeverShowHint("TapReady")
		player.gameStats:incTimesNotSpilled()
	end

	if (self.container) then
		self.container.visible = false
		self.container.state = "inactive"
	end
	if (self.hideDuringWork) then
		self.visible = true
	end

	if (self.tapTimer) then
		self.tapTimer:setFraction(0.0)
	end
	self:defaultOnWorkFinish(task, success)
end

--' ************************************ Tap Timer ************************************ '--
TapTimer = deriveLuaClass("TapTimer", "Object")

function TapTimer:init(desc)
	TapTimer.superInit(self, desc)
end

function TapTimer:onLevelInitialized()
	self.pointer = level:getSpriteExt(self.pointerId or "")
end

function TapTimer:setFraction(frac)
	if (self.pointer) then
		self.pointer.rotation = 360 * frac
	end
end
