--' ************************************ Status Object ************************************ '--
StatusObject = deriveLuaClass("StatusObject", "SpriteExt")

StatusObject.statusTables = {
	{ "prepare", "ready", "decay", "inactive", },
	{ "empty", "stocked", "maxstock" },
	{ "workstart", "workfinish" },
}

function StatusObject:init(desc)
	StatusObject.superInit(self, desc)

	self.startState = self.startState or "inactive"
	for _,t in ipairs(self.statusTables) do
		for _,v in ipairs(t) do
			self:statusInit(v)
			if (v == self.startState) then
				self.statusTable = t
			end
		end
	end

	self:statusUpdate(self.startState, true)
end

function StatusObject:shouldShowState(state)
	return table.contains(self.statusTable, state)
end

function StatusObject:statusInit(status)
	self[status.."Visible"] = self[status.."Visible"] ~= false
	self[status.."Alpha"] = self[status.."Alpha"] or 1
	self[status.."FadeTime"] = self[status.."FadeTime"] or 120
	self[status.."Animation"] = self[status.."Animation"] or ""
end

function StatusObject:statusUpdate(status, init)
	if (init or self:shouldShowState(status)) then
		self:cancelAnimations()
		self.visible = self[status.."Visible"]
		if (init) then
			self.alpha = self[status.."Alpha"]
		else
			self:animate({alpha=self[status.."Alpha"], duration=self[status.."FadeTime"]})
		end
		if (self[status.."Frame"] and self[status.."Frame"] >= 0) then
			self.frame = self[status.."Frame"]
		end
		if (self[status.."DoAnimation"]) then
			self:playAnimation(self[status.."Animation"], self[status.."Cycles"], self[status.."FrameTime"], self[status.."WhenFinished"])
		end
	end
end

function StatusObject:status_onStartPreparing()
	self:statusUpdate("prepare")
end

function StatusObject:status_onBecomeAvailable()
	self:statusUpdate("ready")
end

function StatusObject:status_onDecay()
	self:statusUpdate("decay")
end

function StatusObject:status_onDeactivate()
	self:statusUpdate("inactive")
end

function StatusObject:status_onDisplayStockChange(obj)
	if (obj.usesStock) then
		if (not obj:checkStock()) then
			self:statusUpdate("empty")
		elseif (obj.stock == obj.maxStock) then
			self:statusUpdate("maxstock")
		else
			self:statusUpdate("stocked")
		end
	end
end

function StatusObject:status_onWorkStart()
	self:statusUpdate("workstart")
end

function StatusObject:status_onWorkFinish()
	self:statusUpdate("workfinish")
end
