--' ************************************ Stack ************************************ '--
Stack = deriveLuaClass("Stack", "IngredientButton")

function Stack:init(desc)
	Stack.superInit(self, desc)
end

function Stack:getStackProduct()
	local stack = self.ingredientName --' Always do at least one... Stock is handled elsewhere
	for i=2,self.stock do
		stack = stack..self.ingredientName
	end
	return stack
end

function Stack:getIngredientNameForLogic()
	return self:getStackProduct()
end

function Stack:getIngredientNameForTrayIcon()
	return self:getStackProduct()
end

function Stack:defaultOnCommit(productName, x, y)
	if (self.deactivateOnWorkFinish) then
		self.state = "inactive"
	end
	self:decStock(self.stock, true)
end
