--' ************************************ MemoryEgg Easter Egg ************************************ '--
MemoryEgg = deriveLuaClass("MemoryEgg", "DelDialog")

dialogs = dialogs or {}
dialogs.memory_egg = {
	class = "MemoryEgg", background = "BACKGROUND:easter", autoCenter = true,
	components = {
		{class="Sprite", x=22, y=298, name="BAR", image="BAR:easter"},
		{class="Button", x=512, y=731, name="BACK", image="BUTTON_BACK:default", anchor="top"},
	}
}

function MemoryEgg.initSource(obj)
	if (isString(obj)) then
		obj = level:getChild(obj)
	end
	if (isTable(obj)) then
		obj.easter_onClick = obj.easter_onClick or obj.onClick
		if (not obj.easter_onClick or obj.easter_onClick == Object.onClick) then
			obj.easter_onClick = function() end
		end
		obj.clickable = true
		obj.doHighlight = false
		obj.onClick = function()
			obj.numEasterClicks = (obj.numEasterClicks or 0) + 1
			if (obj.numEasterClicks >= 4) then
				local dlg = scene:createDialog("memory_egg")
				scene:openDialog(dlg)
				obj.numEasterClicks = 0
			else
				return obj:easter_onClick()
			end
			return true
		end
	end
end

function MemoryEgg:init(desc)
	MemoryEgg.superInit(self, desc)
end

function MemoryEgg:onShow()
	if (level and level.incPaused) then level:incPaused() end

	self.numX = 6
	self.numY = 3
	self.previewDuration = 3000
	self.turnDuration = 200
	self.startedGame = false
	self.turnBack = false
	self.room = (player and player.room) or math.Random(5)

	self.duration = (10 + 2.5*self.room) * 1000
	self.extraTime = 1500
	self.subTime = 0
	self.time = 0
	self.closing = false

	assert((self.numX * self.numY) % 2 == 0, "Not an even number of cards!")

	self:pickNewCards()
	self:createHeaderAnimation(0, 1)
end

function MemoryEgg:createHeaderAnimation(delay, type)
	self:animate({delay=delay},{call=function()
		if (type == 1) then
			local head1 = scene:newChild({class="Label", font="FONT_DAY_END_SCORE_MONEY_HEADING", textId="MEMORY_WELCOME", anchor="center", x=1024+200, y=200, scale=1.3, roundPos=false})
			head1:animate(
				{delay=0}, {x=512, duration=400, style="easeOut"},
				{delay=2000}, {x=-200, duration=400, style="easeIn"},
				{remove=true})
		end
		local head2 = scene:newChild({class="Label", font="FONT_INGAME_UNLOCK_FLOATER", textId="MEMORY_TITLE", anchor="center", x=1024+200, y=240, scale=1.3, roundPos=false})
		head2:animate(
			{delay=200}, {x=512, duration=400, style="easeOut"},
			{delay=2000}, {x=-200, duration=400, style="easeIn"},
			{remove=true})

		local head3 = scene:newChild({class="Label", font="FONT_DAY_END_SCORE_MONEY_HEADING", textId="MEMORY_MEMORY", anchor="center", x=1024+200, y=270, scale=1.3, roundPos=false})
		head3:animate(
			{delay=400}, {x=512, duration=400, style="easeOut"},
			{delay=2000}, {x=-200, duration=400, style="easeIn"},
			{remove=true})

		if (type == 2) then
			local solved = scene:newChild({class="Label", font="FONT_DAY_END_SCORE_MONEY_HEADING", textId="MEMORY_SOLVED", anchor="center", x=512, y=220, scale=0, roundPos=false})
			solved:animate({delay=1000},{scale=1.8, duration=300, dy=-30, style="easeIn"},{delay=1800},{alpha=0, duration=1000},{remove=true})
			self:animate({delay=3000},{call=function() self:close() end})
			scene:animate(
				{delay=200},
				{particle="EXPERT_EFFECT:particles", ex=240, ey=220},
				{delay=200},
				{particle="TARGET_EFFECT:particles", ex=784, ey=220},
				{delay=200},
				{particle="EXPERT_EFFECT:particles", ex=512, ey=560},
				{delay=1000},
				{particle="EXPERT_EFFECT:particles", ex=240, ey=220},
				{delay=200},
				{particle="TARGET_EFFECT:particles", ex=784, ey=220},
				{delay=200},
				{particle="EXPERT_EFFECT:particles", ex=512, ey=560}
			)
		end
		if (type == 3) then
			local solved = scene:newChild({class="Label", font="FONT_DAY_END_SCORE_MONEY_HEADING", textId="MEMORY_TIME_UP", anchor="center", x=512, y=220, scale=0, roundPos=false})
			solved:animate({delay=1000},{scale=1.8, duration=300, dy=-30, style="easeIn"},{delay=1800},{alpha=0, duration=1000},{remove=true})
			self:animate({delay=3000},{call=function() self:close() end})
		end
	end})
end

function MemoryEgg:getPos(xx, yy)
	return {x=187 + (xx-1)*130, y=195 + (yy-1)*190}
end

function MemoryEgg:pickNewCards()
	self.cards = {}

	local turnDelay = 100
	for y=1,self.numY do
		for x=1,self.numX do
			local p = self:getPos(x, y)
			local card = self:newChild({
				class="SpriteExt",
				baseAnimation="CARD"..self.room,
				defaultSection="easter",
				anchor="center",
				x=p.x, y=p.y,
				xx=x, yy=y, ii=#self.cards+1,
			})
			table.insert(self.cards, card)

			card.pic = card:newChild({
				class="SpriteExt",
				anchor="center",
			})
		end
	end

	self:animate({
		{delay=self.previewDuration},
		{call=function()
			for _,card in ipairs(self.cards) do
				self:hideCard(card, card.ii * turnDelay)
				card.busy = false --' Cancel the 'busy' flag
			end
		end},
		{delay=#self.cards*turnDelay + self.turnDuration},
		{call=function() self.startedGame = true end},
	})

	self.choices = Level.getAllImageResourcesRandom(self.numX * self.numY / 2, self.room)
	for _,v in ipairs(self.choices) do
		v.c, v.f, v.x, v.y, v.loop = -1, 100, 0, 0, true
		if (string.contains(v.name, "BUTTON#")) then
			v.loop = false
		end
	end

	local items = table.copy(self.cards, false)
	self:randomize(items)

	local idx = 1
	for _,m in ipairs(self.choices) do
		for i=1,2 do
			local c = m
			items[idx].match = m
			items[idx].type = c
			local p = items[idx].pic
			items[idx].name = c.res
			p.name = c.res
			p.defaultSection = c.section
			p.baseAnimation = c.name
			p:playAnimation("", 0)
			if (c.loop) then
				p:animate({startFrame=0, type="pingpong", frameTime=c.f, loop="forever"})
			end
			p.scale = math.min(math.min(1.5,
				(items[idx].width - 10*2) / p.width,
				(items[idx].height - 13*2) / p.height))
			p.location = c
			idx = idx + 1
			if (idx > #items) then break end
		end
		if (idx > #items) then break end
	end
end

function MemoryEgg:randomize(list)
	for i=1,#list*100 do
		local r1,r2 = math.Random(#list),math.Random(#list)
		list[r1], list[r2] = list[r2], list[r1]
	end
end

function MemoryEgg:showCard(card, delay, turnDuration)
	return self:turnCard(card, "CARD"..self.room, true, delay, turnDuration)
end

function MemoryEgg:hideCard(card, delay, turnDuration)
	return self:turnCard(card, "BACK", false, delay, turnDuration)
end

function MemoryEgg:turnCard(card, anim, picVisible, delay, turnDuration)
	turnDuration = turnDuration or self.turnDuration
	card.busy = true
	return card:animate(
		{delay=delay or 0},
		{scaleX=0.03, scaleY=1.2, skewY=0.08, duration=turnDuration/2},
		{scaleX=1, scaleY=1, skewY=0, duration=turnDuration/2, call=function()
			card:playAnimation(anim, 0)
			card.pic.visible = picVisible
			--card.color = "white"
		end},
		{delay=400},
		{call=function() card.busy = false end})
end

function MemoryEgg:swapCards(c1, c2, swapDuration)
	swapDuration = swapDuration or 500

	c1.xx, c2.xx = c2.xx, c1.xx
	c1.yy, c2.yy = c2.yy, c1.yy
	c1.ii, c2.ii = c2.ii, c1.ii

	c1.busy = true
	c2.busy = true

	local p1 = self:getPos(c1.xx, c1.yy)
	c1:animate({follow=true, target=p1, offset={x=-40, y=-200}, duration=swapDuration, style="easeOut"})
	self:addChild(c1)

	local p2 = self:getPos(c2.xx, c2.yy)
	c2:animate({follow=true, target=p2, offset={x=40, y=200}, duration=swapDuration, style="easeOut"})
	self:addChild(c2)
end

function MemoryEgg:tryCard(card, second)
	assert(not card.busy)
	self:showCard(card, 0, self.turnDuration)

	if (second) then
		local ok = (card.match == second.match)	
		if (ok) then
			--self:animate({delay=self.turnDuration}, {call=function()
			--	card.pic.currentCycles = card.type.c
			--	second.pic.currentCycles = second.type.c
			--end})			
		else
			self.turnBack = true
			self.card1 = card
			self.card2 = second
			self.time = self.time + self.subTime
		end

		second.solved = ok
		card.solved = ok

		local color = ok and "green" or "red"
		second:animate({delay=300},{blinkColor={startColor="white", endColor=color, fadeIn=100, fadeOut=100, loops=3}})
		card:animate({delay=300},{blinkColor={startColor="white", endColor=color, fadeIn=100, fadeOut=100, loops=3}})

		if (ok) then
			self:animate(
				{delay=400},
				{call=function()
					self:newChild({class="ParticleEffect", library="flash_effect:memories_ingame", x=second.x, y=second.y, scale=0.5, play=true})
				end},
				{delay=200},
				{call=function()
					self:newChild({class="ParticleEffect", library="flash_effect:memories_ingame", x=card.x, y=card.y, scale=0.5, play=true})
				end}
			)

			local head1 = self:newChild({class="Label", font="FONT_INGAME_UNLOCK_FLOATER", textId="MEMORY_MATCH", anchor="center", x=second.x, y=second.y-40, alpha=0, roundPos=false})
			local head2 = self:newChild({class="Label", font="FONT_INGAME_UNLOCK_FLOATER", textId="MEMORY_MATCH", anchor="center", x=card.x, y=card.y-40, alpha=0, roundPos=false})
			head1:animate({delay=300},{scale=1.6, duration=1200, dy=-20, style="easeOut"})
			head2:animate({delay=300},{scale=1.6, duration=1200, dy=-20, style="easeOut"})
			head1:animate({delay=200},{alpha=1, duration=200},{delay=900},{alpha=0, duration=200},{remove=true})
			head2:animate({delay=200},{alpha=1, duration=200},{delay=900},{alpha=0, duration=200},{remove=true})

			if (self:hasBeenSolved()) then
				self.closing = true
				self.inputActive = false
				self:createHeaderAnimation(800, 2)
			else
				self.time = math.max(self.time - self.extraTime, 0)
			end
		end
	end
end

function MemoryEgg:hasBeenSolved()
	for _,card in ipairs(self.cards) do
		if (not card.solved) then return false end
	end
	return true
end

function MemoryEgg:onMouseLeftDown(x, y)
	if (not self.startedGame or self.closing) then
		return
	end

	local clicked
	for _,card in ipairs(self.cards) do
		if (card:isInside(x,y)) then
			clicked = card
			break
		end
	end

	if (self.turnBack) then
		if ((clicked == self.card1 and self.card1.busy) or
			(clicked == self.card2 and self.card2.busy))
		then
			return
		end
		self.turnBack = false
		local turnDelay = 200
		self:hideCard(self.card1, 0, self.turnDuration*0.8)
		self:hideCard(self.card2, 0 + turnDelay, self.turnDuration*0.8)
	end

	if (clicked and
		not clicked.busy and
		not clicked.solved and
		clicked ~= self.selected)
	then
		if (clicked == self.selected) then
			self.selected = nil
		elseif (self.selected) then
			self:tryCard(clicked, self.selected)
			self.selected = nil
		else
			self:tryCard(clicked)
			self.selected = clicked
		end
	end
end

function MemoryEgg:onTick(time)
	self:tick(time)
	if (self.startedGame and not self.closing) then
		self.time = self.time + time
		local bar = self:child("BAR")
		local frac = self.time / self.duration
		bar:setClipRect(bar.x, bar.y + frac*bar.height, bar.width, bar.height)
		if (self.time >= self.duration) then
			self.closing = true
			local turnDelay = 180
			local turnTimer = 0
			for _,card in ipairs(self.cards) do
				if (not card.solved) then
					card:cancelAnimations()
					self:showCard(card, turnTimer)
					card:animate(
						{delay=turnTimer+400},
						{color={a=1.0,r=1.0,g=0.4,b=0.4}, duration=500})
					turnTimer = turnTimer + turnDelay
				end
			end
			self:animate(
			{delay=turnTimer},
			{call=function()
				self:createHeaderAnimation(800, 3)
			end})
		end		
	end
end

function MemoryEgg:handleCommand(command, sender)
	if (command == "BACK") then
		self.closing = true
		self:close()
	end
end

function MemoryEgg:onClose()
	self.closing = true
	if (level and level.incPaused) then level:decPaused() end
end
