--' ************************************ GameHouse Object Dialog ************************************ '--
dialogs.gamehouse_object = {
	class="DelDialog", autoCenter=true, doDarkenBackground=true, background="GH_DIALOG:gamescene",
	components = {
		{ class="Label", name="HEAD", x=207, y=20, font="FONT_DIALOG_TOP_HEADER:default", maxWidth=360, wrapStyle="wordwrap", },
		{ class="Sprite", name="PIC", x=207, y=200 },
		{ class="Label", name="TEXT", x=207, y=365, align="center", font="FONT_BALLOON_DIALOG:default", maxWidth=360, wrapStyle="wordwrap", lineHeight=18, },
		{ class="Button", name="OK", x=207, y=440, image="BUTTON_OK:default", clickSound="SOUND_BUTTON", soundSection="default", },
	},
}

--' ************************************ GameHouse Object ************************************ '--
GameHouseObject = deriveLuaClass("GameHouseObject", "Object")

function GameHouseObject:init(desc)
	GameHouseObject.superInit(self, desc)

	self.drawOutline = false
	self.clickable = true
	self.floaterPosition = self.floaterPosition or {x=0,y=-30}

	if (player:hasFoundGameHouseObject(self.gameHouseId)) then
		self.visible = false
	end
end

function GameHouseObject:onClick()
	if (self.visible) then
		self.clickable = false
		player:foundGameHouseObject(self.gameHouseId)

		local pos = {x=self.left + self.width/2, self.floaterPosition.x, y=self.top + self.floaterPosition.y}
		effects.createFloater(level.floaterLayer, ghf.getString("GH_FOUND"), pos.x, pos.y, 0)
		level:incPaused()

		local x = self.left + self.width/2
		local y = self.top + self.height/2
		scene:newChild({class="ParticleEffect", library="flash_effect", section="memories", x=x, y=y, start=true})

		self:animate({
			{alpha=0, duration=1}, {delay=80},
			{alpha=1, duration=1}, {delay=80},
			{alpha=0, duration=1}, {delay=80},
			{alpha=1, duration=1}, {delay=80},
			{alpha=0, duration=1}, {delay=80},
			{alpha=1, duration=1}, {delay=80},
			{alpha=0, duration=1}, {delay=80},
			{alpha=1, duration=1}, {delay=80},
			{alpha=0, duration=1}, {delay=80},
			{alpha=1, duration=1}, {delay=80},
			{alpha=0, duration=1}, {delay=80},
			{alpha=1, duration=1}, {delay=80},
			{call=function()
				local dlg = scene:createDialog("gamehouse_object")
				scene:openDialog(dlg)

				local items = {
					dlg:getChild("HEAD"),
					dlg:getChild("PIC"),
					dlg:getChild("TEXT"),
					dlg:getChild("OK"),
				}
				items[1].textId = "GH_OBJ_HEAD"..self.gameHouseId
				items[2].image = "GHOBJECT"..self.gameHouseId.."_BIG:gamescene"
				items[3].textId = "GH_OBJ_TEXT"..self.gameHouseId
				items[4].onClick = function()
					dlg:close()
					return true
				end
				dlg.onHide = function() level:decPaused() end

				local h = dlg.height - 20
				for i,v in ipairs(items) do
					v.anchor = "center"
					h = h - v.height
				end
				h = h/(#items+1)
				local y = 20/2 + h
				for i,v in ipairs(items) do
					v.y = y + v.height/2
					y = y + v.height + h
				end
			end},
			{remove=true},
		})
	end
end
