--' ************************************ Dispenser ************************************ '--
Dispenser = deriveLuaClass("Dispenser", "IngredientButton")

function Dispenser:init(desc)
	Dispenser.superInit(self, desc)

	self.ingredients = {}
	for i=1,20 do
		local ing = self["ing"..i]
		if (isString(ing) and ing ~= "") then
			table.push_back(self.ingredients, self:getIngredientNameFromResource(ing))
		end
	end

	self.currentIngredientIdx = 1
	self:setIngredientAndResource()
end

function Dispenser:setIngredientAndResource()
	--''pb("["..self.name.."] Dispenser setIngredientAndResource: "..ts(self.ingredients[self.currentIngredientIdx]))
	self.ingredientName = self.ingredients[self.currentIngredientIdx]
end

function Dispenser:listPossibleIngredients()
	return self.ingredients
end

function Dispenser:prepareGetIngredientForTrayLoop()
	self.trayIconIdx = self.currentIngredientIdx
end

function Dispenser:getIngredientNameForTrayIcon()
	local r = self.ingredients[self.trayIconIdx]
	self.trayIconIdx = self.trayIconIdx + 1
	if (self.trayIconIdx > #self.ingredients) then
		self.trayIconIdx = 1
	end
	return r
end

function Dispenser:defaultOnCommit(productName, x, y)
	--''pi("["..self.name.."] Dispenser defaultOnCommit: "..productName)
	Dispenser.super.defaultOnCommit(self, productName, x, y)

	self.currentIngredientIdx = self.currentIngredientIdx + 1
	if (self.currentIngredientIdx > #self.ingredients) then
		self.currentIngredientIdx = 1
	end
	self:setIngredientAndResource()
	--''pd()
end
