--' ************************************ Disco************************************ '--
Disco = deriveLuaClass("Disco", "Desk")

function Disco:init(desc)
	Disco.superInit(self, desc)
	self.djBonusScore = desc.djBonusScore or 1
	self.startAnimationInShift = desc.startAnimationInShift or 1
end

function Disco:onLevelInitialized()
	Disco.super.onLevelInitialized(self)
	if (level.currentShiftId >= self.startAnimationInShift) then
		self.baseAnimation = self.baseAnimation.."_animation"
		self.defaultCycles = -1
		self.defaultFrameTime = 150
	end

	self.dancingActive = false
	self.tileDelay = 0
	self.tiles = {}
	for i=1, 12 do
		local tile = level:getSpriteExt("discofloor_upgrade"..i)
		if (tile) then
			local glow = level:getSpriteExt("discofloor_upgrade"..i.."_glow")
			table.push_back(self.tiles, {tile=tile, glow=glow})
			glow.blendMode = "additive"
			glow.visible = false
		end
	end
end

function Disco:notify_onWorkStart(ing, task)
	local customers = level.customers
	for _,v in ipairs(customers) do
		if (v.group and
			v.group.place == "disco" and
			v.group.state == "Ordering" and
			v.group.order and
			v.group.order.currentStep and
			v.group.order.currentStep:removeProduct(ing.ingredientName, false))
		then
			v.group:onOrderDelivered()
			v.group:handleGroupMoneyAndTips(0)
			self.defaultCycles = -1
			self:playDefaultAnimation()

			local mi_lut = { ["#yellow_record"]=1, ["#purple_record"]=2, ["#green_record"]=3 }
			local musicId = mi_lut[ing.ingredientName] or math.Random(3)
			level:pauseMusic(true)
			self:loopSample("SOUND_STING"..tostring(musicId)..":sound")

			ing:defaultOnWorkStart(task)
			if (task.actor ~= hero) then
				task.duration = v.group.main:calcValue("danceTime", task.time)
			end

			self.dancingActive = true
			self.tileDelay = 0
			for _,v in ipairs(self.tiles) do
				v.tile.frame = math.Random(1, v.tile.frameCount-1)
				v.glow.frame = v.tile.frame
				v.glow.visible = math.Random(1000) < 500
			end
			return true
		end
	end
	return false
end

function Disco:onCharactersLeave(group)
	self.defaultCycles = 0
	self:playDefaultAnimation()
	
	level:pauseMusic(false)
	self:stopLoopSample()
	self.dancingActive = false
	
	local discofloor = level:getSpriteExt("disco_floor")
	if (discofloor) then
		local pos = group.main.floaterPosition
		local score = discofloor:calcValue("extraDiscofloorBonus")
		level:handleScore(score, pos.x, pos.y, false, 0)
		effects.createScoreFloater(level.floaterLayer, ghf.getString("R3_DISCOFLOOR_BONUS") .. score, pos.x, pos.y, score, 0)	
		--' Turn off disco floor
		for _,v in ipairs(self.tiles) do
			v.tile.frame = 0
			v.glow.visible = false
		end
	end	
end

function Disco:onTick(time)
	self:tick(time)
	if (self.dancingActive and #self.tiles > 0) then
		self.tileDelay = self.tileDelay - time
		if (self.tileDelay <= 0) then
			local choice = math.Random(1000)
			if (choice < 200) then
				self.tileDelay = self.tileDelay + 300
				for _,v in ipairs(self.tiles) do
					v.tile.frame = math.Random(1, v.tile.frameCount-1)
				end
			else
				self.tileDelay = self.tileDelay + 300
				local t1 = self.tiles[math.Random(#self.tiles)]
				local t2 = self.tiles[math.Random(#self.tiles)]
				t1.tile.frame = math.Random(1, t1.tile.frameCount-1)
				t2.tile.frame = math.Random(1, t2.tile.frameCount-1)
				t1.glow.frame = t1.tile.frame
				t2.glow.frame = t2.tile.frame
			end

			for i=1,4 do
				local tile = self.tiles[math.Random(#self.tiles)]
				tile.glow.visible = not tile.glow.visible
			end
		end
	end
end

function Disco:notify_checkTrayAvailable(ing, task)
	return true
end

function Disco:notify_onCommit(ing, productName, x, y)
	return true
end
