--' ************************************ Cooker ************************************ '--
Cooker = deriveLuaClass("Cooker", "StatusObject")

function Cooker:init(desc)
	Cooker.superInit(self, desc)
	self.productAppend = self.productAppend or "ready"
end

function Cooker:onLevelInitialized()
	Cooker.super.onLevelInitialized(self)

	self.buttons = {}
	for i=1,20 do
		local button = self["button"..i]
		if (button) then
			button = level:getSpriteExt(button)
			if (button) then
				button.state = "inactive"
				table.push_back(self.buttons, button)
			end
		end
	end

	if (isString(self.overlayObject)) then
		self.overlayObject = level:getSpriteExt(self.overlayObject)
	end
end

function Cooker:getAvailableButton()
	for _,v in ipairs(self.buttons) do
		if (v.state == "inactive") then
			return v
		end
	end
end

function Cooker:notify_onWorkStart(ing, task)
	local newProductName = self:getNewProductName(ing.ingredientName)
	--''pi(" -> cooks "..newProductName)
	if (not tray:makesValidProductOrStart(newProductName)) then
		--''pd("Not my problem")
		return nil --' Let ing handle it itself
	end

	if (not isTable(self:getAvailableButton())) then
		--''pr("Spot available? "..ts(isTable(self:getAvailableButton())))
		if (level:isValidProductOrStart(ing.ingredientName)) then
			tray:clearCurrentIngredients()
			--''pd("New product")
			return nil --' Let ing handle it itself
		end
		--''pd()
		return false
	end

	ing:defaultOnWorkStart(task)
	tray:startIngredient(task.duration, ing.compoundPosition, ing.compoundTipType, true)
	--''pd("notify_onWorkStart true")
	return true
end

function Cooker:getNewProductName(productName)
	return productName.."."..self.productAppend
end

function Cooker:notify_onCommit(ing, productName, x, y)
	local newProductName = self:getNewProductName(productName)
	if (not level:isValidProductOrStart(newProductName)) then
		return nil --' Let ing handle it itself
	end
	local button = self:getAvailableButton()
	local success = (button ~= nil)
	if (success) then
		button:setIngredientAndResource(newProductName)
		button.state = "prepare"
		local oldParent = button.parent
		local oldButtonLocation = button.location
		local oldAnchor = button.anchor
		button:becomeChildOf(level.topLayer)
		local targetLocation = button.location
		button.location = {x=x, y=y}
		button.anchor = "center"
		button:relocateAnchor(oldAnchor)
		button:animate({
			{call=function() self:playSample("SOUND_FOOD_TO_TRAY:sound") end},
			{follow=level.topLayer, target=targetLocation, offset=-200, duration=throwDuration},
			{call=function()
				self:playSample("SOUND_FOOD_ON_TRAY:sound")
				oldParent:addChild(button)
				button.location = oldButtonLocation
			end},
		})
		ing:defaultOnCommit(productName, x, y)
		tray:clearCurrentIngredients()
	end
	return success
end

function Cooker:showStatus(obj, status, anim)
	obj.visible = true
	if (self[status.."Frame"] >= 0) then
		obj.frame = self[status.."Frame"]
	elseif (self[status.."Cycles"] ~= 0) then
		obj:playAnimation(anim, self[status.."Cycles"], self[status.."FrameTime"], "stay")
	end
end

function Cooker:status_onStartPreparing(ing)
	--''pb("["..self.name.."] Cooker:status_onStartPreparing overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject) then
		self.overlayObject:status_onStartPreparing(ing)
	end
	Cooker.super.status_onStartPreparing(self, ing)
end

function Cooker:status_onBecomeAvailable(ing)
	--''pb("["..self.name.."] Cooker:status_onBecomeAvailable overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject) then
		self.overlayObject:status_onBecomeAvailable(ing)
	end
	Cooker.super.status_onBecomeAvailable(self, ing)
end

function Cooker:status_onDecay(ing)
	--''pb("["..self.name.."] Cooker:status_onDecay overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject) then
		self.overlayObject:status_onDecay(ing)
	end
	Cooker.super.status_onDecay(self, ing)
end

function Cooker:status_onDeactivate(ing)
	--''pb("["..self.name.."] Cooker:status_onDeactivate overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject) then
		self.overlayObject:status_onDeactivate(ing)
	end
	Cooker.super.status_onDeactivate(self, ing)
end
