--' ************************************ Clock ************************************ '--
Clock = deriveLuaClass("Clock", "SpriteExt")

function Clock:init(desc)
	Clock.superInit(self, desc)
	self.timeZone = self.timeZone or 0
end

function Clock:onTick(time)
	self:tick(time)
	if (not self.initedHands) then
		self.big_hand = level:getSpriteExt(self.bigHand)
		self.small_hand = level:getSpriteExt(self.smallHand)
		self.initedHands = true
	end
	if (self.big_hand) then
		local date = os.date("*t")
		if (self.minute ~= date.min) then
			local hours = (date.hour + self.timeZone) % 12
			local minutesAngle = (date.min / 60) * 360
			self.big_hand.rotation = (hours/12) * 360 + minutesAngle/12
			self.small_hand.rotation = minutesAngle
			self.minute = date.min
		end
	end
end
