--' ************************************ Cash Register ************************************ '--
CashRegister = deriveLuaClass("CashRegister", "Object")

function CashRegister:init(desc)
	CashRegister.superInit(self, desc)
	self.clickable = true
end

function CashRegister:onLevelInitialized()
	CashRegister.super.onLevelInitialized(self)
	self.queue = level.currentRoom.queueOut
end

function CashRegister:onClick()
	CashRegister.super.onClick(self)
	self:playSample("SOUND_CASH_REGISTER_CUSTOMER")
	return true
end

function CashRegister:onWorkStart(task)
	CashRegister.super.onWorkStart(self, task)
	local spots = self.queue.spots
	for _,v in ipairs(spots) do
		local c = v.inQueueCharacter
		if (c and c.group.state == "Paying") then
			return true
		end
	end
	return false
end

function CashRegister:onWorkFinish(task)
	CashRegister.super.onWorkFinish(self, task)

	level.counter:setBagsInactive()

	local spots = self.queue.spots
	local combo = 0
	local payDelay = 300
	
	local doSound = false
	for idx,v in ipairs(spots) do
		local c = v.inQueueCharacter
		if (c and c.group.state == "Paying") then
			local delay = (idx-1) * payDelay
			c.group:handleCustomerPay(delay)
			combo = combo + 1

			if (level.onCustomerPay) then
				level:onCustomerPay(c, self, delay)
			end		
		end
		doSound = true
	end
	
    if (combo > 1) then
        local score = self:calcValue("comboCheckout"..math.min(4, combo));
        local text = string.format(ghf.getString("TEXT_MONEY_MULTIPLE_CUSTOMER_PAY"), combo, score)
        level:handleScore(score,self.floaterPosition.x, self.floaterPosition.y, false, combo * payDelay);
        effects.createScoreFloater(level.floaterLayer, text, self.floaterPosition.x, self.floaterPosition.y, score, 0)
        if (combo == 3) then
			player.trophyManager:checkTrophyGoalReached(7)
			player.trophyManager:setComboTrophy(true)
			level:bm_IncCombo3Person()
		else
			player.trophyManager:setComboTrophy(false)
			level:bm_IncCombo2Person()
        end
    else
		player.trophyManager:setComboTrophy(false)
	end
	
	if (doSound) then
		self:playSample("SOUND_CASH_REGISTER_END")
	end
end
