--' ************************************ Special Treat Event ************************************ '--
SpecialTreatEvent = deriveLuaClass("SpecialTreatEvent", "Event")

--' Sample usage '--
--[[
levelDesc.eventDesc =
{
	class="SpecialTreatEvent",
	autoStart = true,
}
--]]

function SpecialTreatEvent:init(desc)
	SpecialTreatEvent.superInit(self, desc)

	self.useProgress = self.numTreats and self.numTreats > 0
	eventBar.showValue = self.useProgress
	eventBar.showTarget = self.useProgress
end

function SpecialTreatEvent:onInitialized()
	SpecialTreatEvent.super.onInitialized(self)
	
	if (self.hintArrowDesc and self.hintArrowDesc.parent) then
		local obj = level:getSpriteExt(self.hintArrowDesc.parent)
		if (obj) then
			local oldOnClick = obj.onClick or function() end
			obj.onClick = function()
				oldOnClick(obj)
				self:hideHintArrow()
				obj.onClick = oldOnClick
				return true
			end
		end
	end
end

function SpecialTreatEvent:onRemoveProductFromTray(product)
	local s = "#treat-"
	if (string.sub(product.name, 1, #s) == s) then
		local toRemove = {product}
		tray:removeProductsToTarget(toRemove, product.source)
		product.source:incStock(product.source.worth, true)
		return true
	end
	return false
end

function SpecialTreatEvent:onDeliver(order, owner)
	local products = tray.products
	local toRemove = {}
	
	for _,v in ipairs(products) do
		local s = "#treat-"
		if (not owner.main.hasSpecialTreat and string.sub(v.name, 1, #s) == s) then
			if (owner:acceptSpecialTreat(v.name)) then
				table.push_back(toRemove, v)
				break
			end
		end
	end
	if (#toRemove > 0) then
		tray:removeProductsToTarget(toRemove, owner.overheadObject)
		self.itemsDone = self.itemsDone + 1
		self:onProgress()
		self:onItemDone()
	end
end

function SpecialTreatEvent:getNumItemsTodo()
	return self.numTreats or 0
end
