--' ************************************ Fix Event ************************************ '--
FixEvent = deriveLuaClass("FixEvent", "Event")

--' Sample usage '--
--[[
levelDesc.eventDesc =
{
	class="FixEvent",
	items = {
		{ obj="scarecrow_upgrade_defect", swapObj="scarecrow_upgrade" },
	},
}
--]]

function FixEvent:init(desc)
	FixEvent.superInit(self, desc)

	--' Configuration variables
	self.fixAmount = self.fixAmount or 10000

	--' Status variables
	self.hintFired = false

	--' Override
	self.matchingItemType = "FixableObject"
end

function FixEvent:onInitialized()
	FixEvent.super.onInitialized(self)

	if (self.trackProgress) then
		eventBar.soundOnProgress = false
	end
	eventBar.showValue = not self.trackProgress
	eventBar.showTarget = not self.trackProgress
end

function FixEvent:showItem(item)
	FixEvent.super.showItem(self, item)

	if (item.base_animations and #item.base_animations > 0) then
		item.obj.baseAnimation = item.base_animations[1]
	end

	item.workAnimation = item.obj.workAnimation or self.workAnimation or "WORK"
	item.workAnimationFrameTime = item.obj.workFrameTime or self.workAnimationFrameTime or 200
	item.workDirection = item.obj.workDirection or self.workDirection or "up"
	
	item.fixAmount = item.fixAmount or item.obj.fixAmount or self.fixAmount
	item.bar = item.bar or self.bar or "progressbar_big"

	item.progress = 0
	--' TODO: remove? item.working = false

	item.obj.onClick = fixEventOnClick
	item.obj.onWorkStart = fixEventOnWorkStart
	item.obj.onWorkUpdate = fixEventOnWorkUpdate
	item.obj.onWorkFinish = fixEventOnWorkFinish
	item.obj.onWorkCancel = fixEventOnWorkCancel
	item.onRestoreItem = item.onRestoreItem or function() 	
		if (item.obj:getWorkCharacter()) then
			item.obj:getWorkCharacter().direction = "down"
			item.obj:getWorkCharacter():playDefaultAnimation()			
			taskSystem:cancelAllTasksFor(item.obj:getWorkCharacter())
		end
	end

	self:createProgressBar(item)
	if (not self.showHintOnStart) then
		self:showHint(item.obj)
	end
end

function FixEvent:onItemDone(item)
	FixEvent.super.onItemDone(self, item)
	
	if (item.base_animations and #item.base_animations > 0) then
		item.obj.baseAnimation = item.base_animations[#item.base_animations]
	else
		item.obj:showLastFrame()
	end
end

function FixEvent:getProgress()
	if (self.trackProgress) then
		local fixAmount, progress = 0, 0
		for _,item in ipairs(self.items) do
			fixAmount = fixAmount + item.fixAmount
			progress = progress + item.progress
		end
		return (fixAmount > 0 and progress / fixAmount) or 1
	end
	return FixEvent.super.getProgress(self)
end

--' ************************************ Fix Object ************************************ '--
FixableObject = deriveLuaClass("FixableObject", "EventObject")

function fixEventOnClick(self)
	if (self.event_onClick) then
		local handled = self:event_onClick(task)
		if (handled ~= nil) then return handled end
	end
	if (not self.item.done) then
		self.clickable = false
		hero:addTask({class="SetTask", positionLock=self})
		hero:addTask({class="WorkTask", target=self})
	end
	return true
end

function fixEventOnWorkStart(self, task)
	if (self.event_onWorkStart) then
		local handled = self:event_onWorkStart(task)
		if (handled ~= nil) then return handled end
	end
	event:hideHintArrow()
	if (not self.item.done) then
		task.actor.direction = self.item.workDirection
		task.actor:playAnimation(self.item.workAnimation, -1, self.item.workAnimationFrameTime)
		task.duration = self.item.fixAmount
		event:showProgressBar(self.item)
	end

	return true
end

function fixEventOnWorkUpdate(self, task, time)
	if (self.event_onWorkUpdate) then
		local handled = self:event_onWorkUpdate(task, time)
		if (handled ~= nil) then return handled end
	end
	self.item.progress = self.item.progress + time --' We cannot use the task's timer!
	local isDone = (self.item.progress >= self.item.fixAmount)
	local progress = math.min(1, self.item.progress / self.item.fixAmount)

	if (self.item.matchEventAppearance ~= false and event.matchItemAppearance ~= false) then
		if (self.item.base_animations and #self.item.base_animations > 0) then
			local c = #self.item.base_animations-1
			local idx = math.floor(math.min(progress * c, c)+1)
			if (self.baseAnimation ~= self.item.base_animations[idx]) then
				self.baseAnimation = self.item.base_animations[idx]
				if (self.stateChange) then
					self:stateChange()
				end
			end			
		else
			local c = self.frameCount-1
			local frame = math.min(progress * c, c)
			if (self.frame ~= frame) then
				self.frame = frame
				if (self.stateChange) then
					self:stateChange()
				end
			end
			print("change2")
		end
	end
	
	if (self.item.bar) then
		self.item.bar:setProgress(progress)
	end
	event:onProgress()
	return isDone or taskSystem:hasTaskFor(task.actor) or event.completed or level.hasShiftFinished
end

function fixEventOnWorkFinish(self, task)
	if (self.event_onWorkFinish) then
		local handled = self:event_onWorkFinish(task)
		if (handled ~= nil) then return handled end
	end
	task.actor.direction = "down"
	task.actor:playDefaultAnimation()
	local isDone = (self.item.progress >= self.item.fixAmount)
	if (isDone) then
		event:itemDone(self.item)
		if (self.stateChange) then
			self:stateChange()
		end
	else
		self.clickable = true
	end
end

function fixEventOnWorkCancel(self, task)
	if (self.event_onWorkCancel) then
		local handled = self:event_onWorkCancel(task)
		if (handled ~= nil) then return handled end
	end
	self.clickable = not self.item.done

end
