--' ************************************ Dance Event ************************************ '--
DanceEvent = deriveLuaClass("DanceEvent", "Event")

function DanceEvent:init(desc)
	DanceEvent.superInit(self, desc)

	--' Configuration variables
	self.scores = self.scores or {0, 0, 0}						--' A score for each dance move
	self.danceMoves = self.danceMoves or { {1}, {2}, {3}, {4} }
	self.dancerLostPositions = self.dancerLostPositions or
	{
		{x=180, y=150},
		{x=150, y=150},
		{x=120, y=150},
	}
	self.mainCharacter = self.mainCharacter or ""
	self.playCharacter = self.playCharacter or ""

	--' Status variables
	self.timer = 0
	self.indexDance = 0
	self.indexMove = 0
	self.dancerLostIdx = 0
	self.clicked = {}
	self.right = 0
	self.buttons = {}

	self.buttonPos =
	{
		{x=-94, y=-193},
		{x=-28, y=-246},
		{x=29, y=-191},
	}
	self.choices =
	{
		"STEP",
		"TWIRL",
		"DIP",
	}
	self.choicesButtonSound =
	{
		["STEP"] = "SOUND_DANCE_BUTTON_1",
		["TWIRL"] = "SOUND_DANCE_BUTTON_2",
		["DIP"] = "SOUND_DANCE_BUTTON_3",
	}
	self.choicesDanceSound =
	{
		["STEP"] = "SOUND_DANCE_STEP_1",
		["TWIRL"] = "SOUND_DANCE_STEP_2",
		["DIP"] = "SOUND_DANCE_STEP_3",
	}

	local choicesCount = {0, 0, 0}
	local picked = {}
	for i = 1,6 do
		local random = math.Random(#choicesCount)
		while (choicesCount[random] >= 3) do
			random = math.Random(#choicesCount)
		end

		table.insert(picked, self.choices[random])
		choicesCount[random] = choicesCount[random] + 1
	end

	self.danceSteps =
	{
		{ picked[1], picked[2], picked[3] },
		{ picked[2], picked[6], picked[5], picked[1] },
		{ picked[6], picked[1], picked[2], picked[5], picked[4] },
		{ picked[4], picked[3], picked[6], picked[1], picked[2], picked[5] },
	}
end

function DanceEvent:onInitialized()
	DanceEvent.super.onInitialized(self)

	eventBar.targetValue = #self.danceSteps
	eventBar.showValue = true
	eventBar.showTarget = true
end

function DanceEvent:onStart()
	DanceEvent.super.onStart(self)

	self.indexDance = self.indexDance + 1
	self.indexMove = 0

	self.mainCharacter = _G[self.mainCharacter] or level:getChild(self.mainCharacter)
	self.mainCharacter.playIdleAnimations = false
	assert(isTable(self.mainCharacter))

	self.playCharacter = _G[self.playCharacter] or level:getChild(self.playCharacter)
	self.playCharacter.playIdleAnimations = false
	assert(isTable(self.playCharacter))

	for i=1,#self.choices do
		local btnName = self.choices[i]
		local button = self.mainCharacter:newChild({
			class="Object",
			name=btnName,
			x=self.buttonPos[i].x,
			y=self.buttonPos[i].y,
			baseAnimation="EVENT_DANCE_MOVE_" .. self.choices[i],
			clickable=true,
			onClick=function()
				self:onClickButton(btnName)
			end
		})
		table.push_back(self.buttons, button)
	end

	--' Everyone should be in position
	level:fireTrigger("next move")

	hintManager:handle({id="start_dance", sprite=self.mainCharacter})
end

function DanceEvent:handleTrigger(trigger, meta)
	if (trigger == "next dance") then
	    if(level.eventThanks) then
	        level:eventThanks()
	    end

		self:gotoNextDance()
		return true

	elseif (trigger == "next move") then
		self:gotoNextMove()
		return true

	elseif (trigger == "enable buttons") then
		self.buttons[1].clickable = true
		self.buttons[2].clickable = true
		self.buttons[3].clickable = true
		return true

	elseif (trigger == "disable buttons") then
		self.buttons[1].clickable = false
		self.buttons[2].clickable = false
		self.buttons[3].clickable = false
		return true

	elseif (trigger == "delete buttons") then
		self.buttons[1].obsolete = true
		self.buttons[2].obsolete = true
		self.buttons[3].obsolete = true
		self.buttons[1] = nil
		self.buttons[2] = nil
		self.buttons[3] = nil
		return true

	elseif (trigger == "end event") then
		DelLevel.onShiftFinish(level)
		return true

	elseif (trigger == "inc score") then
		if (self.scores[self.indexDance] > 0) then
			--self.playCharacter:addScoreWithFloater(self.scores[self.indexDance])
		end
		return true

	elseif (trigger == "inc score bonus") then
		if (self.scoreAllDone and self.scoreAllDone > 0) then
			--self.playCharacter:addScoreWithFloater(self.scoreAllDone)
		end
		return true
	end

	return DanceEvent.super.handleTrigger(self, trigger, meta)
end

function DanceEvent:gotoNextDance()
	if (self.indexDance == table.getn(self.danceMoves)) then
		level:fireTrigger("disable buttons")
		level:fireTrigger("delete buttons")
		--' we did the final dance right: win + bonus
		level:fireTrigger("inc score bonus")
		self.mainCharacter:addTask({class="Task", duration=1000})
		if (isTable(taskSystem:getAnimationDesc("eventWon"))) then
			taskSystem:createAnimation("eventWon")
		else
			self.mainCharacter:addTask({class="TriggerTask", trigger="end event"})
		end
		return
	end

	self.indexDance = self.indexDance + 1
	self.indexMove = 0
	self:gotoNextMove()
end

function DanceEvent:gotoNextMove()
	level:fireTrigger("disable buttons")

	self.indexMove = self.indexMove + 1
	self.clicked = {}

	assert(self.danceMoves[self.indexDance][self.indexMove])
	--' Main character shows next move
	local animations = taskSystem:newAnimation("danceAnimations", false, {})
	animations = animations:add({class="Task", duration=1000})
	for index, value in ipairs(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]) do
		local button = self.mainCharacter:getChild(value)
		animations = animations:add({class="Task", actor=button, duration=800})
			:add({class="SetTask", actor=button, frame=1})
			:add({class="Task", actor=button, duration=2000})
			:also({class="PlayAnimationTask", actor=self.mainCharacter, animation=button.name, frameTime=75, cycles=1, wait=true})
			:add({class="SetTask", actor=button, frame=0})
	end

	animations:add({class="PlayAnimationTask", actor=self.mainCharacter, animation="IDLE", cycles=1, wait=false})
		:add({class="TriggerTask", trigger="enable buttons"})
end

function DanceEvent:onClickButton(buttonName)
	table.insert(self.clicked, buttonName)

	local curDanceTable = self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]

	for index, value in ipairs(self.clicked) do
		if (self.clicked[index] ~= curDanceTable[index]) then
			--' Clicked wrong
			level:fireTrigger("disable buttons")
			level:fireTrigger("delete buttons")
            --'self.playCharacter:qPlaySound("SOUND_EVENT_BAD")
			--'assert(self.choicesDanceSound)
			--'assert(self.choicesDanceSound[buttonName])
			--'self.playCharacter:qPlaySound(self.choicesDanceSound[buttonName])

			self.playCharacter:playSample("SND_MINIGAME_UNSUCCESSFUL:sound")

			self.playCharacter:addTask({class="PlayAnimationTask", animation=buttonName, frameTime=75, cycles=1, wait=true})
			self.playCharacter:addTask({class="PlayAnimationTask", animation="IDLE", cycles=1, wait=true})
			--'self.mainCharacter:qSetAppearance("SAD")
			self.playCharacter:addTask({class="Task", duration=450})
			self.dancerLostIdx = self.dancerLostIdx + 1
			if (isTable(taskSystem:getAnimationDesc("eventLost"))) then
				taskSystem:createAnimation("eventLost")
			else
				self.playCharacter:addTask({class="TriggerTask", trigger="end event"})
			end
			return --' Clicked wrong
		end
	end

	--' Clicked correct
	--'assert(self.choicesDanceSound)
	--'assert(self.choicesDanceSound[button])
	self.playCharacter:addTask({class="PlayAnimationTask", animation=buttonName, frameTime=75, cycles=1, wait=true})
	self.playCharacter:addTask({class="Task", duration=160})
	self.playCharacter:addTask({class="PlayAnimationTask", animation="IDLE", cycles=1, wait=true})

	if (table.getn(self.clicked) == table.getn(curDanceTable)) then
		--' All good
		--' Immediate effect
		--' Queue next
		level:fireTrigger("disable buttons")
		self.playCharacter:addTask({class="TriggerTask", trigger="inc score"})
		self.playCharacter:addTask({class="Task", duration=350})
		self.playCharacter:addTask({class="TriggerTask", trigger="next dance"})
		eventBar:incValue(1)
	else
		self.playCharacter:playSample("SND_MINIGAME_CORRECT:sound")
	end
end
